/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.servlet.DispatchedRequestUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ErrorAttributes {
    private final Integer statusCode;
    private final String message;
    private final String requestUri;
    private final String servletName;
    private final Class<? extends Throwable> exceptionType;
    private final Throwable exception;

    private ErrorAttributes(Integer statusCode, String message, String requestUri, String servletName, Class<? extends Throwable> exceptionType, Throwable exception) {
        this.statusCode = statusCode;
        this.message = message;
        this.requestUri = requestUri;
        this.servletName = servletName;
        this.exceptionType = exceptionType;
        this.exception = exception;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getServletName() {
        return this.servletName;
    }

    public Class<? extends Throwable> getExceptionType() {
        return this.exceptionType;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static ErrorAttributes of(HttpServletRequest request, String filterPrefix) {
        Args.notNull((Object)request, (String)"request");
        Integer code = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        String message = (String)request.getAttribute("jakarta.servlet.error.message");
        String uri = DispatchedRequestUtils.getRequestUri(request, "jakarta.servlet.error.request_uri", filterPrefix);
        String servlet = (String)request.getAttribute("jakarta.servlet.error.servlet_name");
        Class type = (Class)request.getAttribute("jakarta.servlet.error.exception_type");
        Throwable ex = (Throwable)request.getAttribute("jakarta.servlet.error.exception");
        if (!Strings.isEmpty((String)uri) || code != null || ex != null) {
            return new ErrorAttributes(code, message, uri, servlet, type, ex);
        }
        return null;
    }

    public String toString() {
        return "ErrorAttributes{statusCode=" + this.statusCode + ", message='" + this.message + "', requestUri='" + this.requestUri + "', servletName='" + this.servletName + "', exceptionType=" + String.valueOf(this.exceptionType) + ", exception=" + String.valueOf(this.exception) + "}";
    }
}

