/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.elasticsearch.security.query_role.RoleQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.elasticsearch.security.query_user.UserQuery;
import co.elastic.clients.elasticsearch.security.query_user.UserQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ExistsQuery
extends QueryBase
implements ApiKeyQueryVariant,
QueryVariant,
RoleQueryVariant,
UserQueryVariant {
    private final String field;
    public static final JsonpDeserializer<ExistsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExistsQuery::setupExistsQueryDeserializer);

    private ExistsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
    }

    public static ExistsQuery of(Function<Builder, ObjectBuilder<ExistsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.Exists;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Exists;
    }

    public RoleQuery.Kind _roleQueryKind() {
        return RoleQuery.Kind.Exists;
    }

    public UserQuery.Kind _userQueryKind() {
        return UserQuery.Kind.Exists;
    }

    public final String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
    }

    protected static void setupExistsQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExistsQuery> {
        private String field;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExistsQuery build() {
            this._checkSingleUse();
            return new ExistsQuery(this);
        }
    }
}

