/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.config;

import java.util.Objects;

public class ConfigurationPID {
    private final String pid;
    private final String factoryPid;
    private final String name;
    private static final String TILDE = "~";
    private static final String DASH = "-";

    public ConfigurationPID(String pid) {
        this.pid = pid;
        this.factoryPid = null;
        this.name = null;
    }

    public ConfigurationPID(String pid, String factoryPid, String name) {
        this.pid = pid;
        this.factoryPid = factoryPid;
        this.name = name;
    }

    public String getPid() {
        return this.pid;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFactory() {
        return Objects.nonNull(this.factoryPid);
    }

    public boolean isR7() {
        return this.pid.contains(TILDE);
    }

    public static ConfigurationPID parsePid(String pid) {
        int index;
        int n = index = pid.contains(TILDE) ? pid.indexOf(TILDE) : pid.indexOf(DASH);
        if (index > 0) {
            String factoryPid = pid.substring(0, index);
            String name = pid.substring(index + 1);
            return new ConfigurationPID(pid, factoryPid, name);
        }
        return new ConfigurationPID(pid);
    }

    public static ConfigurationPID parseFilename(String filename) {
        String pid = filename.substring(0, filename.lastIndexOf(46));
        return ConfigurationPID.parsePid(pid);
    }

    public static ConfigurationPID parseFilename(String filename, String extension) {
        String pid;
        if (extension.isEmpty()) {
            pid = filename;
        } else {
            String ending = String.format(".%s", extension);
            if (filename.endsWith(ending)) {
                pid = filename.substring(0, filename.length() - ending.length());
            } else {
                String message = String.format("Parsing filename failed. Filename '%s' does not have given extension '%s'.", filename, extension);
                throw new IllegalArgumentException(message);
            }
        }
        return ConfigurationPID.parsePid(pid);
    }
}

