/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.ucp;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.database.oracle.ucp.UCPDataPartitioningCallback;
import org.eclipse.persistence.sessions.Session;

public class GridLinkDataPartitioningCallback
extends UCPDataPartitioningCallback {
    protected static ThreadLocal<Integer> partitionId = new ThreadLocal();
    public static boolean isRegistered = false;

    @Override
    public void register(DataSource datSource, Session session) {
        if (isRegistered) {
            return;
        }
        GridLinkDataPartitioningCallback.register(session);
    }

    public static synchronized void register(Session session) {
        if (isRegistered) {
            return;
        }
        try {
            Class dataSourceManager = PrivilegedAccessHelper.getClassForName("weblogic.jdbc.common.internal.DataSourceManager");
            Method getInstance = PrivilegedAccessHelper.getMethod(dataSourceManager, "getInstance", null, false);
            Object instance = PrivilegedAccessHelper.invokeMethod(getInstance, null, null);
            Method getDataSourceService = PrivilegedAccessHelper.getMethod(instance.getClass(), "getDataSourceService", null, false);
            Object service = PrivilegedAccessHelper.invokeMethod(getDataSourceService, instance, null);
            Class[] argumentTypes = new Class[]{DataBasedConnectionAffinityCallback.class};
            Method registerDataAffinityCallback = PrivilegedAccessHelper.getMethod(service.getClass(), "registerDataAffinityCallback", argumentTypes, false);
            Object[] arguments = new Object[]{new GridLinkDataPartitioningCallback()};
            PrivilegedAccessHelper.invokeMethod(registerDataAffinityCallback, service, arguments);
            isRegistered = true;
        }
        catch (Exception exception) {
            session.getSessionLog().logThrowable(6, "connection", exception);
        }
    }

    @Override
    public void setPartitionId(int id) {
        partitionId.set(id);
    }

    @Override
    public int getPartitionId() {
        Integer id = partitionId.get();
        if (id == null) {
            return 0;
        }
        return id;
    }
}

