/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.store;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastSAMLMessageStore
implements SAMLMessageStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastSAMLMessageStore.class);
    private static final String MAP_NAME = HazelcastSAMLMessageStore.class.getSimpleName();
    private final HazelcastInstance hazelcastInstance;

    public HazelcastSAMLMessageStore(HazelcastInstance hazelcastInstance) {
        CommonHelper.assertNotNull((String)"hazelcastInstance", (Object)hazelcastInstance);
        this.hazelcastInstance = hazelcastInstance;
    }

    private IMap<String, String> getStoreMapInstance() {
        IMap inst = this.hazelcastInstance.getMap(MAP_NAME);
        LOGGER.debug("Located Hazelcast map instance [{}]", (Object)MAP_NAME);
        return inst;
    }

    public Optional<XMLObject> get(String messageID) {
        IMap<String, String> map = this.getStoreMapInstance();
        LOGGER.debug("Attempting to get message {} from Hazelcast map {}", (Object)messageID, (Object)MAP_NAME);
        String message = (String)map.get((Object)messageID);
        if (message == null) {
            LOGGER.debug("Message {} not found in Hazelcast map {}", (Object)messageID, (Object)MAP_NAME);
            return Optional.empty();
        }
        LOGGER.debug("Message {} found in Hazelcast map {}, clearing", (Object)messageID, (Object)MAP_NAME);
        map.remove((Object)messageID);
        return Configuration.deserializeSamlObject(new String(Base64.getDecoder().decode(message), StandardCharsets.UTF_8));
    }

    public void set(String messageID, XMLObject message) {
        IMap<String, String> map = this.getStoreMapInstance();
        LOGGER.debug("Storing message {} to Hazelcast map {}", (Object)messageID, (Object)MAP_NAME);
        map.put((Object)messageID, (Object)Base64.getEncoder().encodeToString(Configuration.serializeSamlObject(message).toString().getBytes(StandardCharsets.UTF_8)));
    }

    public void remove(String messageID) {
        IMap<String, String> map = this.getStoreMapInstance();
        LOGGER.debug("Removing message {} from Hazelcast map {}", (Object)messageID, (Object)MAP_NAME);
        map.remove((Object)messageID);
    }
}

