/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\u0011#\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004D\u0001\u0001\u0006IA\u000e\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002+\u0001A\u0003%A\nC\u0003V\u0001\u0011\u0005a\u000bC\u0003f\u0001\u0011\u0005a\u000bC\u0003h\u0001\u0011\u0005a\u000bC\u0003j\u0001\u0011\u0005a\u000bC\u0003l\u0001\u0011\u0005a\u000bC\u0003n\u0001\u0011\u0005a\u000bC\u0003p\u0001\u0011\u0005a\u000bC\u0003r\u0001\u0011\u0005a\u000bC\u0003t\u0001\u0011\u0005a\u000bC\u0003v\u0001\u0011\u0005a\u000bC\u0003x\u0001\u0011\u0005a\u000bC\u0003z\u0001\u0011\u0005a\u000bC\u0003|\u0001\u0011\u0005a\u000bC\u0003~\u0001\u0011\u0005a\u000bC\u0003\u0000\u0001\u0011\u0005a\u000b\u0003\u0004\u0002\u0004\u0001!\tA\u0016\u0005\u0007\u0003\u000f\u0001A\u0011\u0001,\t\r\u0005-\u0001\u0001\"\u0001W\u0011\u0019\ty\u0001\u0001C\u0001-\"1\u00111\u0003\u0001\u0005\u0002YCa!a\u0006\u0001\t\u00031\u0006BBA\u000e\u0001\u0011\u0005a\u000b\u0003\u0004~\u0001\u0011%\u0011q\u0004\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011%\t)\u0006AI\u0001\n\u0013\t9FA\fUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rV3ti*\u00111\u0005J\u0001\fiJ\fgn]1di&|gN\u0003\u0002&M\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001#\u0003\u0011!\u0018.\\3\u0016\u0003Y\u0002\"aN!\u000e\u0003aR!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003wq\naa]3sm\u0016\u0014(BA\u0014>\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tC$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0015A\u0014x\u000eZ;dKJLE-F\u0001G!\tYs)\u0003\u0002IY\t!Aj\u001c8h\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bA\u0001\\1oO*\t\u0011+\u0001\u0003kCZ\f\u0017BA*O\u0005\u0019\u0019FO]5oO\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u0014i\u0016\u001cH/\u00138ji&\fG.\u001b>f\u000bB|7\r\u001b\u000b\u0002/B\u00111\u0006W\u0005\u000332\u0012A!\u00168ji\"\u0012\u0001b\u0017\t\u00039\u000el\u0011!\u0018\u0006\u0003=~\u000b1!\u00199j\u0015\t\u0001\u0017-A\u0004kkBLG/\u001a:\u000b\u0005\t|\u0014!\u00026v]&$\u0018B\u00013^\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f\u001e(pe6\fG.\u00129pG\"\u0014U/\u001c9)\u0005%Y\u0016\u0001\u000b;fgR\u0014U/\u001c9Fa>\u001c\u0007NT8u\u00032dwn^3e\u0013\u001a,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007F\u0001\u0006\\\u0003)\"Xm\u001d;U_2,'/\u0019;f+B$\u0017\r^3US6,7\u000b[5gi\u0012+(/\u001b8h\u000bB|7\r\u001b\"v[BD#aC.\u0002gQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3Va\u0012\fG/\u001a+j[\u0016\u0014Vm]3u\tV\u0014\u0018N\\4Qe>$WoY3s\u0013\u0012\u0014v\u000e^1uS>t\u0007F\u0001\u0007\\\u0003!\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oO\u0006#G\rU1si&$\u0018n\u001c8tQ\ti1,\u0001\u0015uKN$Hk\u001c7fe\u0006$X\rV5nKNC\u0017N\u001a;EkJLgn\u001a)sKB\f'/Z\"p[6LG\u000f\u000b\u0002\u000f7\u00069C/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u0004&/\u001a9be\u0016\f%m\u001c:uQ\ty1,A\u0015uKN$Hk\u001c7fe\u0006$X\rV5nKNC\u0017N\u001a;EkJLgnZ\"p[BdW\r^3D_6l\u0017\u000e\u001e\u0015\u0003!m\u000b\u0001\u0006^3tiR{G.\u001a:bi\u0016$\u0016.\\3TQ&4G\u000fR;sS:<7i\\7qY\u0016$X-\u00112peRD#!E.\u0002KQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'/\u00114uKJ,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007F\u0001\n\\\u00031\"Xm\u001d;GK:\u001cW\r\u0015:pIV\u001cWM\u001d(pi\u0006cGn\\<fI&3\u0017\n^,pk2$wJ^3sM2|w\u000f\u000b\u0002\u00147\u0006!B/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012D#\u0001F.\u0002EQ,7\u000f\u001e*pi\u0006$X\r\u0015:pIV\u001cWM]%e\u0013:|enZ8j]\u001e\u001cF/\u0019;fQ\t)2,A\u0014uKN$(k\u001c;bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ%o!J,\u0007/\u0019:f\u0003\n|'\u000f^*uCR,\u0007F\u0001\f\\\u0003!\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&s\u0007K]3qCJ,7i\\7nSR\u001cF/\u0019;fQ\t92,\u0001\u0018uKN$\u0018\t\u001e;f[B$X\rZ#q_\u000eD')^7q/&$\bNT3xYf\u001c%/Z1uK\u0012lU\r^1eCR\f\u0007F\u0001\r\\\u0003\u0015\"Xm\u001d;Fa>\u001c\u0007NQ;na^KG\u000f[\"veJ,g\u000e^#q_\u000eD\u0007K]8wS\u0012,G\r\u000b\u0002\u001a7\u0006\u0019C/Z:u\u0003R$X-\u001c9uK\u0012,\u0005o\\2i\u0005Vl\u0007oV5uQ2\u000b7\u000f^#q_\u000eD\u0007F\u0001\u000e\\\u0003\u0015\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\r\u0016t7-\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u001c7\u0006!C/Z:u)J\fgn]1di&|gn\u0015;bi\u0016LE-\u00118e\u001d\u0006lW-T1qa&tw\r\u000b\u0002\u001d7\u0006\tC/Z:u\u00032dGK]1og\u0006\u001cG/[8o'R\fG/Z:Be\u0016l\u0015\r\u001d9fI\"\u0012Qd\u0017\u000b\u0004/\u0006\u0005\u0002bBA\u0012=\u0001\u0007\u0011QE\u0001\u0006gR\fG/\u001a\t\u0004g\u0005\u001d\u0012bAA\u0015E\t\u0001BK]1og\u0006\u001cG/[8o'R\fG/Z\u0001(aJ,\u0007/\u0019:f'V\u001c7-Z:tMVd\u0017J\\2sK6,g\u000e\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0006\u0005\u00020\u0005U\u0012qHA(!\r\u0019\u0014\u0011G\u0005\u0004\u0003g\u0011#A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006Dq!a\u000e \u0001\u0004\tI$A\u0006uq:lU\r^1eCR\f\u0007cA\u001a\u0002<%\u0019\u0011Q\b\u0012\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\u0005\u0005s\u00041\u0001\u0002D\u0005)R\r\u001f9fGR,G\r\u0015:pIV\u001cWM]#q_\u000eD\u0007#B\u0016\u0002F\u0005%\u0013bAA$Y\t1q\n\u001d;j_:\u00042aKA&\u0013\r\ti\u0005\f\u0002\u0006'\"|'\u000f\u001e\u0005\n\u0003#z\u0002\u0013!a\u0001\u0003'\n1A\\8x!\u0011Y\u0013Q\t$\u0002cA\u0014X\r]1sKN+8mY3tg\u001a,H.\u00138de\u0016lWM\u001c;Qe>$WoY3s\u000bB|7\r\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\f\u0016\u0005\u0003'\nYf\u000b\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!C;oG\",7m[3e\u0015\r\t9\u0007L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA6\u0003C\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()));
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().milliseconds() - 1L))));
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)fencingTransitMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)fencingTransitMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testRotateProducerIdInOngoingState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareAbortState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareCommitState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$));
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        Either result = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, x$10, x$9).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds());
        Assertions.assertEquals((Object)new Left((Object)Errors.PRODUCER_FENCED), (Object)result);
    }

    @Test
    public void testTransactionStateIdAndNameMapping() {
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)state -> {
            TransactionMetadataTest.$anonfun$testTransactionStateIdAndNameMapping$1(state);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllTransactionStatesAreMapped() {
        Set unmatchedStates = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{Empty$.MODULE$, Ongoing$.MODULE$, PrepareCommit$.MODULE$, PrepareAbort$.MODULE$, CompleteCommit$.MODULE$, CompleteAbort$.MODULE$, PrepareEpochFence$.MODULE$, Dead$.MODULE$}));
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMetadataTest.$anonfun$testAllTransactionStatesAreMapped$1(unmatchedStates, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)unmatchedStates);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, -1, 30000, state, x$8, x$10, x$9);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    private TxnTransitMetadata prepareSuccessfulIncrementProducerEpoch(TransactionMetadata txnMetadata, Option<Object> expectedProducerEpoch, Option<Object> now) {
        Either result = txnMetadata.prepareIncrementProducerEpoch(30000, expectedProducerEpoch, BoxesRunTime.unboxToLong((Object)now.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.time().milliseconds())));
        return (TxnTransitMetadata)result.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(42).append("prepareIncrementProducerEpoch failed with ").append(result).toString());
        });
    }

    private Option<Object> prepareSuccessfulIncrementProducerEpoch$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$testTransactionStateIdAndNameMapping$1(TransactionState state) {
        Assertions.assertEquals((Object)state, (Object)TransactionState$.MODULE$.fromId(state.id()));
        Assertions.assertEquals((Object)new Some((Object)state), (Object)TransactionState$.MODULE$.fromName(state.name()));
        if (!state.equals(Dead$.MODULE$)) {
            org.apache.kafka.clients.admin.TransactionState clientTransactionState = org.apache.kafka.clients.admin.TransactionState.parse((String)state.name());
            Assertions.assertEquals((Object)state.name(), (Object)clientTransactionState.toString());
            Assertions.assertNotEquals((Object)org.apache.kafka.clients.admin.TransactionState.UNKNOWN, (Object)clientTransactionState);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testAllTransactionStatesAreMapped$1(Set unmatchedStates$1, TransactionState x0$1) {
        if (Empty$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Empty$.MODULE$));
            return;
        }
        if (Ongoing$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Ongoing$.MODULE$));
            return;
        }
        if (PrepareCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareCommit$.MODULE$));
            return;
        }
        if (PrepareAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareAbort$.MODULE$));
            return;
        }
        if (CompleteCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteCommit$.MODULE$));
            return;
        }
        if (CompleteAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteAbort$.MODULE$));
            return;
        }
        if (PrepareEpochFence$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareEpochFence$.MODULE$));
            return;
        }
        if (Dead$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Dead$.MODULE$));
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

