/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Base64;
import org.identityconnectors.framework.common.objects.SyncToken;

class SyncTokenSerializer
extends JsonSerializer<SyncToken> {
    SyncTokenSerializer() {
    }

    public void serialize(SyncToken source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        if (source.getValue() == null) {
            jgen.writeNullField("value");
        } else {
            Object object = source.getValue();
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                jgen.writeStringField("type", Boolean.class.getSimpleName());
                jgen.writeBooleanField("value", b.booleanValue());
            } else {
                object = source.getValue();
                if (object instanceof Double) {
                    Double v = (Double)object;
                    jgen.writeStringField("type", Double.class.getSimpleName());
                    jgen.writeNumberField("value", v.doubleValue());
                } else {
                    object = source.getValue();
                    if (object instanceof Long) {
                        Long l = (Long)object;
                        jgen.writeStringField("type", Long.class.getSimpleName());
                        jgen.writeNumberField("value", l.longValue());
                    } else {
                        object = source.getValue();
                        if (object instanceof Integer) {
                            Integer i = (Integer)object;
                            jgen.writeStringField("type", Integer.class.getSimpleName());
                            jgen.writeNumberField("value", i.intValue());
                        } else {
                            object = source.getValue();
                            if (object instanceof byte[]) {
                                byte[] bytes = (byte[])object;
                                jgen.writeStringField("value", Base64.getEncoder().encodeToString(bytes));
                            } else {
                                jgen.writeStringField("type", String.class.getSimpleName());
                                jgen.writeStringField("value", source.getValue().toString());
                            }
                        }
                    }
                }
            }
        }
        jgen.writeEndObject();
    }
}

