/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.aot.hint;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.BeanReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.method.AuthorizeReturnObject;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

public final class PrePostAuthorizeExpressionBeanHintsRegistrar
implements SecurityHintsRegistrar {
    private final SecurityAnnotationScanner<PreAuthorize> preAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PreAuthorize.class);
    private final SecurityAnnotationScanner<PostAuthorize> postAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PostAuthorize.class);
    private final SecurityAnnotationScanner<AuthorizeReturnObject> authorizeReturnObjectScanner = SecurityAnnotationScanners.requireUnique(AuthorizeReturnObject.class);
    private final SpelExpressionParser expressionParser = new SpelExpressionParser();
    private final Set<Class<?>> visitedClasses = new HashSet();
    private final List<Class<?>> toVisit;

    public PrePostAuthorizeExpressionBeanHintsRegistrar(Class<?> ... toVisit) {
        this(Arrays.asList(toVisit));
    }

    public PrePostAuthorizeExpressionBeanHintsRegistrar(List<Class<?>> toVisit) {
        Assert.notEmpty(toVisit, (String)"toVisit cannot be empty");
        Assert.noNullElements(toVisit, (String)"toVisit cannot contain null elements");
        this.toVisit = toVisit;
    }

    @Override
    public void registerHints(RuntimeHints hints, ConfigurableListableBeanFactory beanFactory) {
        HashSet<String> expressions = new HashSet<String>();
        for (Class<?> bean : this.toVisit) {
            expressions.addAll(this.extractSecurityExpressions(bean));
        }
        HashSet<String> beanNamesToRegister = new HashSet<String>();
        for (String expression : expressions) {
            beanNamesToRegister.addAll(this.extractBeanNames(expression));
        }
        for (String toRegister : beanNamesToRegister) {
            Class type = beanFactory.getType(toRegister, false);
            if (type == null) continue;
            hints.reflection().registerType(TypeReference.of((Class)type), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
        }
    }

    private Set<String> extractSecurityExpressions(Class<?> clazz) {
        if (this.visitedClasses.contains(clazz)) {
            return Collections.emptySet();
        }
        this.visitedClasses.add(clazz);
        HashSet<String> expressions = new HashSet<String>();
        for (Method method : clazz.getDeclaredMethods()) {
            AuthorizeReturnObject authorizeReturnObject;
            PreAuthorize preAuthorize = this.preAuthorizeScanner.scan(method, clazz);
            PostAuthorize postAuthorize = this.postAuthorizeScanner.scan(method, clazz);
            if (preAuthorize != null) {
                expressions.add(preAuthorize.value());
            }
            if (postAuthorize != null) {
                expressions.add(postAuthorize.value());
            }
            if ((authorizeReturnObject = this.authorizeReturnObjectScanner.scan(method, clazz)) == null) continue;
            expressions.addAll(this.extractSecurityExpressions(method.getReturnType()));
        }
        return expressions;
    }

    private Set<String> extractBeanNames(String rawExpression) {
        SpelExpression expression = this.expressionParser.parseRaw(rawExpression);
        SpelNode node = expression.getAST();
        HashSet<String> beanNames = new HashSet<String>();
        this.resolveBeanNames(beanNames, node);
        return beanNames;
    }

    private void resolveBeanNames(Set<String> beanNames, SpelNode node) {
        int childCount;
        if (node instanceof BeanReference) {
            BeanReference br = (BeanReference)node;
            beanNames.add(br.getName());
        }
        if ((childCount = node.getChildCount()) == 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            this.resolveBeanNames(beanNames, node.getChild(i));
        }
    }
}

