/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.Collection;
import java.util.List;
import org.springframework.expression.Expression;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.support.management.ControlBusCommandRegistry;
import org.springframework.messaging.Message;
import org.springframework.util.CollectionUtils;

public class ControlBusMessageProcessor
extends AbstractMessageProcessor<Object>
implements IntegrationPattern {
    private ControlBusCommandRegistry controlBusCommandRegistry;

    public ControlBusMessageProcessor() {
    }

    public ControlBusMessageProcessor(ControlBusCommandRegistry controlBusCommandRegistry) {
        this.controlBusCommandRegistry = controlBusCommandRegistry;
    }

    @Override
    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.control_bus;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.controlBusCommandRegistry == null) {
            this.controlBusCommandRegistry = (ControlBusCommandRegistry)this.getBeanFactory().getBean(ControlBusCommandRegistry.class);
        }
    }

    @Override
    public Object processMessage(Message<?> message) {
        String command = message.getPayload().toString();
        List arguments = (List)message.getHeaders().get((Object)"controlBusArguments", List.class);
        Class[] parameterTypes = new Class[]{};
        if (!CollectionUtils.isEmpty((Collection)arguments)) {
            parameterTypes = (Class[])arguments.stream().map(Object::getClass).toArray(Class[]::new);
        }
        Expression commandExpression = this.controlBusCommandRegistry.getExpressionForCommand(command, parameterTypes);
        return this.evaluateExpression(commandExpression, (Object)arguments);
    }
}

