/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.context.IntegrationContextUtils;

class IntegrationConfigurationReport
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final LogAccessor LOGGER = new LogAccessor(IntegrationConfigurationReport.class);
    private ApplicationContext applicationContext;

    IntegrationConfigurationReport() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.applicationContext)) {
            this.report();
        }
    }

    private void report() {
        this.printIntegrationProperties();
    }

    private void printIntegrationProperties() {
        if (LOGGER.isDebugEnabled()) {
            Properties integrationProperties = IntegrationContextUtils.getIntegrationProperties((BeanFactory)this.applicationContext).toProperties();
            StringWriter writer = new StringWriter();
            integrationProperties.list(new PrintWriter(writer));
            StringBuffer propertiesBuffer = writer.getBuffer().delete(0, "-- listing properties --".length());
            LOGGER.debug((CharSequence)("\nSpring Integration global properties:\n" + String.valueOf(propertiesBuffer)));
        }
    }
}

