/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.common;

import com.googlecode.cqengine.resultset.ResultSet;
import java.util.Comparator;

public class QueryCostComparators {
    private static final Comparator<ResultSet> RETRIEVAL_COST_COMPARATOR = new RetrievalCostComparator();
    private static final Comparator<ResultSet> MERGE_COST_COMPARATOR = new MergeCostComparator();

    public static Comparator<ResultSet> getRetrievalCostComparator() {
        return RETRIEVAL_COST_COMPARATOR;
    }

    public static Comparator<ResultSet> getMergeCostComparator() {
        return MERGE_COST_COMPARATOR;
    }

    static class MergeCostComparator
    implements Comparator<ResultSet> {
        MergeCostComparator() {
        }

        @Override
        public int compare(ResultSet o1, ResultSet o2) {
            int o2MergeCost;
            int o1MergeCost = o1.getMergeCost();
            if (o1MergeCost < (o2MergeCost = o2.getMergeCost())) {
                return -1;
            }
            if (o1MergeCost > o2MergeCost) {
                return 1;
            }
            return 0;
        }
    }

    static class RetrievalCostComparator
    implements Comparator<ResultSet> {
        RetrievalCostComparator() {
        }

        @Override
        public int compare(ResultSet o1, ResultSet o2) {
            int o2RetrievalCost;
            int o1RetrievalCost = o1.getRetrievalCost();
            if (o1RetrievalCost < (o2RetrievalCost = o2.getRetrievalCost())) {
                return -1;
            }
            if (o1RetrievalCost > o2RetrievalCost) {
                return 1;
            }
            return 0;
        }
    }
}

