/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultCallbackClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.savedrequest.DefaultSavedRequestHandler;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCallbackLogic
extends AbstractExceptionAwareLogic
implements CallbackLogic {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCallbackLogic.class);
    public static final DefaultCallbackLogic INSTANCE = new DefaultCallbackLogic();
    private ClientFinder clientFinder = new DefaultCallbackClientFinder();
    private SavedRequestHandler savedRequestHandler = new DefaultSavedRequestHandler();

    @Override
    public Object perform(Config config, String inputDefaultUrl, Boolean inputRenewSession, String defaultClient, FrameworkParameters parameters) {
        HttpAction action;
        LOGGER.debug("=== CALLBACK ===");
        CallContext ctx = this.buildContext(config, parameters);
        WebContext webContext = ctx.webContext();
        HttpActionAdapter httpActionAdapter = config.getHttpActionAdapter();
        CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
        try {
            CommonHelper.assertNotNull("clientFinder", this.clientFinder);
            String defaultUrl = Objects.requireNonNullElse(inputDefaultUrl, "/");
            boolean renewSession = inputRenewSession == null || inputRenewSession != false;
            CommonHelper.assertNotBlank("defaultUrl", defaultUrl);
            Clients clients = config.getClients();
            CommonHelper.assertNotNull("clients", clients);
            List<Client> foundClients = this.clientFinder.find(clients, webContext, defaultClient);
            CommonHelper.assertTrue(foundClients != null && foundClients.size() == 1, "unable to find one indirect client for the callback: check the callback URL for a client name parameter or suffix path or ensure that your configuration defaults to one indirect client");
            Client foundClient = foundClients.get(0);
            LOGGER.debug("foundClient: {}", (Object)foundClient);
            CommonHelper.assertNotNull("foundClient", foundClient);
            Credentials credentials = foundClient.getCredentials(ctx).orElse(null);
            LOGGER.debug("extracted credentials: {}", (Object)credentials);
            credentials = foundClient.validateCredentials(ctx, credentials).orElse(null);
            LOGGER.debug("validated credentials: {}", (Object)credentials);
            if (credentials != null && !credentials.isForAuthentication()) {
                action = foundClient.processLogout(ctx, credentials);
            } else {
                if (credentials != null) {
                    Optional<UserProfile> optProfile = foundClient.getUserProfile(ctx, credentials);
                    LOGGER.debug("optProfile: {}", optProfile);
                    if (optProfile.isPresent()) {
                        UserProfile profile = optProfile.get();
                        Boolean saveProfileInSession = ((BaseClient)foundClient).getSaveProfileInSession(webContext, profile);
                        boolean multiProfile = ((BaseClient)foundClient).isMultiProfile(webContext, profile);
                        LOGGER.debug("saveProfileInSession: {} / multiProfile: {}", (Object)saveProfileInSession, (Object)multiProfile);
                        this.saveUserProfile(ctx, config, profile, saveProfileInSession, multiProfile, renewSession);
                    }
                }
                action = this.redirectToOriginallyRequestedUrl(ctx, defaultUrl);
            }
        }
        catch (RuntimeException e) {
            return this.handleException(e, httpActionAdapter, webContext);
        }
        return httpActionAdapter.adapt(action, webContext);
    }

    protected void saveUserProfile(CallContext ctx, Config config, UserProfile profile, boolean saveProfileInSession, boolean multiProfile, boolean renewSession) {
        ProfileManager manager = (ProfileManager)ctx.profileManagerFactory().apply(ctx.webContext(), ctx.sessionStore());
        if (profile != null) {
            manager.save(saveProfileInSession, profile, multiProfile);
            if (renewSession) {
                this.renewSession(ctx, config);
            }
        }
    }

    protected void renewSession(CallContext ctx, Config config) {
        WebContext context = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        Optional<String> optOldSessionId = sessionStore.getSessionId(context, true);
        if (optOldSessionId.isEmpty()) {
            LOGGER.error("No old session identifier retrieved although the session creation has been requested");
        } else {
            String oldSessionId = optOldSessionId.get();
            boolean renewed = sessionStore.renewSession(context);
            if (renewed) {
                Optional<String> optNewSessionId = sessionStore.getSessionId(context, true);
                if (optNewSessionId.isEmpty()) {
                    LOGGER.error("No new session identifier retrieved although the session creation has been requested");
                } else {
                    String newSessionId = optNewSessionId.get();
                    LOGGER.debug("Renewing session: {} -> {}", (Object)oldSessionId, (Object)newSessionId);
                    Clients clients = config.getClients();
                    if (clients != null) {
                        List<Client> clientList = clients.getClients();
                        for (Client client : clientList) {
                            BaseClient baseClient = (BaseClient)client;
                            baseClient.notifySessionRenewal(ctx, oldSessionId);
                        }
                    }
                }
            } else {
                LOGGER.error("Unable to renew the session. The session store may not support this feature");
            }
        }
    }

    protected HttpAction redirectToOriginallyRequestedUrl(CallContext ctx, String defaultUrl) {
        return this.savedRequestHandler.restore(ctx, defaultUrl);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SavedRequestHandler getSavedRequestHandler() {
        return this.savedRequestHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultCallbackLogic setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultCallbackLogic setSavedRequestHandler(SavedRequestHandler savedRequestHandler) {
        this.savedRequestHandler = savedRequestHandler;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DefaultCallbackLogic(super=" + super.toString() + ", clientFinder=" + this.clientFinder + ", savedRequestHandler=" + this.savedRequestHandler + ")";
    }
}

