/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class AdhocSubProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AdhocSubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AdhocSubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("AdhocSubProcess", AdhocSubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(AdhocSubProcess.class, AdhocSubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "AdhocSubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        AdhocSubProcess subProcess = (AdhocSubProcess)baseElement;
        propertiesNode.put("completioncondition", subProcess.getCompletionCondition());
        propertiesNode.put("ordering", subProcess.getOrdering());
        propertiesNode.put("cancelremaininginstances", subProcess.isCancelRemainingInstances());
        ArrayNode subProcessShapesArrayNode = JSON_MAPPER.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(subProcess.getId());
        this.processor.processFlowElements((FlowElementsContainer)subProcess, this.model, subProcessShapesArrayNode, converterContext, graphicInfo.getX(), graphicInfo.getY());
        this.flowElementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        AdhocSubProcess subProcess = new AdhocSubProcess();
        subProcess.setCompletionCondition(JsonConverterUtil.getPropertyValueAsString("completioncondition", elementNode));
        subProcess.setOrdering(JsonConverterUtil.getPropertyValueAsString("ordering", elementNode));
        subProcess.setCancelRemainingInstances(JsonConverterUtil.getPropertyValueAsBoolean("cancelremaininginstances", elementNode));
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap, converterContext, this.model);
        return subProcess;
    }
}

