/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.impl.api.ConnectorFacadeFactoryImpl;
import org.identityconnectors.framework.impl.api.local.LocalConnectorFacadeImpl;

public class ManagedConnectorFacadeFactoryImpl
extends ConnectorFacadeFactoryImpl {
    private static final Log LOG = Log.getLog(ManagedConnectorFacadeFactoryImpl.class);
    private static final ConcurrentMap<String, ConnectorFacade> CACHE = new ConcurrentHashMap<String, ConnectorFacade>();

    @Override
    public ConnectorFacade newInstance(APIConfiguration config) {
        ConnectorFacade facade = super.newInstance(config);
        ConnectorFacade ret = CACHE.putIfAbsent(facade.getConnectorFacadeKey(), facade);
        if (null != ret) {
            LOG.ok("ConnectorFacade found in cache", new Object[0]);
            facade = ret;
        }
        return facade;
    }

    @Override
    public ConnectorFacade newInstance(ConnectorInfo connectorInfo, String config) {
        ConnectorFacade ret;
        ConnectorFacade facade = (ConnectorFacade)CACHE.get(config);
        if (null == facade && null != (ret = CACHE.putIfAbsent((facade = super.newInstance(connectorInfo, config)).getConnectorFacadeKey(), facade))) {
            LOG.ok("ConnectorFacade found in cache", new Object[0]);
            facade = ret;
        }
        return facade;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (ConnectorFacade facade : CACHE.values()) {
            if (!(facade instanceof LocalConnectorFacadeImpl)) continue;
            try {
                facade.dispose();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "Failed to dispose facade: {0}", new Object[]{facade});
            }
        }
        CACHE.clear();
    }
}

