<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [0.20.4](https://github.com/apache/superset/compare/v0.20.3...v0.20.4) (2024-12-10)

**Note:** Version bump only for package @superset-ui/core

# [0.20.0](https://github.com/apache/superset/compare/v2021.41.0...v0.20.0) (2024-09-09)

### Bug Fixes

- [sc-54864] Adds safety check to provide near term fix to save query ([#21034](https://github.com/apache/superset/issues/21034)) ([ab6ec89](https://github.com/apache/superset/commit/ab6ec89f680dbf022a39ed568c6fcdce0439b2dd))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **annotation:** Address regression from [#24694](https://github.com/apache/superset/issues/24694) ([#24874](https://github.com/apache/superset/issues/24874)) ([f05638b](https://github.com/apache/superset/commit/f05638ba845596faef088efa3ee98686d26dad26))
- avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied ([#20173](https://github.com/apache/superset/issues/20173)) ([365acee](https://github.com/apache/superset/commit/365acee663f7942ba7d8dfd0e4cf72c4cecb7a2d))
- BIGINT rendering regression in chartAction ([#21937](https://github.com/apache/superset/issues/21937)) ([4002406](https://github.com/apache/superset/commit/40024064ae35e596215a79d98ed8d0b4a90847f2))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- **charts:** big-number display broken in echarts ([#24492](https://github.com/apache/superset/issues/24492)) ([3f17945](https://github.com/apache/superset/commit/3f179457457bc2a21a824895aa1cd99b586d9ea0))
- **chart:** Set max row limit + removed the option to use an empty row limit value ([#26151](https://github.com/apache/superset/issues/26151)) ([863f8bb](https://github.com/apache/superset/commit/863f8bbbcdd078814973d444368c12e06ad0c0c0))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **Charts:** Set max row limit + removed the option to use an empty row limit value ([#25579](https://github.com/apache/superset/issues/25579)) ([f556ef5](https://github.com/apache/superset/commit/f556ef53f3177746ec2526b4b963da4ef00c2d58))
- **charts:** Time grain is None when dataset uses Jinja ([#25842](https://github.com/apache/superset/issues/25842)) ([7536dd1](https://github.com/apache/superset/commit/7536dd12cdd58a1bca7d72952a2b74641f16c959))
- clean up chart metadata config ([#19143](https://github.com/apache/superset/issues/19143)) ([3d66912](https://github.com/apache/superset/commit/3d66912d89851f03c38803b29128a45d66b34cb6))
- **codecov:** improve core code coverage ([#20274](https://github.com/apache/superset/issues/20274)) ([5425504](https://github.com/apache/superset/commit/54255042310b9810c09fee25d475a4a1bc8f75de))
- color collision in dashboard with tabs ([#24670](https://github.com/apache/superset/issues/24670)) ([0328dd2](https://github.com/apache/superset/commit/0328dd270467e71260bfa85078beb7b38a87877b))
- core coverage and add a coverage step in workflow ([#20784](https://github.com/apache/superset/issues/20784)) ([9c7bcfc](https://github.com/apache/superset/commit/9c7bcfceadb1101899d6c09330aa8e79330d656f))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **dashboard:** Add correct icon, label and badge to horizontal native filters dropdown button ([#22211](https://github.com/apache/superset/issues/22211)) ([435926b](https://github.com/apache/superset/commit/435926b89e08395f3017a32ea00f3de252fd4fb7))
- **dashboard:** Add remark plugin on markdown ([#23502](https://github.com/apache/superset/issues/23502)) ([439d687](https://github.com/apache/superset/commit/439d687e1f88cad8326c41a3f1dd67a1f5a9ee69))
- **dashboard:** Allow selecting text in cells in Table and PivotTable without triggering cross filters ([#23283](https://github.com/apache/superset/issues/23283)) ([d16512b](https://github.com/apache/superset/commit/d16512b7758e36a1263fc63bd7d9d1f93060dc93))
- **Dashboard:** Color inconsistency on refreshes and conflicts ([#27439](https://github.com/apache/superset/issues/27439)) ([313ee59](https://github.com/apache/superset/commit/313ee596f5435894f857d72be7269d5070c8c964))
- **dashboard:** deepmerge htmlSchemaOverrides ([#23329](https://github.com/apache/superset/issues/23329)) ([3919ca6](https://github.com/apache/superset/commit/3919ca60608e1c2d3cfef99d5a8d9d2aef227843))
- **dashboard:** Fix FilterWithDataMask typing and add null check ([#22260](https://github.com/apache/superset/issues/22260)) ([a642d12](https://github.com/apache/superset/commit/a642d126f8019d8f96cc206abfeda7ddc19eda7f))
- **dashboard:** Prevent XSS attack vector ([#21822](https://github.com/apache/superset/issues/21822)) ([ec20c01](https://github.com/apache/superset/commit/ec20c0104e6913cd9b2ab8bacae22eb25ae4cce1))
- **dependencies:** stopping (and preventing) full lodash library import... now using only method level imports. ([#26710](https://github.com/apache/superset/issues/26710)) ([1d4b8b6](https://github.com/apache/superset/commit/1d4b8b69896776cf8831b8202e69424e14067011))
- **Dev-Server:** Edit ChartPropsConfig reexport to be a type object ([#28225](https://github.com/apache/superset/issues/28225)) ([2e5f3ed](https://github.com/apache/superset/commit/2e5f3ed85149951200645e00e79a543de9bec02f))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- drop the first level of MultiIndex ([#19716](https://github.com/apache/superset/issues/19716)) ([9425dd2](https://github.com/apache/superset/commit/9425dd2cac42f1a92f621848c469cadcc483e757))
- **embedded:** CSV download for chart ([#20261](https://github.com/apache/superset/issues/20261)) ([ab9f72f](https://github.com/apache/superset/commit/ab9f72f1a1359a59e64afd9e820d5823fd53b77b))
- **embedded:** Ensure guest token is passed to log endpoint ([#20647](https://github.com/apache/superset/issues/20647)) ([dfab521](https://github.com/apache/superset/commit/dfab521f50593b97fc778475498920552cad15dc))
- **embedded:** third party cookies ([#20019](https://github.com/apache/superset/issues/20019)) ([3e36d4a](https://github.com/apache/superset/commit/3e36d4a0a1d9e1a1d2d009b6b8db1042d3d37d8b))
- **explore:** Adhoc columns don't display correctly ([#20802](https://github.com/apache/superset/issues/20802)) ([af1bddf](https://github.com/apache/superset/commit/af1bddffad930efc0583b638716980db6747bfbc))
- **explore:** Filters with custom SQL disappearing ([#21114](https://github.com/apache/superset/issues/21114)) ([55304b0](https://github.com/apache/superset/commit/55304b02cd599827359cd13e3fe6ccb8581e0fd2))
- **Explore:** Pivot table V2 sort by failure with D&D enabled ([#18835](https://github.com/apache/superset/issues/18835)) ([eafe0cf](https://github.com/apache/superset/commit/eafe0cfc6f040670a9b35ebcd27f5c83eabe068e))
- Fix console errors about feature flags when running tests ([#21275](https://github.com/apache/superset/issues/21275)) ([742dbdd](https://github.com/apache/superset/commit/742dbdd0a5c0f0f75d56101b3551077ec06cd53f))
- **frontend:** allow "constructor" property in response data ([#25407](https://github.com/apache/superset/issues/25407)) ([a1983e4](https://github.com/apache/superset/commit/a1983e468ba1a1b0fdbef9d8d5206e61be0b7141))
- invalid float number format by json-bigint ([#21968](https://github.com/apache/superset/issues/21968)) ([3bb9187](https://github.com/apache/superset/commit/3bb91877974650ab3fa82539a30dc0e2a7045dd7))
- invalid float number format by json-bigint ([#21996](https://github.com/apache/superset/issues/21996)) ([3a02339](https://github.com/apache/superset/commit/3a023392e6bfec9660449b7b739530574d2a8238))
- local warning in the frontend development ([#17727](https://github.com/apache/superset/issues/17727)) ([142b5bc](https://github.com/apache/superset/commit/142b5bc506c81847e503e76e498c06e8321dffb1))
- **native filters:** rendering performance improvement by reduce overrendering ([#25901](https://github.com/apache/superset/issues/25901)) ([e1d73d5](https://github.com/apache/superset/commit/e1d73d5420867b0310d4c2608686d5ccca94920f))
- **nativeFilters:** Speed up native filters by removing unnecessary rerenders ([#25282](https://github.com/apache/superset/issues/25282)) ([a0eeb4d](https://github.com/apache/superset/commit/a0eeb4d767df9f573d80b520cf8afe42013616bb))
- **nav:** infinite redirect and upload dataset nav permissions ([#19708](https://github.com/apache/superset/issues/19708)) ([32a9265](https://github.com/apache/superset/commit/32a9265cc0cb850910e55b6f49a73169fc7ed377))
- Only redirect to relative paths when authentication expires ([#18714](https://github.com/apache/superset/issues/18714)) ([8027f5f](https://github.com/apache/superset/commit/8027f5f0a63425c280121d671ae843e4c420793b))
- **plugin-chart-echarts:** support forced categorical x-axis ([#26404](https://github.com/apache/superset/issues/26404)) ([219c4a1](https://github.com/apache/superset/commit/219c4a14b359b77dbfcda74e66b7d06c3792b861))
- **plugin-chart-echarts:** undefined bounds for bubble chart ([#26243](https://github.com/apache/superset/issues/26243)) ([5df544b](https://github.com/apache/superset/commit/5df544b6fb079e98d4ab6839cfbdf7f08358a950))
- **plugin-chart-table:** Include time control ([#23533](https://github.com/apache/superset/issues/23533)) ([13ffb4b](https://github.com/apache/superset/commit/13ffb4b7c203cfa8ebec602fc7c25103eebc019f))
- **plugin:** Period Over Period KPI Plugin Feature flag value ([#26985](https://github.com/apache/superset/issues/26985)) ([db79c37](https://github.com/apache/superset/commit/db79c37707ea08166fc7b664823ff51f439ce1e6))
- process color scheme configs correctly ([#17786](https://github.com/apache/superset/issues/17786)) ([de3d397](https://github.com/apache/superset/commit/de3d3973a249ab56b294d3f5d770a79fe8970abd))
- **Query:** Parse html string error responses to avoid displaying raw HTML as error message ([#29321](https://github.com/apache/superset/issues/29321)) ([de6a518](https://github.com/apache/superset/commit/de6a518161b283e8df7e2b450e5dada6e37efe7b))
- Redirect on 401 ([#17597](https://github.com/apache/superset/issues/17597)) ([46cdc77](https://github.com/apache/superset/commit/46cdc77ae64d0cc55a54719c748391b92a475a33))
- Redirect to full url on 401 ([#19357](https://github.com/apache/superset/issues/19357)) ([b8e5954](https://github.com/apache/superset/commit/b8e595413fa02b5f00c7b91df6283701a5f1b972))
- repeated color in the same chart ([#23762](https://github.com/apache/superset/issues/23762)) ([66594ad](https://github.com/apache/superset/commit/66594ad64739f096d2dca93591ed2d5a4754d562))
- Revert "fix(Charts): Set max row limit + removed the option to use an empty row limit value" ([#25753](https://github.com/apache/superset/issues/25753)) ([e2fe967](https://github.com/apache/superset/commit/e2fe96778887d203a852cf09def151ff024cfaf7))
- Revert enabling CSP ([#24476](https://github.com/apache/superset/issues/24476)) ([fb08e0e](https://github.com/apache/superset/commit/fb08e0ecfc81cba37e26620a7b6d88fbd5658cb8))
- row limits & row count labels are confusing ([#27700](https://github.com/apache/superset/issues/27700)) ([12fe292](https://github.com/apache/superset/commit/12fe2929a4a4b5627d9cff701a1e73644e78ac47))
- save columns reference from sqllab save datasets flow ([#24248](https://github.com/apache/superset/issues/24248)) ([93e1db4](https://github.com/apache/superset/commit/93e1db4bd9d045b8a9b345733a60139cb213ab86))
- save dataset and repopulate state ([#20965](https://github.com/apache/superset/issues/20965)) ([463406f](https://github.com/apache/superset/commit/463406ff095375613bf0270343a4af53142c84d6))
- smarter date formatter ([#25404](https://github.com/apache/superset/issues/25404)) ([f0080f9](https://github.com/apache/superset/commit/f0080f9c559c407c5d06e03db27f2cc40fb227e2))
- **sqllab:** invalid sanitization on comparison symbol ([#25903](https://github.com/apache/superset/issues/25903)) ([581d3c7](https://github.com/apache/superset/commit/581d3c710867120f85ddfc097713e5f2880722c1))
- **sqllab:** normalize changedOn timestamp ([#24513](https://github.com/apache/superset/issues/24513)) ([036294a](https://github.com/apache/superset/commit/036294a1910ad777307ce7c252625b0fefdfa4d8))
- SSH Tunnel configuration settings ([#27186](https://github.com/apache/superset/issues/27186)) ([89e89de](https://github.com/apache/superset/commit/89e89de341c555a1fdbe9d3f5bccada58eb08059))
- superset-ui/core code coverage ([#20676](https://github.com/apache/superset/issues/20676)) ([8d4994a](https://github.com/apache/superset/commit/8d4994a89900c2cf636444e4febad61ce3b69d68))
- superset-ui/core codes coverage ([#20324](https://github.com/apache/superset/issues/20324)) ([d04357c](https://github.com/apache/superset/commit/d04357c47bec7bac49c602f3d2166375892200ad))
- support custom links in markdown ([#26211](https://github.com/apache/superset/issues/26211)) ([d2adc85](https://github.com/apache/superset/commit/d2adc858cbdf1242d96cf7cc0363e39afba88990))
- suppress translation warning in jest ([#20404](https://github.com/apache/superset/issues/20404)) ([9fad26f](https://github.com/apache/superset/commit/9fad26fa1919fceda4abdfce0b973d536b42b6af))
- Table sorting reset ([#23318](https://github.com/apache/superset/issues/23318)) ([da3791a](https://github.com/apache/superset/commit/da3791ad3daa209631a588394600d1a8b635e814))
- Time Column on Generic X-axis ([#23021](https://github.com/apache/superset/issues/23021)) ([464ddee](https://github.com/apache/superset/commit/464ddee4b4164460193027645d87cb25e7b2320e))
- Timeseries Y-axis format with contribution mode ([#27106](https://github.com/apache/superset/issues/27106)) ([af577d6](https://github.com/apache/superset/commit/af577d64b17a9730e28e9021376318326fe31437))
- Total calculation in stacked Timeseries charts ([#24477](https://github.com/apache/superset/issues/24477)) ([c5b4ecd](https://github.com/apache/superset/commit/c5b4ecdca519ab4309a47bfc8feb4a1665c6ce96))
- **trino:** normalize non-iso timestamps ([#23339](https://github.com/apache/superset/issues/23339)) ([a591130](https://github.com/apache/superset/commit/a591130e0bd3c817af9ad937f63f1af1fce90740))
- type of AnnotationLayer ([#21878](https://github.com/apache/superset/issues/21878)) ([f4a4ab4](https://github.com/apache/superset/commit/f4a4ab41e05be90b31ab2f9d2a0f23110bd5df21))
- typescript errors in 4.0 ([#27402](https://github.com/apache/superset/issues/27402)) ([ce0b70c](https://github.com/apache/superset/commit/ce0b70cc8685aa4d83c0c4ad0fb8f03fb7e28ede))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))
- typo on doc string ([#19346](https://github.com/apache/superset/issues/19346)) ([2af2d00](https://github.com/apache/superset/commit/2af2d00e852032e1d4eaaa50fd7e8d5415a1db16))
- Use default custom time range time without timezone ([#29669](https://github.com/apache/superset/issues/29669)) ([cd713a2](https://github.com/apache/superset/commit/cd713a239e8f8d0e990dda900632972586af8d00))
- useTruncation infinite loop, reenable dashboard cross links on ChartList ([#27701](https://github.com/apache/superset/issues/27701)) ([ae0f2ce](https://github.com/apache/superset/commit/ae0f2ce3c11aaeef9d8f3ee17ab68d4a4219ae81))

### Features

- a simple LRUCache in frontend ([#20842](https://github.com/apache/superset/issues/20842)) ([55a89df](https://github.com/apache/superset/commit/55a89dfac93f9855dbf1beb2ee0c0f21da54095b))
- add 'dashboard.nav.right' extension to registry ([#20835](https://github.com/apache/superset/issues/20835)) ([226712d](https://github.com/apache/superset/commit/226712d831a80cc44213c5ce8ed921518ea0397c))
- Add 3 new extension points for inserting custom icons ([#22027](https://github.com/apache/superset/issues/22027)) ([c870fbe](https://github.com/apache/superset/commit/c870fbe9e290e9305e6019bb4e9932bbd736b6dc))
- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- Add deck.gl Heatmap Visualization ([#23551](https://github.com/apache/superset/issues/23551)) ([fc8c537](https://github.com/apache/superset/commit/fc8c537118ce6c7b3a4624f88a31e2e7fb287327))
- add extension point for workspace home page ([#21033](https://github.com/apache/superset/issues/21033)) ([83dd851](https://github.com/apache/superset/commit/83dd85166f917a5cff8c94d2b4d2c298182494b9))
- add extension point to the right side of the menu bar ([#20514](https://github.com/apache/superset/issues/20514)) ([f2af81b](https://github.com/apache/superset/commit/f2af81b1c74a56e6854039cfe5f32e9b035ce262))
- add extension point to the top of welcome page ([#20575](https://github.com/apache/superset/issues/20575)) ([2389871](https://github.com/apache/superset/commit/2389871556cde32c61bc694f09b4e7dbc5432af5))
- add new SQLLAB_FORCE_RUN_ASYNC feature flag ([#29231](https://github.com/apache/superset/issues/29231)) ([5e060ce](https://github.com/apache/superset/commit/5e060cef7c0ec197a44b92490eb11c5a39282c92))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- add slackv2 notification ([#29264](https://github.com/apache/superset/issues/29264)) ([6dbfe2a](https://github.com/apache/superset/commit/6dbfe2aab9488d5b35a16b45f873c814d97768f5))
- add support for comments in adhoc clauses ([#19248](https://github.com/apache/superset/issues/19248)) ([f341025](https://github.com/apache/superset/commit/f341025d80aacf7345e7c20f8463231b9197ea58))
- add support to NOT LIKE operator ([#29384](https://github.com/apache/superset/issues/29384)) ([9724c99](https://github.com/apache/superset/commit/9724c993419952fbcbeb8cd19e51a723fc663b04))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds support to multiple dependencies to the native filters ([#18793](https://github.com/apache/superset/issues/18793)) ([06e1e42](https://github.com/apache/superset/commit/06e1e4285ea52d27f9b7b7dfea59f9652ee0dcfe))
- Adds the CROSS_REFERENCE feature flag ([#21708](https://github.com/apache/superset/issues/21708)) ([1cbf066](https://github.com/apache/superset/commit/1cbf0664152cef5d47720e1acffb955c328e291e))
- Adds the ECharts Heatmap chart ([#25353](https://github.com/apache/superset/issues/25353)) ([546d48a](https://github.com/apache/superset/commit/546d48adbb84b1354d6a3d4ae88dbeba0ad14d44))
- Adds the ECharts Histogram chart ([#28652](https://github.com/apache/superset/issues/28652)) ([896fe85](https://github.com/apache/superset/commit/896fe854dc3865214325cfceea94824ff41a1b6c))
- Adds the HORIZONTAL_FILTER_BAR feature flag ([#21935](https://github.com/apache/superset/issues/21935)) ([779d9f7](https://github.com/apache/superset/commit/779d9f75336ce38ab346e27dcb6a77e5a68cf823))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- **advanced analytics:** support groupby in resample ([#18045](https://github.com/apache/superset/issues/18045)) ([0c7f728](https://github.com/apache/superset/commit/0c7f7288d8cded5dc73d49d1e0be397e748d4f10))
- **alert report tabs:** adding feature flag ([#27773](https://github.com/apache/superset/issues/27773)) ([aef325a](https://github.com/apache/superset/commit/aef325a41687804b3e9ee6731e99821062604c43))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **build:** uplift `Jest` to v29 ([#29118](https://github.com/apache/superset/issues/29118)) ([dffad48](https://github.com/apache/superset/commit/dffad4850404abed68700cc18d9124abe7594aa4))
- **business-types:** initial implementation of SIP-78 ([#18794](https://github.com/apache/superset/issues/18794)) ([ddc01ea](https://github.com/apache/superset/commit/ddc01ea7813ef7c02cfc2aee7cbf554a45628f25))
- **chart:** add feature flag that displays the data pane closes by default ([#21649](https://github.com/apache/superset/issues/21649)) ([ebd7536](https://github.com/apache/superset/commit/ebd75366c0c7acd6d4619996c4f209b51af518e2))
- **color:** color consistency enhancements ([#21507](https://github.com/apache/superset/issues/21507)) ([7a7181a](https://github.com/apache/superset/commit/7a7181a2449598b09298f3a113849caeb3309186))
- **color:** support analogous colors to prevent color conflict ([#19325](https://github.com/apache/superset/issues/19325)) ([90c9dae](https://github.com/apache/superset/commit/90c9daea08cd59ba7261c13e1ce4e80a72f84b48))
- Convert ENABLE_BROAD_ACTIVITY_ACCESS and MENU_HIDE_USER_INFO into feature flags ([#24345](https://github.com/apache/superset/issues/24345)) ([a7f7f66](https://github.com/apache/superset/commit/a7f7f6645dd374bee4358544c87e5c3120dcdb73))
- custom d3 number locale ([#20075](https://github.com/apache/superset/issues/20075)) ([a170ae4](https://github.com/apache/superset/commit/a170ae4368298207b5a5c9a698889c865fd73421))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** Add Drill to Detail modal w/ chart menu + right-click support ([#20728](https://github.com/apache/superset/issues/20728)) ([52648ec](https://github.com/apache/superset/commit/52648ecd7f6158473ec198e1ade9a5a69008b752))
- **dashboard:** confirm overwrite to prevent unintended changes ([#21819](https://github.com/apache/superset/issues/21819)) ([ef6b9a9](https://github.com/apache/superset/commit/ef6b9a97d594f748ab710e27281d41ee5250d33a))
- **dashboard:** make color indices referable ([#23657](https://github.com/apache/superset/issues/23657)) ([c8fa44e](https://github.com/apache/superset/commit/c8fa44e9e904160de705cd643d1df092815348b1))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- **dashboard:** Transition to Explore with React Router ([#20606](https://github.com/apache/superset/issues/20606)) ([de4f7db](https://github.com/apache/superset/commit/de4f7db57ec33c497be9c880fde534a1f026241f))
- database extension registry ([#23174](https://github.com/apache/superset/issues/23174)) ([6b54591](https://github.com/apache/superset/commit/6b5459121f9542c9f0976aec1ebdfe7b1a078472))
- **deckgl-map:** use an arbitraty Mabpox style URL ([#26027](https://github.com/apache/superset/issues/26027)) ([#26031](https://github.com/apache/superset/issues/26031)) ([af58784](https://github.com/apache/superset/commit/af587840403d83a7da7fb0f57bc10ad2335d4eeb))
- Drill by open in Explore ([#23575](https://github.com/apache/superset/issues/23575)) ([117360c](https://github.com/apache/superset/commit/117360cd57bdbf9fd60fc479c6fe64dc077dbfee))
- Dynamic dashboard component ([#17208](https://github.com/apache/superset/issues/17208)) ([bcad1ac](https://github.com/apache/superset/commit/bcad1acec27823756dc403f6e982f5e59ec6d6cf))
- embedded dashboard core ([#17530](https://github.com/apache/superset/issues/17530)) ([4ad5ad0](https://github.com/apache/superset/commit/4ad5ad045a9adb506d14b2c02fdbefc564d25bdb)), closes [#17175](https://github.com/apache/superset/issues/17175) [#17450](https://github.com/apache/superset/issues/17450) [#17517](https://github.com/apache/superset/issues/17517) [#17529](https://github.com/apache/superset/issues/17529) [#17757](https://github.com/apache/superset/issues/17757) [#17836](https://github.com/apache/superset/issues/17836)
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- **explore:** add config for default time filter ([#21879](https://github.com/apache/superset/issues/21879)) ([9a063ab](https://github.com/apache/superset/commit/9a063abb3b28e32b1107950942571d564bb283f8))
- **explore:** Color scheme groups, new color schemes ([#27995](https://github.com/apache/superset/issues/27995)) ([bbfe5c0](https://github.com/apache/superset/commit/bbfe5c0ae88df8556b3390b06ce9e400cabdc943))
- **explore:** Don't discard controls with custom sql when changing datasource ([#20934](https://github.com/apache/superset/issues/20934)) ([cddc361](https://github.com/apache/superset/commit/cddc361adc483ed605857a2eb39c5efffa089076))
- **explore:** export csv data pivoted for Pivot Table [ID-9] ([#17512](https://github.com/apache/superset/issues/17512)) ([07e8837](https://github.com/apache/superset/commit/07e8837093b79b08e18224dd6765a2fc15a0e770))
- **explore:** Frontend implementation of dataset creation from infobox ([#19855](https://github.com/apache/superset/issues/19855)) ([ba0c37d](https://github.com/apache/superset/commit/ba0c37d3df85b1af39404af1d578daeb0ff2d278))
- **explore:** Implement chart empty states ([#18678](https://github.com/apache/superset/issues/18678)) ([167e18e](https://github.com/apache/superset/commit/167e18e806799dede3aa56da98be11f4751f0272))
- extension hook for DB delete ([#24191](https://github.com/apache/superset/issues/24191)) ([9df8d8d](https://github.com/apache/superset/commit/9df8d8dda538095ba3b30d1f82aa81acf17e1c95))
- **formatters:** Add custom d3-time-format locale ([#24263](https://github.com/apache/superset/issues/24263)) ([024cfd8](https://github.com/apache/superset/commit/024cfd86e408ec5f7ddf49a9e90908e2fb2e6b70))
- Frontend tagging ([#20876](https://github.com/apache/superset/issues/20876)) ([a40c12d](https://github.com/apache/superset/commit/a40c12d63e04811f3a710a862298bfa68dfde3d8))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement currencies formatter for saved metrics ([#24517](https://github.com/apache/superset/issues/24517)) ([83ff4cd](https://github.com/apache/superset/commit/83ff4cd86a4931fc8eda83aeb3d8d3c92d773202))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- Improves SafeMarkdown HTML sanitization ([#21895](https://github.com/apache/superset/issues/21895)) ([7d1df3b](https://github.com/apache/superset/commit/7d1df3b78d5d7147dd9d627317e3f9f10d279ae0))
- Improves the Drill By feature ([#29242](https://github.com/apache/superset/issues/29242)) ([08e44c0](https://github.com/apache/superset/commit/08e44c085014ca258fe0c22886067dc716a910c6))
- Improves the Waterfall chart ([#25557](https://github.com/apache/superset/issues/25557)) ([d619078](https://github.com/apache/superset/commit/d619078d25dde63c55e9afd87e98f05d4fb82b86))
- make data tables support html ([#24368](https://github.com/apache/superset/issues/24368)) ([d2b0b8e](https://github.com/apache/superset/commit/d2b0b8eac52ad8b68639c6581a1ed174a593f564))
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- **native-filters:** Adjust filter components for horizontal mode ([#22273](https://github.com/apache/superset/issues/22273)) ([eb6045a](https://github.com/apache/superset/commit/eb6045adfa77e06c8aaf3de217719ca59d4328e1))
- Pass dashboard context to explore through local storage ([#20743](https://github.com/apache/superset/issues/20743)) ([0945d4a](https://github.com/apache/superset/commit/0945d4a2f46667aebb9b93d0d7685215627ad237))
- Period over Period Big Number comparison chart ([#26908](https://github.com/apache/superset/issues/26908)) ([a09e555](https://github.com/apache/superset/commit/a09e5557bc8b40e46495b9473959327118dfaacf))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- Programmatically open "more filters" dropdown in Horizontal Filter Bar ([#22276](https://github.com/apache/superset/issues/22276)) ([df91664](https://github.com/apache/superset/commit/df91664217b5369d1f742ce03596a366e18cd4b9))
- Reuse Dashboard redux data in Explore ([#20668](https://github.com/apache/superset/issues/20668)) ([ff5b4bc](https://github.com/apache/superset/commit/ff5b4bc0e47f057e0660d453a9e53f939613356b))
- root context provider extension point ([#22188](https://github.com/apache/superset/issues/22188)) ([aa97ba4](https://github.com/apache/superset/commit/aa97ba4509431a82922f2fa6930928093c876d6f))
- **select:** keep options order when in single mode ([#19085](https://github.com/apache/superset/issues/19085)) ([ae13d83](https://github.com/apache/superset/commit/ae13d8313b5687374f5b24e02bccdcc717ba19eb))
- **SIP-95:** catalogs in SQL Lab and datasets ([#28376](https://github.com/apache/superset/issues/28376)) ([ce668d4](https://github.com/apache/superset/commit/ce668d46cc5d429a249fdd9e091650457da20361))
- **sqllab:** ResultTable extension ([#25423](https://github.com/apache/superset/issues/25423)) ([deef3b0](https://github.com/apache/superset/commit/deef3b04ebed1178259af5909779392cfa0cd630))
- **sqllab:** SQLEditor Extension ([#24205](https://github.com/apache/superset/issues/24205)) ([1d9a761](https://github.com/apache/superset/commit/1d9a761de5410fa1bd208bca4c78614779cf3064))
- **ssh_tunnel:** SQLAlchemy Form UI ([#22513](https://github.com/apache/superset/issues/22513)) ([5399365](https://github.com/apache/superset/commit/539936522fbbda46ebb39b65ed298f6e251a548f))
- **ssh_tunnel:** SSH Tunnel Switch extension ([#22967](https://github.com/apache/superset/issues/22967)) ([cf395ac](https://github.com/apache/superset/commit/cf395ac2d8e04782cffc93e8a0a0b28678c407fe))
- **storybook:** Co-habitating/Upgrading Storybooks to v7 (dependency madness ensues) ([#26907](https://github.com/apache/superset/issues/26907)) ([753ef69](https://github.com/apache/superset/commit/753ef695294ce26238b68ff41ba0a9af6aea74de))
- **superset-ui-core:** add feature flag for the analogous colors ([#19987](https://github.com/apache/superset/issues/19987)) ([80b5578](https://github.com/apache/superset/commit/80b55786809310e28566d745308b167f0e74b144))
- SupersetClient config to override 401 behavior ([#19144](https://github.com/apache/superset/issues/19144)) ([96a123f](https://github.com/apache/superset/commit/96a123f553f80ae7454daaf139b33e1397d9e3f7))
- Support further drill by in the modal ([#23615](https://github.com/apache/superset/issues/23615)) ([587e775](https://github.com/apache/superset/commit/587e7759b1b674440ac0aa705ebae6599564875f))
- support mulitple temporal filters in AdhocFilter and move the Time Section away ([#21767](https://github.com/apache/superset/issues/21767)) ([a9b229d](https://github.com/apache/superset/commit/a9b229dd1dd9cb9dc8166b1392179fcccb4da138))
- **table:** Table with Time Comparison ([#28057](https://github.com/apache/superset/issues/28057)) ([7ddea62](https://github.com/apache/superset/commit/7ddea62331617dad1b8ade1abe7dd8c11a1ba20d))
- **time_comparison:** Support all date formats when computing custom and inherit offsets ([#30002](https://github.com/apache/superset/issues/30002)) ([bc6d2db](https://github.com/apache/superset/commit/bc6d2dba373e59a498d942909ab6631e5c8521e9))
- UI override registry ([#19671](https://github.com/apache/superset/issues/19671)) ([4927685](https://github.com/apache/superset/commit/4927685c3059c0207713bceeea7c60f1f3b75ec3))
- Utility function to render chart tooltips ([#27950](https://github.com/apache/superset/issues/27950)) ([b549977](https://github.com/apache/superset/commit/b549977f0538d6939dce756c7615052e5f2e6c93))
- Visualize SqlLab.Query model data in Explore 📈 ([#20281](https://github.com/apache/superset/issues/20281)) ([e5e8867](https://github.com/apache/superset/commit/e5e886739460c011a885a13b873665410045a19c))
- **viz-gallery:** add 'feature' tag and fuzzy search weighting ([#18662](https://github.com/apache/superset/issues/18662)) ([7524e1e](https://github.com/apache/superset/commit/7524e1e3c86f3de2b3b0343c3ec5efc0b345937a))

### Performance Improvements

- **dashboard:** Virtualization POC ([#21438](https://github.com/apache/superset/issues/21438)) ([406e44b](https://github.com/apache/superset/commit/406e44bba11f6b233c3b07d29efd158b8cfc9615))
- Lazy load rehype-raw and react-markdown ([#29855](https://github.com/apache/superset/issues/29855)) ([5b5f448](https://github.com/apache/superset/commit/5b5f448af04afedec1387c2f04c658dfced6d95a))
- **plugin-chart-table:** Add memoization to avoid rerenders ([#19976](https://github.com/apache/superset/issues/19976)) ([0f68dee](https://github.com/apache/superset/commit/0f68deedf105300c8bd2536bd205d128799c0381))
- Remove antd-with-locales import ([#29788](https://github.com/apache/superset/issues/29788)) ([f1136b5](https://github.com/apache/superset/commit/f1136b57dd6b4cbcb7628dcbf6b1ac46e2a8301b))

### Reverts

- Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (#20689) ([5317462](https://github.com/apache/superset/commit/5317462b49d050d93d91eee5e97ec56e15f9f298)), closes [#20668](https://github.com/apache/superset/issues/20668) [#20689](https://github.com/apache/superset/issues/20689)

# [0.19.0](https://github.com/apache/superset/compare/v2021.41.0...v0.19.0) (2024-09-07)

### Bug Fixes

- [sc-54864] Adds safety check to provide near term fix to save query ([#21034](https://github.com/apache/superset/issues/21034)) ([ab6ec89](https://github.com/apache/superset/commit/ab6ec89f680dbf022a39ed568c6fcdce0439b2dd))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **annotation:** Address regression from [#24694](https://github.com/apache/superset/issues/24694) ([#24874](https://github.com/apache/superset/issues/24874)) ([f05638b](https://github.com/apache/superset/commit/f05638ba845596faef088efa3ee98686d26dad26))
- avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied ([#20173](https://github.com/apache/superset/issues/20173)) ([365acee](https://github.com/apache/superset/commit/365acee663f7942ba7d8dfd0e4cf72c4cecb7a2d))
- BIGINT rendering regression in chartAction ([#21937](https://github.com/apache/superset/issues/21937)) ([4002406](https://github.com/apache/superset/commit/40024064ae35e596215a79d98ed8d0b4a90847f2))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- **charts:** big-number display broken in echarts ([#24492](https://github.com/apache/superset/issues/24492)) ([3f17945](https://github.com/apache/superset/commit/3f179457457bc2a21a824895aa1cd99b586d9ea0))
- **chart:** Set max row limit + removed the option to use an empty row limit value ([#26151](https://github.com/apache/superset/issues/26151)) ([863f8bb](https://github.com/apache/superset/commit/863f8bbbcdd078814973d444368c12e06ad0c0c0))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **Charts:** Set max row limit + removed the option to use an empty row limit value ([#25579](https://github.com/apache/superset/issues/25579)) ([f556ef5](https://github.com/apache/superset/commit/f556ef53f3177746ec2526b4b963da4ef00c2d58))
- **charts:** Time grain is None when dataset uses Jinja ([#25842](https://github.com/apache/superset/issues/25842)) ([7536dd1](https://github.com/apache/superset/commit/7536dd12cdd58a1bca7d72952a2b74641f16c959))
- clean up chart metadata config ([#19143](https://github.com/apache/superset/issues/19143)) ([3d66912](https://github.com/apache/superset/commit/3d66912d89851f03c38803b29128a45d66b34cb6))
- **codecov:** improve core code coverage ([#20274](https://github.com/apache/superset/issues/20274)) ([5425504](https://github.com/apache/superset/commit/54255042310b9810c09fee25d475a4a1bc8f75de))
- color collision in dashboard with tabs ([#24670](https://github.com/apache/superset/issues/24670)) ([0328dd2](https://github.com/apache/superset/commit/0328dd270467e71260bfa85078beb7b38a87877b))
- core coverage and add a coverage step in workflow ([#20784](https://github.com/apache/superset/issues/20784)) ([9c7bcfc](https://github.com/apache/superset/commit/9c7bcfceadb1101899d6c09330aa8e79330d656f))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **dashboard:** Add correct icon, label and badge to horizontal native filters dropdown button ([#22211](https://github.com/apache/superset/issues/22211)) ([435926b](https://github.com/apache/superset/commit/435926b89e08395f3017a32ea00f3de252fd4fb7))
- **dashboard:** Add remark plugin on markdown ([#23502](https://github.com/apache/superset/issues/23502)) ([439d687](https://github.com/apache/superset/commit/439d687e1f88cad8326c41a3f1dd67a1f5a9ee69))
- **dashboard:** Allow selecting text in cells in Table and PivotTable without triggering cross filters ([#23283](https://github.com/apache/superset/issues/23283)) ([d16512b](https://github.com/apache/superset/commit/d16512b7758e36a1263fc63bd7d9d1f93060dc93))
- **Dashboard:** Color inconsistency on refreshes and conflicts ([#27439](https://github.com/apache/superset/issues/27439)) ([313ee59](https://github.com/apache/superset/commit/313ee596f5435894f857d72be7269d5070c8c964))
- **dashboard:** deepmerge htmlSchemaOverrides ([#23329](https://github.com/apache/superset/issues/23329)) ([3919ca6](https://github.com/apache/superset/commit/3919ca60608e1c2d3cfef99d5a8d9d2aef227843))
- **dashboard:** Fix FilterWithDataMask typing and add null check ([#22260](https://github.com/apache/superset/issues/22260)) ([a642d12](https://github.com/apache/superset/commit/a642d126f8019d8f96cc206abfeda7ddc19eda7f))
- **dashboard:** Prevent XSS attack vector ([#21822](https://github.com/apache/superset/issues/21822)) ([ec20c01](https://github.com/apache/superset/commit/ec20c0104e6913cd9b2ab8bacae22eb25ae4cce1))
- **dependencies:** stopping (and preventing) full lodash library import... now using only method level imports. ([#26710](https://github.com/apache/superset/issues/26710)) ([1d4b8b6](https://github.com/apache/superset/commit/1d4b8b69896776cf8831b8202e69424e14067011))
- **Dev-Server:** Edit ChartPropsConfig reexport to be a type object ([#28225](https://github.com/apache/superset/issues/28225)) ([2e5f3ed](https://github.com/apache/superset/commit/2e5f3ed85149951200645e00e79a543de9bec02f))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- drop the first level of MultiIndex ([#19716](https://github.com/apache/superset/issues/19716)) ([9425dd2](https://github.com/apache/superset/commit/9425dd2cac42f1a92f621848c469cadcc483e757))
- **embedded:** CSV download for chart ([#20261](https://github.com/apache/superset/issues/20261)) ([ab9f72f](https://github.com/apache/superset/commit/ab9f72f1a1359a59e64afd9e820d5823fd53b77b))
- **embedded:** Ensure guest token is passed to log endpoint ([#20647](https://github.com/apache/superset/issues/20647)) ([dfab521](https://github.com/apache/superset/commit/dfab521f50593b97fc778475498920552cad15dc))
- **embedded:** third party cookies ([#20019](https://github.com/apache/superset/issues/20019)) ([3e36d4a](https://github.com/apache/superset/commit/3e36d4a0a1d9e1a1d2d009b6b8db1042d3d37d8b))
- **explore:** Adhoc columns don't display correctly ([#20802](https://github.com/apache/superset/issues/20802)) ([af1bddf](https://github.com/apache/superset/commit/af1bddffad930efc0583b638716980db6747bfbc))
- **explore:** Filters with custom SQL disappearing ([#21114](https://github.com/apache/superset/issues/21114)) ([55304b0](https://github.com/apache/superset/commit/55304b02cd599827359cd13e3fe6ccb8581e0fd2))
- **Explore:** Pivot table V2 sort by failure with D&D enabled ([#18835](https://github.com/apache/superset/issues/18835)) ([eafe0cf](https://github.com/apache/superset/commit/eafe0cfc6f040670a9b35ebcd27f5c83eabe068e))
- Fix console errors about feature flags when running tests ([#21275](https://github.com/apache/superset/issues/21275)) ([742dbdd](https://github.com/apache/superset/commit/742dbdd0a5c0f0f75d56101b3551077ec06cd53f))
- **frontend:** allow "constructor" property in response data ([#25407](https://github.com/apache/superset/issues/25407)) ([a1983e4](https://github.com/apache/superset/commit/a1983e468ba1a1b0fdbef9d8d5206e61be0b7141))
- invalid float number format by json-bigint ([#21968](https://github.com/apache/superset/issues/21968)) ([3bb9187](https://github.com/apache/superset/commit/3bb91877974650ab3fa82539a30dc0e2a7045dd7))
- invalid float number format by json-bigint ([#21996](https://github.com/apache/superset/issues/21996)) ([3a02339](https://github.com/apache/superset/commit/3a023392e6bfec9660449b7b739530574d2a8238))
- local warning in the frontend development ([#17727](https://github.com/apache/superset/issues/17727)) ([142b5bc](https://github.com/apache/superset/commit/142b5bc506c81847e503e76e498c06e8321dffb1))
- **native filters:** rendering performance improvement by reduce overrendering ([#25901](https://github.com/apache/superset/issues/25901)) ([e1d73d5](https://github.com/apache/superset/commit/e1d73d5420867b0310d4c2608686d5ccca94920f))
- **nativeFilters:** Speed up native filters by removing unnecessary rerenders ([#25282](https://github.com/apache/superset/issues/25282)) ([a0eeb4d](https://github.com/apache/superset/commit/a0eeb4d767df9f573d80b520cf8afe42013616bb))
- **nav:** infinite redirect and upload dataset nav permissions ([#19708](https://github.com/apache/superset/issues/19708)) ([32a9265](https://github.com/apache/superset/commit/32a9265cc0cb850910e55b6f49a73169fc7ed377))
- Only redirect to relative paths when authentication expires ([#18714](https://github.com/apache/superset/issues/18714)) ([8027f5f](https://github.com/apache/superset/commit/8027f5f0a63425c280121d671ae843e4c420793b))
- **plugin-chart-echarts:** support forced categorical x-axis ([#26404](https://github.com/apache/superset/issues/26404)) ([219c4a1](https://github.com/apache/superset/commit/219c4a14b359b77dbfcda74e66b7d06c3792b861))
- **plugin-chart-echarts:** undefined bounds for bubble chart ([#26243](https://github.com/apache/superset/issues/26243)) ([5df544b](https://github.com/apache/superset/commit/5df544b6fb079e98d4ab6839cfbdf7f08358a950))
- **plugin-chart-table:** Include time control ([#23533](https://github.com/apache/superset/issues/23533)) ([13ffb4b](https://github.com/apache/superset/commit/13ffb4b7c203cfa8ebec602fc7c25103eebc019f))
- **plugin:** Period Over Period KPI Plugin Feature flag value ([#26985](https://github.com/apache/superset/issues/26985)) ([db79c37](https://github.com/apache/superset/commit/db79c37707ea08166fc7b664823ff51f439ce1e6))
- process color scheme configs correctly ([#17786](https://github.com/apache/superset/issues/17786)) ([de3d397](https://github.com/apache/superset/commit/de3d3973a249ab56b294d3f5d770a79fe8970abd))
- **Query:** Parse html string error responses to avoid displaying raw HTML as error message ([#29321](https://github.com/apache/superset/issues/29321)) ([de6a518](https://github.com/apache/superset/commit/de6a518161b283e8df7e2b450e5dada6e37efe7b))
- Redirect on 401 ([#17597](https://github.com/apache/superset/issues/17597)) ([46cdc77](https://github.com/apache/superset/commit/46cdc77ae64d0cc55a54719c748391b92a475a33))
- Redirect to full url on 401 ([#19357](https://github.com/apache/superset/issues/19357)) ([b8e5954](https://github.com/apache/superset/commit/b8e595413fa02b5f00c7b91df6283701a5f1b972))
- repeated color in the same chart ([#23762](https://github.com/apache/superset/issues/23762)) ([66594ad](https://github.com/apache/superset/commit/66594ad64739f096d2dca93591ed2d5a4754d562))
- Revert "fix(Charts): Set max row limit + removed the option to use an empty row limit value" ([#25753](https://github.com/apache/superset/issues/25753)) ([e2fe967](https://github.com/apache/superset/commit/e2fe96778887d203a852cf09def151ff024cfaf7))
- Revert enabling CSP ([#24476](https://github.com/apache/superset/issues/24476)) ([fb08e0e](https://github.com/apache/superset/commit/fb08e0ecfc81cba37e26620a7b6d88fbd5658cb8))
- row limits & row count labels are confusing ([#27700](https://github.com/apache/superset/issues/27700)) ([12fe292](https://github.com/apache/superset/commit/12fe2929a4a4b5627d9cff701a1e73644e78ac47))
- save columns reference from sqllab save datasets flow ([#24248](https://github.com/apache/superset/issues/24248)) ([93e1db4](https://github.com/apache/superset/commit/93e1db4bd9d045b8a9b345733a60139cb213ab86))
- save dataset and repopulate state ([#20965](https://github.com/apache/superset/issues/20965)) ([463406f](https://github.com/apache/superset/commit/463406ff095375613bf0270343a4af53142c84d6))
- smarter date formatter ([#25404](https://github.com/apache/superset/issues/25404)) ([f0080f9](https://github.com/apache/superset/commit/f0080f9c559c407c5d06e03db27f2cc40fb227e2))
- **sqllab:** invalid sanitization on comparison symbol ([#25903](https://github.com/apache/superset/issues/25903)) ([581d3c7](https://github.com/apache/superset/commit/581d3c710867120f85ddfc097713e5f2880722c1))
- **sqllab:** normalize changedOn timestamp ([#24513](https://github.com/apache/superset/issues/24513)) ([036294a](https://github.com/apache/superset/commit/036294a1910ad777307ce7c252625b0fefdfa4d8))
- SSH Tunnel configuration settings ([#27186](https://github.com/apache/superset/issues/27186)) ([89e89de](https://github.com/apache/superset/commit/89e89de341c555a1fdbe9d3f5bccada58eb08059))
- superset-ui/core code coverage ([#20676](https://github.com/apache/superset/issues/20676)) ([8d4994a](https://github.com/apache/superset/commit/8d4994a89900c2cf636444e4febad61ce3b69d68))
- superset-ui/core codes coverage ([#20324](https://github.com/apache/superset/issues/20324)) ([d04357c](https://github.com/apache/superset/commit/d04357c47bec7bac49c602f3d2166375892200ad))
- support custom links in markdown ([#26211](https://github.com/apache/superset/issues/26211)) ([d2adc85](https://github.com/apache/superset/commit/d2adc858cbdf1242d96cf7cc0363e39afba88990))
- suppress translation warning in jest ([#20404](https://github.com/apache/superset/issues/20404)) ([9fad26f](https://github.com/apache/superset/commit/9fad26fa1919fceda4abdfce0b973d536b42b6af))
- Table sorting reset ([#23318](https://github.com/apache/superset/issues/23318)) ([da3791a](https://github.com/apache/superset/commit/da3791ad3daa209631a588394600d1a8b635e814))
- Time Column on Generic X-axis ([#23021](https://github.com/apache/superset/issues/23021)) ([464ddee](https://github.com/apache/superset/commit/464ddee4b4164460193027645d87cb25e7b2320e))
- Timeseries Y-axis format with contribution mode ([#27106](https://github.com/apache/superset/issues/27106)) ([af577d6](https://github.com/apache/superset/commit/af577d64b17a9730e28e9021376318326fe31437))
- Total calculation in stacked Timeseries charts ([#24477](https://github.com/apache/superset/issues/24477)) ([c5b4ecd](https://github.com/apache/superset/commit/c5b4ecdca519ab4309a47bfc8feb4a1665c6ce96))
- **trino:** normalize non-iso timestamps ([#23339](https://github.com/apache/superset/issues/23339)) ([a591130](https://github.com/apache/superset/commit/a591130e0bd3c817af9ad937f63f1af1fce90740))
- type of AnnotationLayer ([#21878](https://github.com/apache/superset/issues/21878)) ([f4a4ab4](https://github.com/apache/superset/commit/f4a4ab41e05be90b31ab2f9d2a0f23110bd5df21))
- typescript errors in 4.0 ([#27402](https://github.com/apache/superset/issues/27402)) ([ce0b70c](https://github.com/apache/superset/commit/ce0b70cc8685aa4d83c0c4ad0fb8f03fb7e28ede))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))
- typo on doc string ([#19346](https://github.com/apache/superset/issues/19346)) ([2af2d00](https://github.com/apache/superset/commit/2af2d00e852032e1d4eaaa50fd7e8d5415a1db16))
- Use default custom time range time without timezone ([#29669](https://github.com/apache/superset/issues/29669)) ([cd713a2](https://github.com/apache/superset/commit/cd713a239e8f8d0e990dda900632972586af8d00))
- useTruncation infinite loop, reenable dashboard cross links on ChartList ([#27701](https://github.com/apache/superset/issues/27701)) ([ae0f2ce](https://github.com/apache/superset/commit/ae0f2ce3c11aaeef9d8f3ee17ab68d4a4219ae81))

### Features

- a simple LRUCache in frontend ([#20842](https://github.com/apache/superset/issues/20842)) ([55a89df](https://github.com/apache/superset/commit/55a89dfac93f9855dbf1beb2ee0c0f21da54095b))
- add 'dashboard.nav.right' extension to registry ([#20835](https://github.com/apache/superset/issues/20835)) ([226712d](https://github.com/apache/superset/commit/226712d831a80cc44213c5ce8ed921518ea0397c))
- Add 3 new extension points for inserting custom icons ([#22027](https://github.com/apache/superset/issues/22027)) ([c870fbe](https://github.com/apache/superset/commit/c870fbe9e290e9305e6019bb4e9932bbd736b6dc))
- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- Add deck.gl Heatmap Visualization ([#23551](https://github.com/apache/superset/issues/23551)) ([fc8c537](https://github.com/apache/superset/commit/fc8c537118ce6c7b3a4624f88a31e2e7fb287327))
- add extension point for workspace home page ([#21033](https://github.com/apache/superset/issues/21033)) ([83dd851](https://github.com/apache/superset/commit/83dd85166f917a5cff8c94d2b4d2c298182494b9))
- add extension point to the right side of the menu bar ([#20514](https://github.com/apache/superset/issues/20514)) ([f2af81b](https://github.com/apache/superset/commit/f2af81b1c74a56e6854039cfe5f32e9b035ce262))
- add extension point to the top of welcome page ([#20575](https://github.com/apache/superset/issues/20575)) ([2389871](https://github.com/apache/superset/commit/2389871556cde32c61bc694f09b4e7dbc5432af5))
- add new SQLLAB_FORCE_RUN_ASYNC feature flag ([#29231](https://github.com/apache/superset/issues/29231)) ([5e060ce](https://github.com/apache/superset/commit/5e060cef7c0ec197a44b92490eb11c5a39282c92))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- add slackv2 notification ([#29264](https://github.com/apache/superset/issues/29264)) ([6dbfe2a](https://github.com/apache/superset/commit/6dbfe2aab9488d5b35a16b45f873c814d97768f5))
- add support for comments in adhoc clauses ([#19248](https://github.com/apache/superset/issues/19248)) ([f341025](https://github.com/apache/superset/commit/f341025d80aacf7345e7c20f8463231b9197ea58))
- add support to NOT LIKE operator ([#29384](https://github.com/apache/superset/issues/29384)) ([9724c99](https://github.com/apache/superset/commit/9724c993419952fbcbeb8cd19e51a723fc663b04))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds support to multiple dependencies to the native filters ([#18793](https://github.com/apache/superset/issues/18793)) ([06e1e42](https://github.com/apache/superset/commit/06e1e4285ea52d27f9b7b7dfea59f9652ee0dcfe))
- Adds the CROSS_REFERENCE feature flag ([#21708](https://github.com/apache/superset/issues/21708)) ([1cbf066](https://github.com/apache/superset/commit/1cbf0664152cef5d47720e1acffb955c328e291e))
- Adds the ECharts Heatmap chart ([#25353](https://github.com/apache/superset/issues/25353)) ([546d48a](https://github.com/apache/superset/commit/546d48adbb84b1354d6a3d4ae88dbeba0ad14d44))
- Adds the ECharts Histogram chart ([#28652](https://github.com/apache/superset/issues/28652)) ([896fe85](https://github.com/apache/superset/commit/896fe854dc3865214325cfceea94824ff41a1b6c))
- Adds the HORIZONTAL_FILTER_BAR feature flag ([#21935](https://github.com/apache/superset/issues/21935)) ([779d9f7](https://github.com/apache/superset/commit/779d9f75336ce38ab346e27dcb6a77e5a68cf823))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- **advanced analytics:** support groupby in resample ([#18045](https://github.com/apache/superset/issues/18045)) ([0c7f728](https://github.com/apache/superset/commit/0c7f7288d8cded5dc73d49d1e0be397e748d4f10))
- **alert report tabs:** adding feature flag ([#27773](https://github.com/apache/superset/issues/27773)) ([aef325a](https://github.com/apache/superset/commit/aef325a41687804b3e9ee6731e99821062604c43))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **build:** uplift `Jest` to v29 ([#29118](https://github.com/apache/superset/issues/29118)) ([dffad48](https://github.com/apache/superset/commit/dffad4850404abed68700cc18d9124abe7594aa4))
- **business-types:** initial implementation of SIP-78 ([#18794](https://github.com/apache/superset/issues/18794)) ([ddc01ea](https://github.com/apache/superset/commit/ddc01ea7813ef7c02cfc2aee7cbf554a45628f25))
- **chart:** add feature flag that displays the data pane closes by default ([#21649](https://github.com/apache/superset/issues/21649)) ([ebd7536](https://github.com/apache/superset/commit/ebd75366c0c7acd6d4619996c4f209b51af518e2))
- **color:** color consistency enhancements ([#21507](https://github.com/apache/superset/issues/21507)) ([7a7181a](https://github.com/apache/superset/commit/7a7181a2449598b09298f3a113849caeb3309186))
- **color:** support analogous colors to prevent color conflict ([#19325](https://github.com/apache/superset/issues/19325)) ([90c9dae](https://github.com/apache/superset/commit/90c9daea08cd59ba7261c13e1ce4e80a72f84b48))
- Convert ENABLE_BROAD_ACTIVITY_ACCESS and MENU_HIDE_USER_INFO into feature flags ([#24345](https://github.com/apache/superset/issues/24345)) ([a7f7f66](https://github.com/apache/superset/commit/a7f7f6645dd374bee4358544c87e5c3120dcdb73))
- custom d3 number locale ([#20075](https://github.com/apache/superset/issues/20075)) ([a170ae4](https://github.com/apache/superset/commit/a170ae4368298207b5a5c9a698889c865fd73421))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** Add Drill to Detail modal w/ chart menu + right-click support ([#20728](https://github.com/apache/superset/issues/20728)) ([52648ec](https://github.com/apache/superset/commit/52648ecd7f6158473ec198e1ade9a5a69008b752))
- **dashboard:** confirm overwrite to prevent unintended changes ([#21819](https://github.com/apache/superset/issues/21819)) ([ef6b9a9](https://github.com/apache/superset/commit/ef6b9a97d594f748ab710e27281d41ee5250d33a))
- **dashboard:** make color indices referable ([#23657](https://github.com/apache/superset/issues/23657)) ([c8fa44e](https://github.com/apache/superset/commit/c8fa44e9e904160de705cd643d1df092815348b1))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- **dashboard:** Transition to Explore with React Router ([#20606](https://github.com/apache/superset/issues/20606)) ([de4f7db](https://github.com/apache/superset/commit/de4f7db57ec33c497be9c880fde534a1f026241f))
- database extension registry ([#23174](https://github.com/apache/superset/issues/23174)) ([6b54591](https://github.com/apache/superset/commit/6b5459121f9542c9f0976aec1ebdfe7b1a078472))
- **deckgl-map:** use an arbitraty Mabpox style URL ([#26027](https://github.com/apache/superset/issues/26027)) ([#26031](https://github.com/apache/superset/issues/26031)) ([af58784](https://github.com/apache/superset/commit/af587840403d83a7da7fb0f57bc10ad2335d4eeb))
- Drill by open in Explore ([#23575](https://github.com/apache/superset/issues/23575)) ([117360c](https://github.com/apache/superset/commit/117360cd57bdbf9fd60fc479c6fe64dc077dbfee))
- Dynamic dashboard component ([#17208](https://github.com/apache/superset/issues/17208)) ([bcad1ac](https://github.com/apache/superset/commit/bcad1acec27823756dc403f6e982f5e59ec6d6cf))
- embedded dashboard core ([#17530](https://github.com/apache/superset/issues/17530)) ([4ad5ad0](https://github.com/apache/superset/commit/4ad5ad045a9adb506d14b2c02fdbefc564d25bdb)), closes [#17175](https://github.com/apache/superset/issues/17175) [#17450](https://github.com/apache/superset/issues/17450) [#17517](https://github.com/apache/superset/issues/17517) [#17529](https://github.com/apache/superset/issues/17529) [#17757](https://github.com/apache/superset/issues/17757) [#17836](https://github.com/apache/superset/issues/17836)
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- **explore:** add config for default time filter ([#21879](https://github.com/apache/superset/issues/21879)) ([9a063ab](https://github.com/apache/superset/commit/9a063abb3b28e32b1107950942571d564bb283f8))
- **explore:** Color scheme groups, new color schemes ([#27995](https://github.com/apache/superset/issues/27995)) ([bbfe5c0](https://github.com/apache/superset/commit/bbfe5c0ae88df8556b3390b06ce9e400cabdc943))
- **explore:** Don't discard controls with custom sql when changing datasource ([#20934](https://github.com/apache/superset/issues/20934)) ([cddc361](https://github.com/apache/superset/commit/cddc361adc483ed605857a2eb39c5efffa089076))
- **explore:** export csv data pivoted for Pivot Table [ID-9] ([#17512](https://github.com/apache/superset/issues/17512)) ([07e8837](https://github.com/apache/superset/commit/07e8837093b79b08e18224dd6765a2fc15a0e770))
- **explore:** Frontend implementation of dataset creation from infobox ([#19855](https://github.com/apache/superset/issues/19855)) ([ba0c37d](https://github.com/apache/superset/commit/ba0c37d3df85b1af39404af1d578daeb0ff2d278))
- **explore:** Implement chart empty states ([#18678](https://github.com/apache/superset/issues/18678)) ([167e18e](https://github.com/apache/superset/commit/167e18e806799dede3aa56da98be11f4751f0272))
- extension hook for DB delete ([#24191](https://github.com/apache/superset/issues/24191)) ([9df8d8d](https://github.com/apache/superset/commit/9df8d8dda538095ba3b30d1f82aa81acf17e1c95))
- **formatters:** Add custom d3-time-format locale ([#24263](https://github.com/apache/superset/issues/24263)) ([024cfd8](https://github.com/apache/superset/commit/024cfd86e408ec5f7ddf49a9e90908e2fb2e6b70))
- Frontend tagging ([#20876](https://github.com/apache/superset/issues/20876)) ([a40c12d](https://github.com/apache/superset/commit/a40c12d63e04811f3a710a862298bfa68dfde3d8))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement currencies formatter for saved metrics ([#24517](https://github.com/apache/superset/issues/24517)) ([83ff4cd](https://github.com/apache/superset/commit/83ff4cd86a4931fc8eda83aeb3d8d3c92d773202))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- Improves SafeMarkdown HTML sanitization ([#21895](https://github.com/apache/superset/issues/21895)) ([7d1df3b](https://github.com/apache/superset/commit/7d1df3b78d5d7147dd9d627317e3f9f10d279ae0))
- Improves the Drill By feature ([#29242](https://github.com/apache/superset/issues/29242)) ([08e44c0](https://github.com/apache/superset/commit/08e44c085014ca258fe0c22886067dc716a910c6))
- Improves the Waterfall chart ([#25557](https://github.com/apache/superset/issues/25557)) ([d619078](https://github.com/apache/superset/commit/d619078d25dde63c55e9afd87e98f05d4fb82b86))
- make data tables support html ([#24368](https://github.com/apache/superset/issues/24368)) ([d2b0b8e](https://github.com/apache/superset/commit/d2b0b8eac52ad8b68639c6581a1ed174a593f564))
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- **native-filters:** Adjust filter components for horizontal mode ([#22273](https://github.com/apache/superset/issues/22273)) ([eb6045a](https://github.com/apache/superset/commit/eb6045adfa77e06c8aaf3de217719ca59d4328e1))
- Pass dashboard context to explore through local storage ([#20743](https://github.com/apache/superset/issues/20743)) ([0945d4a](https://github.com/apache/superset/commit/0945d4a2f46667aebb9b93d0d7685215627ad237))
- Period over Period Big Number comparison chart ([#26908](https://github.com/apache/superset/issues/26908)) ([a09e555](https://github.com/apache/superset/commit/a09e5557bc8b40e46495b9473959327118dfaacf))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- Programmatically open "more filters" dropdown in Horizontal Filter Bar ([#22276](https://github.com/apache/superset/issues/22276)) ([df91664](https://github.com/apache/superset/commit/df91664217b5369d1f742ce03596a366e18cd4b9))
- Reuse Dashboard redux data in Explore ([#20668](https://github.com/apache/superset/issues/20668)) ([ff5b4bc](https://github.com/apache/superset/commit/ff5b4bc0e47f057e0660d453a9e53f939613356b))
- root context provider extension point ([#22188](https://github.com/apache/superset/issues/22188)) ([aa97ba4](https://github.com/apache/superset/commit/aa97ba4509431a82922f2fa6930928093c876d6f))
- **select:** keep options order when in single mode ([#19085](https://github.com/apache/superset/issues/19085)) ([ae13d83](https://github.com/apache/superset/commit/ae13d8313b5687374f5b24e02bccdcc717ba19eb))
- **SIP-95:** catalogs in SQL Lab and datasets ([#28376](https://github.com/apache/superset/issues/28376)) ([ce668d4](https://github.com/apache/superset/commit/ce668d46cc5d429a249fdd9e091650457da20361))
- **sqllab:** ResultTable extension ([#25423](https://github.com/apache/superset/issues/25423)) ([deef3b0](https://github.com/apache/superset/commit/deef3b04ebed1178259af5909779392cfa0cd630))
- **sqllab:** SQLEditor Extension ([#24205](https://github.com/apache/superset/issues/24205)) ([1d9a761](https://github.com/apache/superset/commit/1d9a761de5410fa1bd208bca4c78614779cf3064))
- **ssh_tunnel:** SQLAlchemy Form UI ([#22513](https://github.com/apache/superset/issues/22513)) ([5399365](https://github.com/apache/superset/commit/539936522fbbda46ebb39b65ed298f6e251a548f))
- **ssh_tunnel:** SSH Tunnel Switch extension ([#22967](https://github.com/apache/superset/issues/22967)) ([cf395ac](https://github.com/apache/superset/commit/cf395ac2d8e04782cffc93e8a0a0b28678c407fe))
- **storybook:** Co-habitating/Upgrading Storybooks to v7 (dependency madness ensues) ([#26907](https://github.com/apache/superset/issues/26907)) ([753ef69](https://github.com/apache/superset/commit/753ef695294ce26238b68ff41ba0a9af6aea74de))
- **superset-ui-core:** add feature flag for the analogous colors ([#19987](https://github.com/apache/superset/issues/19987)) ([80b5578](https://github.com/apache/superset/commit/80b55786809310e28566d745308b167f0e74b144))
- SupersetClient config to override 401 behavior ([#19144](https://github.com/apache/superset/issues/19144)) ([96a123f](https://github.com/apache/superset/commit/96a123f553f80ae7454daaf139b33e1397d9e3f7))
- Support further drill by in the modal ([#23615](https://github.com/apache/superset/issues/23615)) ([587e775](https://github.com/apache/superset/commit/587e7759b1b674440ac0aa705ebae6599564875f))
- support mulitple temporal filters in AdhocFilter and move the Time Section away ([#21767](https://github.com/apache/superset/issues/21767)) ([a9b229d](https://github.com/apache/superset/commit/a9b229dd1dd9cb9dc8166b1392179fcccb4da138))
- **table:** Table with Time Comparison ([#28057](https://github.com/apache/superset/issues/28057)) ([7ddea62](https://github.com/apache/superset/commit/7ddea62331617dad1b8ade1abe7dd8c11a1ba20d))
- **time_comparison:** Support all date formats when computing custom and inherit offsets ([#30002](https://github.com/apache/superset/issues/30002)) ([bc6d2db](https://github.com/apache/superset/commit/bc6d2dba373e59a498d942909ab6631e5c8521e9))
- UI override registry ([#19671](https://github.com/apache/superset/issues/19671)) ([4927685](https://github.com/apache/superset/commit/4927685c3059c0207713bceeea7c60f1f3b75ec3))
- Utility function to render chart tooltips ([#27950](https://github.com/apache/superset/issues/27950)) ([b549977](https://github.com/apache/superset/commit/b549977f0538d6939dce756c7615052e5f2e6c93))
- Visualize SqlLab.Query model data in Explore 📈 ([#20281](https://github.com/apache/superset/issues/20281)) ([e5e8867](https://github.com/apache/superset/commit/e5e886739460c011a885a13b873665410045a19c))
- **viz-gallery:** add 'feature' tag and fuzzy search weighting ([#18662](https://github.com/apache/superset/issues/18662)) ([7524e1e](https://github.com/apache/superset/commit/7524e1e3c86f3de2b3b0343c3ec5efc0b345937a))

### Performance Improvements

- **dashboard:** Virtualization POC ([#21438](https://github.com/apache/superset/issues/21438)) ([406e44b](https://github.com/apache/superset/commit/406e44bba11f6b233c3b07d29efd158b8cfc9615))
- Lazy load rehype-raw and react-markdown ([#29855](https://github.com/apache/superset/issues/29855)) ([5b5f448](https://github.com/apache/superset/commit/5b5f448af04afedec1387c2f04c658dfced6d95a))
- **plugin-chart-table:** Add memoization to avoid rerenders ([#19976](https://github.com/apache/superset/issues/19976)) ([0f68dee](https://github.com/apache/superset/commit/0f68deedf105300c8bd2536bd205d128799c0381))
- Remove antd-with-locales import ([#29788](https://github.com/apache/superset/issues/29788)) ([f1136b5](https://github.com/apache/superset/commit/f1136b57dd6b4cbcb7628dcbf6b1ac46e2a8301b))

### Reverts

- Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (#20689) ([5317462](https://github.com/apache/superset/commit/5317462b49d050d93d91eee5e97ec56e15f9f298)), closes [#20668](https://github.com/apache/superset/issues/20668) [#20689](https://github.com/apache/superset/issues/20689)

# [0.18.0](https://github.com/apache-superset/superset-ui/compare/v0.17.87...v0.18.0) (2021-08-30)

**Note:** Version bump only for package @superset-ui/core
