/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;
import org.apache.flink.api.java.summarize.aggregation.NumericSummaryAggregator;

@Internal
public class FloatSummaryAggregator
extends NumericSummaryAggregator<Float> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Aggregator<Float, Float> initMin() {
        return new MinFloatAggregator();
    }

    @Override
    protected Aggregator<Float, Float> initMax() {
        return new MaxFloatAggregator();
    }

    @Override
    protected Aggregator<Float, Float> initSum() {
        return new SumFloatAggregator();
    }

    @Override
    protected boolean isNan(Float number) {
        return number.isNaN();
    }

    @Override
    protected boolean isInfinite(Float number) {
        return number.isInfinite();
    }

    public static class SumFloatAggregator
    implements Aggregator<Float, Float> {
        private CompensatedSum sum = CompensatedSum.ZERO;

        @Override
        public void aggregate(Float value) {
            this.sum = this.sum.add(value.floatValue());
        }

        @Override
        public void combine(Aggregator<Float, Float> other) {
            this.sum = this.sum.add(((SumFloatAggregator)other).sum);
        }

        @Override
        public Float result() {
            return Float.valueOf((float)this.sum.value());
        }
    }

    public static class MaxFloatAggregator
    implements Aggregator<Float, Float> {
        private float max = Float.NEGATIVE_INFINITY;

        @Override
        public void aggregate(Float value) {
            this.max = Math.max(this.max, value.floatValue());
        }

        @Override
        public void combine(Aggregator<Float, Float> other) {
            this.max = Math.max(this.max, ((MaxFloatAggregator)other).max);
        }

        @Override
        public Float result() {
            return Float.valueOf(this.max);
        }
    }

    public static class MinFloatAggregator
    implements Aggregator<Float, Float> {
        private float min = Float.POSITIVE_INFINITY;

        @Override
        public void aggregate(Float value) {
            this.min = Math.min(this.min, value.floatValue());
        }

        @Override
        public void combine(Aggregator<Float, Float> other) {
            this.min = Math.min(this.min, ((MinFloatAggregator)other).min);
        }

        @Override
        public Float result() {
            return Float.valueOf(this.min);
        }
    }
}

