/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.bufferdebloat;

import java.time.Duration;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.util.Preconditions;

public class BufferDebloater {
    private static final long MILLIS_IN_SECOND = 1000L;
    private final Duration targetTotalBufferSize;
    private final IndexedInputGate[] inputGates;
    private final long maxBufferSize;
    private final long minBufferSize;
    private final double bufferDebloatThresholdFactor;
    private int lastBufferSize;
    private Duration lastEstimatedTimeToConsumeBuffers = Duration.ZERO;

    public BufferDebloater(Configuration taskConfig, IndexedInputGate[] inputGates) {
        this.inputGates = inputGates;
        this.targetTotalBufferSize = (Duration)taskConfig.get(TaskManagerOptions.BUFFER_DEBLOAT_TARGET);
        this.maxBufferSize = ((MemorySize)taskConfig.get(TaskManagerOptions.MEMORY_SEGMENT_SIZE)).getBytes();
        this.minBufferSize = ((MemorySize)taskConfig.get(TaskManagerOptions.MIN_MEMORY_SEGMENT_SIZE)).getBytes();
        this.bufferDebloatThresholdFactor = (double)taskConfig.getInteger(TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES) / 100.0;
        this.lastBufferSize = (int)this.maxBufferSize;
        Preconditions.checkArgument((this.maxBufferSize <= Integer.MAX_VALUE ? 1 : 0) != 0);
        Preconditions.checkArgument((this.maxBufferSize > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.minBufferSize > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.maxBufferSize >= this.minBufferSize ? 1 : 0) != 0);
        Preconditions.checkArgument(((double)this.targetTotalBufferSize.toMillis() > 0.0 ? 1 : 0) != 0);
    }

    public void recalculateBufferSize(long currentThroughput) {
        long desiredTotalBufferSizeInBytes = currentThroughput * this.targetTotalBufferSize.toMillis() / 1000L;
        int totalNumber = 0;
        for (IndexedInputGate inputGate : this.inputGates) {
            totalNumber += Math.max(1, inputGate.getBuffersInUseCount());
        }
        int newSize = (int)Math.max(this.minBufferSize, Math.min(desiredTotalBufferSizeInBytes / (long)totalNumber, this.maxBufferSize));
        this.lastEstimatedTimeToConsumeBuffers = Duration.ofMillis((long)(newSize * totalNumber) * 1000L / Math.max(1L, currentThroughput));
        boolean skipUpdate = this.skipUpdate(newSize);
        if (skipUpdate) {
            return;
        }
        this.lastBufferSize = newSize;
        for (IndexedInputGate inputGate : this.inputGates) {
            if (inputGate.isFinished()) continue;
            inputGate.announceBufferSize(newSize);
        }
    }

    @VisibleForTesting
    boolean skipUpdate(int newSize) {
        if (newSize == this.lastBufferSize) {
            return true;
        }
        if ((long)newSize <= this.minBufferSize || (long)newSize >= this.maxBufferSize) {
            return false;
        }
        int delta = (int)((double)this.lastBufferSize * this.bufferDebloatThresholdFactor);
        return Math.abs(newSize - this.lastBufferSize) < delta;
    }

    public int getLastBufferSize() {
        return this.lastBufferSize;
    }

    public Duration getLastEstimatedTimeToConsumeBuffers() {
        return this.lastEstimatedTimeToConsumeBuffers;
    }
}

