/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

public class ConsumerVertexGroup
implements Iterable<ExecutionVertexID> {
    private final List<ExecutionVertexID> vertices;

    private ConsumerVertexGroup(List<ExecutionVertexID> vertices) {
        this.vertices = vertices;
    }

    public static ConsumerVertexGroup fromMultipleVertices(List<ExecutionVertexID> vertices) {
        return new ConsumerVertexGroup(vertices);
    }

    public static ConsumerVertexGroup fromSingleVertex(ExecutionVertexID vertex) {
        return new ConsumerVertexGroup(Collections.singletonList(vertex));
    }

    @Override
    public Iterator<ExecutionVertexID> iterator() {
        return this.vertices.iterator();
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    public ExecutionVertexID getFirst() {
        return this.iterator().next();
    }
}

