/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;

class WkbUtil {
    static final byte BIG_ENDIAN = 0;
    static final byte LITTLE_ENDIAN = 1;
    static final int WKB_MIN_TYPE = (int)GeoTypeId.POINT.getValue();
    static final int WKB_MAX_TYPE = (int)GeoTypeId.GEOMETRY_COLLECTION.getValue();
    static final int DIM_OFFSET_2D = 0;
    static final int DIM_OFFSET_Z = 1000;
    static final int DIM_OFFSET_M = 2000;
    static final int DIM_OFFSET_ZM = 3000;
    static final int BYTE_SIZE = 1;
    static final int INT_SIZE = 4;
    static final int DOUBLE_SIZE = 8;
    static final int TYPE_SIZE = 4;

    private WkbUtil() {
    }

    static boolean isValidBaseType(int type) {
        return type >= WKB_MIN_TYPE && type <= WKB_MAX_TYPE;
    }

    private static int getBaseTypeValue(int wkbType) {
        if (wkbType >= 3000 + WKB_MIN_TYPE && wkbType <= 3000 + WKB_MAX_TYPE) {
            return wkbType - 3000;
        }
        if (wkbType >= 2000 + WKB_MIN_TYPE && wkbType <= 2000 + WKB_MAX_TYPE) {
            return wkbType - 2000;
        }
        if (wkbType >= 1000 + WKB_MIN_TYPE && wkbType <= 1000 + WKB_MAX_TYPE) {
            return wkbType - 1000;
        }
        return wkbType;
    }

    static GeoTypeId getBaseType(int wkbType) {
        return GeoTypeId.fromValue(WkbUtil.getBaseTypeValue(wkbType));
    }

    static int getDimensionCount(int wkbType) {
        if (wkbType >= 3000 + WKB_MIN_TYPE && wkbType <= 3000 + WKB_MAX_TYPE) {
            return 4;
        }
        if (wkbType >= 2000 + WKB_MIN_TYPE && wkbType <= 2000 + WKB_MAX_TYPE) {
            return 3;
        }
        if (wkbType >= 1000 + WKB_MIN_TYPE && wkbType <= 1000 + WKB_MAX_TYPE) {
            return 3;
        }
        return 2;
    }

    static boolean hasZ(int wkbType) {
        int baseType = WkbUtil.getBaseTypeValue(wkbType);
        int offset = wkbType - baseType;
        return offset == 1000 || offset == 3000;
    }

    static boolean hasM(int wkbType) {
        int baseType = WkbUtil.getBaseTypeValue(wkbType);
        int offset = wkbType - baseType;
        return offset == 2000 || offset == 3000;
    }

    static boolean isValidWkbType(int wkbType) {
        int baseType = WkbUtil.getBaseTypeValue(wkbType);
        if (!WkbUtil.isValidBaseType(baseType)) {
            return false;
        }
        int offset = wkbType - baseType;
        return offset == 0 || offset == 1000 || offset == 2000 || offset == 3000;
    }
}

