/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TupleIntersectionAggBase;
import org.apache.spark.sql.catalyst.expressions.aggregate.TupleIntersectionAggDouble$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child, mode) - Returns the intersected TupleSketch compact binary representation.\n      `child` should be a binary TupleSketch representation created with a double type summary.\n      `mode` is the aggregation mode for numeric summaries during intersection (sum, min, max, alwaysone). Default is sum. ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_double(_FUNC_(sketch)) FROM (SELECT tuple_sketch_agg_double(key, summary) as sketch FROM VALUES (1, 5.0D), (2, 10.0D), (3, 15.0D) tab(key, summary) UNION ALL SELECT tuple_sketch_agg_double(key, summary) as sketch FROM VALUES (2, 3.0D), (3, 7.0D), (4, 12.0D) tab(key, summary));\n       2.0\n  ", group="agg_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\tUb\u0001B\u0014)\u0001^B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005\u0019\"AQ\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005g\u0001\tE\t\u0015!\u0003M\u0011!9\u0007A!f\u0001\n\u0003B\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B5\t\u00115\u0004!Q3A\u0005B!D\u0001B\u001c\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006_\u0002!\tA\u001e\u0005\u0006_\u0002!\t\u0001\u001f\u0005\u0006w\u0002!\t\u0005 \u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0015\u0002\n!1\u00111\u0003\u0001\u0005B\rDa!!\u0006\u0001\t\u0003\u001a\u0007bBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003W\u0001A\u0011KA\u0017\u0011\u001d\t9\u0004\u0001C)\u0003sA\u0011\"!\u0015\u0001\u0003\u0003%\t!a\u0015\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0003\"CA;\u0001E\u0005I\u0011AA0\u0011%\t9\bAI\u0001\n\u0003\tI\bC\u0005\u0002~\u0001\t\n\u0011\"\u0001\u0002z!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\t\u0003#\u0003\u0011\u0011!C\u0001Q\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003C\u0003\u0011\u0011!C!\u0003GC\u0011\"!-\u0001\u0003\u0003%\t!a-\t\u0013\u0005u\u0006!!A\u0005B\u0005}\u0006\"CAb\u0001\u0005\u0005I\u0011IAc\u000f%\tI\u000fKA\u0001\u0012\u0003\tYO\u0002\u0005(Q\u0005\u0005\t\u0012AAw\u0011\u0019y\u0017\u0005\"\u0001\u0003\u0006!I!qA\u0011\u0002\u0002\u0013\u0015#\u0011\u0002\u0005\n\u0005\u0017\t\u0013\u0011!CA\u0005\u001bA\u0011Ba\u0006\"\u0003\u0003%\tI!\u0007\t\u0013\t-\u0012%!A\u0005\n\t5\"A\u0007+va2,\u0017J\u001c;feN,7\r^5p]\u0006;w\rR8vE2,'BA\u0015+\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001H\u0012)W!\rI$\bP\u0007\u0002Q%\u00111\b\u000b\u0002\u0019)V\u0004H.Z%oi\u0016\u00148/Z2uS>t\u0017iZ4CCN,\u0007CA\u001fE\u001b\u0005q$BA A\u0003\u001d\tGm\\;cY\u0016T!!\u0011\"\u0002\u000bQ,\b\u000f\\3\u000b\u0005\r\u0013\u0014\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018BA#?\u00055!u.\u001e2mKN+X.\\1ssB\u0019qI\u0013'\u000e\u0003!S!!\u0013\u0017\u0002\u000bQ\u0014X-Z:\n\u0005-C%A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011QJT\u0007\u0002U%\u0011qJ\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&a\u0002)s_\u0012,8\r\u001e\t\u0003/~s!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005m3\u0014A\u0002\u001fs_>$h(C\u0001T\u0013\tq&+A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'\u0001D*fe&\fG.\u001b>bE2,'B\u00010S\u0003\u0015\u0019\u0007.\u001b7e+\u0005a\u0015AB2iS2$\u0007%\u0001\u0003n_\u0012,\u0017!B7pI\u0016\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003%\u0004\"!\u00156\n\u0005-\u0014&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"R!\u001d:tiV\u0004\"!\u000f\u0001\t\u000b\tL\u0001\u0019\u0001'\t\u000b\u0015L\u0001\u0019\u0001'\t\u000b\u001dL\u0001\u0019A5\t\u000b5L\u0001\u0019A5\u0015\u0005E<\b\"\u00022\u000b\u0001\u0004aEcA9zu\")!m\u0003a\u0001\u0019\")Qm\u0003a\u0001\u0019\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002r{\")a\u0010\u0004a\u0001S\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019\u0011/a\u0001\t\r\u0005\u0015Q\u00021\u0001j\u0003]qWm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u0011/a\u0003\u0002\u0010!1\u0011Q\u0002\bA\u00021\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u00129\u0001\r\u0001T\u0001\t]\u0016<(+[4ii\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00037\u0001B!!\b\u0002&9!\u0011qDA\u0011!\tI&+C\u0002\u0002$I\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u0012%\u0006Q2M]3bi\u0016\u001cV/\\7bef\u001cV\r^(qKJ\fG/[8ogR\u0011\u0011q\u0006\t\u0006\u0003c\t\u0019\u0004P\u0007\u0002\u0001&\u0019\u0011Q\u0007!\u0003)M+X.\\1ssN+Go\u00149fe\u0006$\u0018n\u001c8t\u00035AW-\u00199jMf\u001c6.\u001a;dQR!\u00111HA!!\u0015\t\t$!\u0010=\u0013\r\ty\u0004\u0011\u0002\u0007'.,Go\u00195\t\u000f\u0005\r3\u00031\u0001\u0002F\u00051!-\u001e4gKJ\u0004R!UA$\u0003\u0017J1!!\u0013S\u0005\u0015\t%O]1z!\r\t\u0016QJ\u0005\u0004\u0003\u001f\u0012&\u0001\u0002\"zi\u0016\fAaY8qsRI\u0011/!\u0016\u0002X\u0005e\u00131\f\u0005\bER\u0001\n\u00111\u0001M\u0011\u001d)G\u0003%AA\u00021Cqa\u001a\u000b\u0011\u0002\u0003\u0007\u0011\u000eC\u0004n)A\u0005\t\u0019A5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\r\u0016\u0004\u0019\u0006\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=$+\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA>U\rI\u00171M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0015\u0001\u00026bm\u0006LA!a\n\u0002\b\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAL\u0003;\u00032!UAM\u0013\r\tYJ\u0015\u0002\u0004\u0003:L\b\u0002CAP7\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000b\u0005\u0004\u0002(\u00065\u0016qS\u0007\u0003\u0003SS1!a+S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA[\u0003w\u00032!UA\\\u0013\r\tIL\u0015\u0002\b\u0005>|G.Z1o\u0011%\ty*HA\u0001\u0002\u0004\t9*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAB\u0003\u0003D\u0001\"a(\u001f\u0003\u0003\u0005\r![\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u0016q\u0019\u0005\n\u0003?{\u0012\u0011!a\u0001\u0003/C3\u0003AAf\u0003#\f\u0019.a6\u0002Z\u0006u\u0017q\\Ar\u0003K\u00042!TAg\u0013\r\tyM\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t).\u0001B:\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2iS2$G\u0006I7pI\u0016L\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001b8uKJ\u001cXm\u0019;fI\u0002\"V\u000f\u001d7f'.,Go\u00195!G>l\u0007/Y2uA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]:R\u0001\u0005\t\u0011!A\u0001\u00027\r[5mI\u0002\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011bA\tLg.\u0019:zAQ+\b\u000f\\3TW\u0016$8\r\u001b\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8!GJ,\u0017\r^3eA]LG\u000f\u001b\u0011bA\u0011|WO\u00197fAQL\b/\u001a\u0011tk6l\u0017M]=/\u0015\u0001\u0002\u0003\u0005\t\u0011!A6|G-\u001a1!SN\u0004C\u000f[3!C\u001e<'/Z4bi&|g\u000eI7pI\u0016\u0004cm\u001c:!]VlWM]5dAM,X.\\1sS\u0016\u001c\b\u0005Z;sS:<\u0007%\u001b8uKJ\u001cXm\u0019;j_:\u0004\u0003f];nY\u0001j\u0017N\u001c\u0017![\u0006DH\u0006I1mo\u0006L8o\u001c8fS9\u0002C)\u001a4bk2$\b%[:!gVlg\u0006I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111\\\u0001\u00030*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003C/\u001e9mK~\u001b8.\u001a;dQ~+7\u000f^5nCR,w\fZ8vE2,\u0007f\u0018$V\u001d\u000e{\u0006f]6fi\u000eD\u0017&\u000b\u0011G%>k\u0005\u0005K*F\u0019\u0016\u001bE\u000b\t;va2,wl]6fi\u000eDw,Y4h?\u0012|WO\u00197fQ-,\u0017\u0010\f\u0011tk6l\u0017M]=*A\u0005\u001c\be]6fi\u000eD\u0007E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013\u0007\f\u00116]A\"\u0015\u0006\f\u0011)e1\u0002\u0013\u0007\r\u00181\t&b\u0003\u0005K\u001a-AE*d\u0006\r#*AQ\f'\rK6fs2\u00023/^7nCJL\u0018\u0006I+O\u0013>s\u0005%\u0011'MAM+E*R\"UAQ,\b\u000f\\3`g.,Go\u00195`C\u001e<w\fZ8vE2,\u0007f[3zY\u0001\u001aX/\\7befL\u0003%Y:!g.,Go\u00195!\rJ{U\n\t,B\u0019V+5\u000b\t\u00153Y\u0001\u001ad\u0006\r#*Y\u0001B3\u0007\f\u00118]A\"\u0015\u0006\f\u0011)i1\u0002\u0013G\r\u00181\t&\u0002C/\u00192)W\u0016LH\u0006I:v[6\f'/_\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012d\u0006\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011\u0011]\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#!a:\u0002\u000bQr#G\f\u0019\u00025Q+\b\u000f\\3J]R,'o]3di&|g.Q4h\t>,(\r\\3\u0011\u0005e\n3#B\u0011\u0002p\u0006m\b#CAy\u0003odE*[5r\u001b\t\t\u0019PC\u0002\u0002vJ\u000bqA];oi&lW-\u0003\u0003\u0002z\u0006M(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!\u0011Q B\u0002\u001b\t\tyP\u0003\u0003\u0003\u0002\u0005-\u0015AA5p\u0013\r\u0001\u0017q \u000b\u0003\u0003W\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\u000bQ!\u00199qYf$\u0012\"\u001dB\b\u0005#\u0011\u0019B!\u0006\t\u000b\t$\u0003\u0019\u0001'\t\u000b\u0015$\u0003\u0019\u0001'\t\u000b\u001d$\u0003\u0019A5\t\u000b5$\u0003\u0019A5\u0002\u000fUt\u0017\r\u001d9msR!!1\u0004B\u0014!\u0015\t&Q\u0004B\u0011\u0013\r\u0011yB\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fE\u0013\u0019\u0003\u0014'jS&\u0019!Q\u0005*\u0003\rQ+\b\u000f\\35\u0011!\u0011I#JA\u0001\u0002\u0004\t\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0006\t\u0005\u0003\u000b\u0013\t$\u0003\u0003\u00034\u0005\u001d%AB(cU\u0016\u001cG\u000f")
public class TupleIntersectionAggDouble
extends TupleIntersectionAggBase<DoubleSummary>
implements BinaryLike<Expression>,
Serializable {
    private final Expression child;
    private final Expression mode;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(TupleIntersectionAggDouble x$0) {
        return TupleIntersectionAggDouble$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, TupleIntersectionAggDouble> tupled() {
        return TupleIntersectionAggDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, TupleIntersectionAggDouble>>>> curried() {
        return TupleIntersectionAggDouble$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        TupleIntersectionAggDouble tupleIntersectionAggDouble = this;
        synchronized (tupleIntersectionAggDouble) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Expression mode() {
        return this.mode;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public TupleIntersectionAggDouble withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public TupleIntersectionAggDouble withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public TupleIntersectionAggDouble withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.mode();
    }

    @Override
    public String prettyName() {
        return "tuple_intersection_agg_double";
    }

    @Override
    public SummarySetOperations<DoubleSummary> createSummarySetOperations() {
        return new DoubleSummarySetOperations(this.modeEnum().toDoubleSummaryMode());
    }

    @Override
    public Sketch<DoubleSummary> heapifySketch(byte[] buffer) {
        return TupleSketchUtils$.MODULE$.heapifyDoubleSketch(buffer, this.prettyName());
    }

    public TupleIntersectionAggDouble copy(Expression child, Expression mode, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new TupleIntersectionAggDouble(child, mode, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.mode();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "TupleIntersectionAggDouble";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.mode();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleIntersectionAggDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mode";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleIntersectionAggDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleIntersectionAggDouble tupleIntersectionAggDouble = (TupleIntersectionAggDouble)x$1;
        if (this.mutableAggBufferOffset() != tupleIntersectionAggDouble.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != tupleIntersectionAggDouble.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = tupleIntersectionAggDouble.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.mode();
        Expression expression4 = tupleIntersectionAggDouble.mode();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tupleIntersectionAggDouble.canEqual(this)) return false;
        return true;
    }

    public TupleIntersectionAggDouble(Expression child, Expression mode, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mode = mode;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
    }

    public TupleIntersectionAggDouble(Expression child) {
        this(child, Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()), 0, 0);
    }

    public TupleIntersectionAggDouble(Expression child, Expression mode) {
        this(child, mode, 0, 0);
    }
}

