/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleSketchEstimateInteger$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns the estimated number of unique values\n    given the binary representation of a Datasketches TupleSketch. The sketch's\n    summary type must be an integer. ", examples="\n    Examples:\n      > SELECT _FUNC_(tuple_sketch_agg_integer(key, summary)) FROM VALUES (1, 1), (1, 2), (2, 3) tab(key, summary);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C!1\")!\r\u0001C!G\")q\r\u0001C!Q\")\u0011\u000f\u0001C)e\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u0013!\u0004V;qY\u0016\u001c6.\u001a;dQ\u0016\u001bH/[7bi\u0016Le\u000e^3hKJT!\u0001H\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=}\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0007\u0001%j3G\u000e\u001f\u0011\u0005)ZS\"A\u000e\n\u00051Z\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\nT\"A\u0018\u000b\u0005AZ\u0012aB2pI\u0016<WM\\\u0005\u0003e=\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003UQJ!!N\u000e\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005u*eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\tu%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011A\tO\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Eq\u0005)1\r[5mIV\t!\n\u0005\u0002+\u0017&\u0011Aj\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003!F\u0003\"A\u000b\u0001\t\u000b!\u001b\u0001\u0019\u0001&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tA\u000b\u0005\u00028+&\u0011a\u000b\u000f\u0002\b\u0005>|G.Z1o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00023B\u0019QH\u0017/\n\u0005m;%aA*fcB\u0011Q\fY\u0007\u0002=*\u0011qlH\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001a\t\u0003;\u0016L!A\u001a0\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005I\u0007C\u00016o\u001d\tYG\u000e\u0005\u0002@q%\u0011Q\u000eO\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002nq\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"\u0001U:\t\u000bQD\u0001\u0019\u0001&\u0002\u00119,wo\u00115jY\u0012\fAB\\;mYN\u000bg-Z#wC2$\"a\u001e>\u0011\u0005]B\u0018BA=9\u0005\r\te.\u001f\u0005\u0006w&\u0001\ra^\u0001\u0006S:\u0004X\u000f^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Q}\"9\u0001J\u0003I\u0001\u0002\u0004Q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007Q3ASA\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\tq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0004_\u0006}\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\r9\u0014qF\u0005\u0004\u0003cA$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA<\u00028!I\u0011\u0011\b\b\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f:XBAA\"\u0015\r\t)\u0005O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A+a\u0014\t\u0011\u0005e\u0002#!AA\u0002]\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111DA+\u0011%\tI$EA\u0001\u0002\u0004\ti#\u0001\u0004fcV\fGn\u001d\u000b\u0004)\u0006m\u0003\u0002CA\u001d%\u0005\u0005\t\u0019A<)'\u0001\ty&!\u001a\u0002h\u0005-\u0014QNA9\u0003g\n9(!\u001f\u0011\u0007)\n\t'C\u0002\u0002dm\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002j\u0005\t\tH\u0003\u0011!A\u0001zf)\u0016(D?\"\u001a\u0007.\u001b7eS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*7\u000f^5nCR,G\r\t8v[\n,'\u000fI8gAUt\u0017.];fAY\fG.^3t\u0015\u0001\u0002\u0003\u0005I4jm\u0016t\u0007\u0005\u001e5fA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]\u0002zg\rI1!\t\u0006$\u0018m]6fi\u000eDWm\u001d\u0011UkBdWmU6fi\u000eDg\u0006\t+iK\u0002\u001a8.\u001a;dQ\u001e\u001a(\u0002\t\u0011!AM,X.\\1ss\u0002\"\u0018\u0010]3![V\u001cH\u000f\t2fA\u0005t\u0007%\u001b8uK\u001e,'O\f\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001c\u0002\u0003CQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006^;qY\u0016|6o[3uG\"|\u0016mZ4`S:$XmZ3sQ-,\u0017\u0010\f\u0011tk6l\u0017M]=*S\u00012%kT'!-\u0006cU+R*!QEb\u0003%M\u0015-A!\nD\u0006\t\u001a*Y\u0001B#\u0007\f\u00114S\u0001\"\u0018M\u0019\u0015lKfd\u0003e];n[\u0006\u0014\u00180K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e9\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005U\u0014\u0001D:lKR\u001c\u0007n\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA>\u0003\u0015!dF\r\u00181\u0003i!V\u000f\u001d7f'.,Go\u00195FgRLW.\u0019;f\u0013:$XmZ3s!\tQCcE\u0003\u0015\u0003\u0007\u000by\t\u0005\u0004\u0002\u0006\u0006-%\nU\u0007\u0003\u0003\u000fS1!!#9\u0003\u001d\u0011XO\u001c;j[\u0016LA!!$\u0002\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002$\u0005\u0011\u0011n\\\u0005\u0004\r\u0006MECAA@\u0003!!xn\u0015;sS:<GCAA\u000e\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0001\u00161\u0015\u0005\u0006\u0011^\u0001\rAS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI+a,\u0011\t]\nYKS\u0005\u0004\u0003[C$AB(qi&|g\u000e\u0003\u0005\u00022b\t\t\u00111\u0001Q\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003o\u0003B!!\b\u0002:&!\u00111XA\u0010\u0005\u0019y%M[3di\u0002")
public class TupleSketchEstimateInteger
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(TupleSketchEstimateInteger x$0) {
        return TupleSketchEstimateInteger$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<TupleSketchEstimateInteger, A> g) {
        return TupleSketchEstimateInteger$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, TupleSketchEstimateInteger> compose(Function1<A$, Expression> g) {
        return TupleSketchEstimateInteger$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "tuple_sketch_estimate_integer";
    }

    @Override
    public TupleSketchEstimateInteger withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Object nullSafeEval(Object input) {
        byte[] buffer = (byte[])input;
        Sketch<IntegerSummary> sketch = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(buffer, this.prettyName());
        return BoxesRunTime.boxToDouble((double)sketch.getEstimate());
    }

    public TupleSketchEstimateInteger copy(Expression child) {
        return new TupleSketchEstimateInteger(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "TupleSketchEstimateInteger";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleSketchEstimateInteger;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleSketchEstimateInteger)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleSketchEstimateInteger tupleSketchEstimateInteger = (TupleSketchEstimateInteger)x$1;
        Expression expression = this.child();
        Expression expression2 = tupleSketchEstimateInteger.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!tupleSketchEstimateInteger.canEqual(this)) return false;
        return true;
    }

    public TupleSketchEstimateInteger(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

