/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.core;

import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public final class Authentication
implements Serializable,
Product {
    private final String user;
    private final Option<String> passwordOpt;
    private final Seq<Tuple2<String, String>> httpHeaders;
    private final boolean optional;
    private final Option<String> realmOpt;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public String user() {
        return this.user;
    }

    public Option<String> passwordOpt() {
        return this.passwordOpt;
    }

    public Seq<Tuple2<String, String>> httpHeaders() {
        return this.httpHeaders;
    }

    public boolean optional() {
        return this.optional;
    }

    public Option<String> realmOpt() {
        return this.realmOpt;
    }

    public boolean httpsOnly() {
        return this.httpsOnly;
    }

    public boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    public String toString() {
        Seq headersStr = (Seq)this.httpHeaders().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return new Tuple2<String, String>(k, "****");
            }
            throw new MatchError(tuple2);
        });
        return new StringBuilder(32).append("Authentication(").append(this.user()).append(", ****, ").append(headersStr).append(", ").append(this.optional()).append(", ").append(this.realmOpt()).append(", ").append(this.httpsOnly()).append(", ").append(this.passOnRedirect()).append(")").toString();
    }

    public boolean userOnly() {
        Authentication authentication = this;
        Authentication authentication2 = Authentication$.MODULE$.apply(this.user());
        return !(authentication != null ? !((Object)authentication).equals(authentication2) : authentication2 != null);
    }

    public Seq<Tuple2<String, String>> allHttpHeaders() {
        Seq basicAuthHeader = (Seq)Option$.MODULE$.option2Iterable(this.passwordOpt()).toSeq().map((Function1<String, Tuple2> & Serializable)p -> new Tuple2<String, String>("Authorization", new StringBuilder(6).append("Basic ").append(Authentication$.MODULE$.basicAuthenticationEncode(this.user(), (String)p)).toString()));
        return (Seq)basicAuthHeader.$plus$plus(this.httpHeaders());
    }

    public Authentication withOptional(boolean optional) {
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), optional, this.realmOpt(), this.httpsOnly(), this.passOnRedirect());
    }

    public Authentication withHttpsOnly(boolean httpsOnly) {
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), this.optional(), this.realmOpt(), httpsOnly, this.passOnRedirect());
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof Authentication && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        Authentication other = (Authentication)obj;
        if (!true) return false;
        String string = this.user();
        String string2 = other.user();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.passwordOpt();
        Option<String> option2 = other.passwordOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Tuple2<String, String>> seq = this.httpHeaders();
        Seq<Tuple2<String, String>> seq2 = other.httpHeaders();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.optional() != other.optional()) return false;
        Option<String> option3 = this.realmOpt();
        Option<String> option4 = other.realmOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.httpsOnly() != other.httpsOnly()) return false;
        if (this.passOnRedirect() != other.passOnRedirect()) return false;
        return true;
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("Authentication");
        code = 37 * code + Statics.anyHash(this.user());
        code = 37 * code + Statics.anyHash(this.passwordOpt());
        code = 37 * code + Statics.anyHash(this.httpHeaders());
        code = 37 * code + (this.optional() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.realmOpt());
        code = 37 * code + (this.httpsOnly() ? 1231 : 1237);
        code = 37 * code + (this.passOnRedirect() ? 1231 : 1237);
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "Authentication";
    }

    @Override
    public int productArity() {
        return 7;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.user();
            }
            case 1: {
                return this.passwordOpt();
            }
            case 2: {
                return this.httpHeaders();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean(this.optional());
            }
            case 4: {
                return this.realmOpt();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean(this.httpsOnly());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean(this.passOnRedirect());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public Authentication(String user, Option<String> passwordOpt, Seq<Tuple2<String, String>> httpHeaders, boolean optional, Option<String> realmOpt, boolean httpsOnly, boolean passOnRedirect) {
        this.user = user;
        this.passwordOpt = passwordOpt;
        this.httpHeaders = httpHeaders;
        this.optional = optional;
        this.realmOpt = realmOpt;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
        Product.$init$(this);
    }
}

