/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.HttpURI;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.util.Blocker;
import org.sparkproject.jetty.util.BufferUtil;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.Fields;
import org.sparkproject.jetty.util.Utf8StringBuilder;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.statistic.CounterStatistic;

@ManagedObject
public class DumpHandler
extends Handler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(DumpHandler.class);
    private final Blocker.Shared _blocker = new Blocker.Shared();
    private final String _label;
    private final CounterStatistic _handled = new CounterStatistic();

    public DumpHandler() {
        this("Dump Handler");
    }

    public DumpHandler(String label) {
        this._label = label;
    }

    @ManagedAttribute(value="handled count")
    public CounterStatistic getHandledCounter() {
        return this._handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        try {
            int len;
            this._handled.increment();
            if (LOG.isDebugEnabled()) {
                LOG.debug("dump {}", (Object)request);
            }
            HttpURI httpURI = request.getHttpURI();
            Fields params = Request.extractQueryParameters(request);
            if (Boolean.parseBoolean(params.getValue("flush"))) {
                try (Blocker.Callback blocker = this._blocker.callback();){
                    response.write(false, null, blocker);
                    blocker.block();
                }
            }
            if (Boolean.parseBoolean(params.getValue("empty"))) {
                response.setStatus(200);
                callback.succeeded();
                boolean blocker = true;
                return blocker;
            }
            Utf8StringBuilder read = null;
            if (params.getValue("read") != null) {
                read = new Utf8StringBuilder();
                len = Integer.parseInt(params.getValue("read"));
                byte[] buffer = new byte[8192];
                Iterator<String> chunk = null;
                while (len > 0) {
                    if (chunk == null && (chunk = request.read()) == null) {
                        Blocker.Runnable blocker = this._blocker.runnable();
                        try {
                            request.demand(blocker);
                            blocker.block();
                            continue;
                        }
                        finally {
                            if (blocker != null) {
                                blocker.close();
                            }
                            continue;
                        }
                    }
                    if (Content.Chunk.isFailure(chunk)) {
                        callback.failed(chunk.getFailure());
                        boolean blocker = true;
                        return blocker;
                    }
                    int l = Math.min(buffer.length, Math.min(len, chunk.remaining()));
                    int r = chunk.get(buffer, 0, l);
                    read.append(buffer, 0, r);
                    len -= r;
                    if (chunk.hasRemaining()) continue;
                    boolean last = chunk.isLast();
                    chunk.release();
                    chunk = null;
                    if (!last) continue;
                    break;
                }
                if (chunk != null) {
                    chunk.release();
                }
            }
            if (params.getValue("date") != null) {
                response.getHeaders().put("Date", params.getValue("date"));
            }
            if (params.getValue("ISE") != null) {
                throw new IllegalStateException("Testing ISE");
            }
            if (params.getValue("error") != null) {
                response.setStatus(Integer.parseInt(params.getValue("error")));
                callback.succeeded();
                len = 1;
                return len != 0;
            }
            response.getHeaders().put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML.asString());
            ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, StandardCharsets.ISO_8859_1);
            writer.write("<html><h1>" + this._label + "</h1>\n");
            writer.write("<pre>httpURI=" + String.valueOf(httpURI) + "</pre><br/>\n");
            writer.write("<pre>httpURI.path=" + httpURI.getPath() + "</pre><br/>\n");
            writer.write("<pre>httpURI.query=" + httpURI.getQuery() + "</pre><br/>\n");
            writer.write("<pre>httpURI.pathQuery=" + httpURI.getPathQuery() + "</pre><br/>\n");
            writer.write("<pre>locales=" + String.valueOf(Request.getLocales(request).stream().map(Locale::toLanguageTag).toList()) + "</pre><br/>\n");
            writer.write("<pre>pathInContext=" + Request.getPathInContext(request) + "</pre><br/>\n");
            writer.write("<pre>contentType=" + request.getHeaders().get(HttpHeader.CONTENT_TYPE) + "</pre><br/>\n");
            writer.write("<pre>servername=" + Request.getServerName(request) + "</pre><br/>\n");
            writer.write("<pre>local=" + Request.getLocalAddr(request) + ":" + Request.getLocalPort(request) + "</pre><br/>\n");
            writer.write("<pre>remote=" + Request.getRemoteAddr(request) + ":" + Request.getRemotePort(request) + "</pre><br/>\n");
            writer.write("<h3>Header:</h3><pre>");
            writer.write(String.format("%4s %s %s\n", request.getMethod(), httpURI.getPathQuery(), request.getConnectionMetaData().getProtocol()));
            for (HttpField field : request.getHeaders()) {
                String name = field.getName();
                writer.write(name);
                writer.write(": ");
                String value = field.getValue();
                writer.write(value == null ? "" : value);
                writer.write("\n");
            }
            writer.write("</pre>\n<h3>Attributes:</h3>\n<pre>");
            for (String attr : request.getAttributeNameSet()) {
                writer.write(attr);
                writer.write("=");
                writer.write(request.getAttribute(attr).toString());
                writer.write("\n");
            }
            writer.write("</pre>\n<h3>Content:</h3>\n<pre>");
            if (read != null) {
                writer.write(read.toCompleteString());
            } else {
                writer.write(Content.Source.asString(request));
            }
            writer.write("</pre>\n");
            writer.write("</html>\n");
            ((Writer)writer).flush();
            if (!Boolean.parseBoolean(params.getValue("no-content-length"))) {
                response.getHeaders().put(HttpHeader.CONTENT_LENGTH, (long)(buf.size() + 1000));
            }
            response.getHeaders().add("Before-Flush", response.isCommitted() ? "Committed???" : "Not Committed");
            try (Blocker.Callback blocker = this._blocker.callback();){
                response.write(false, BufferUtil.toBuffer(buf.toByteArray()), blocker);
                blocker.block();
            }
            response.getHeaders().add("After-Flush", "These headers should not be seen in the response!!!");
            String value = response.isCommitted() ? "Committed" : "Not Committed?";
            response.getHeaders().add("After-Flush", value);
            String padding = "ABCDEFGHIJ".repeat(99) + "ABCDEFGH\r\n";
            try (Blocker.Callback blocker = this._blocker.callback();){
                response.write(true, BufferUtil.toBuffer(padding.getBytes(StandardCharsets.ISO_8859_1)), blocker);
                blocker.block();
            }
            callback.succeeded();
            boolean bl = true;
            return bl;
        }
        finally {
            this._handled.decrement();
        }
    }
}

