/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Extract;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r=e\u0001\u0002$H\tJCQA\u001d\u0001\u0005\u0002MDQ!\u001e\u0001\u0005BYD\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005-\u0002\u0001)A\u0005\u0003\u001bA\u0011\"!\f\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005=\u0002\u0001)A\u0005\u0003\u001bA\u0011\"!\r\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005M\u0002\u0001)A\u0005\u0003\u001bAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002>\u0001!\t%a\u0010\u0007\r\u0005=\u0003\u0001AA)\u0011\u0019\u00118\u0002\"\u0001\u0002\\!9\u0011qL\u0006\u0005B\u0005\u0005\u0004bBA<\u0017\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u000f[A\u0011IAE\u0011\u001d\t\u0019j\u0003C!\u0003+Cq!!+\f\t\u0013\tY\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011Q\u001f\u0001\u0005B\u0005]\bb\u0002B\u0003\u0001\u0011\u0005#q\u0001\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u0011I\u0002\u0001C!\u00057AqA!\t\u0001\t\u0003\u0012\u0019\u0003C\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030!9!Q\t\u0001\u0005B\t\u001d\u0003b\u0002B+\u0001\u0011\u0005#q\u000b\u0005\b\u0005C\u0002A\u0011\tB2\u0011\u001d\u0011i\u0007\u0001C!\u0005_BqAa\u001f\u0001\t\u0003\u0012iH\u0002\u0004\u0003\u0004\u0002\u0001!Q\u0011\u0005\n\u0005\u001b{\"\u0011!Q\u0001\nMC!Ba$ \u0005\u0003\u0005\u000b\u0011\u0002BI\u0011\u0019\u0011x\u0004\"\u0001\u0003$\"9!1V\u0010\u0005B\t5\u0006b\u0002BX\u0001\u0011\u0005#\u0011\u0017\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011I\f\u0001C!\u0005oCqAa/\u0001\t\u0003\u00129\fC\u0004\u0003>\u0002!\tEa.\t\u000f\t}\u0006\u0001\"\u0011\u0003B\"A!q\u001e\u0001\u0002\u0002\u0013\u00051\u000fC\u0005\u0003r\u0002\t\t\u0011\"\u0011\u0003t\"I!Q\u001f\u0001\u0002\u0002\u0013\u0005!q\u001f\u0005\n\u0005s\u0004\u0011\u0011!C\u0001\u0005wD\u0011b!\u0001\u0001\u0003\u0003%\tea\u0001\t\u0013\r5\u0001!!A\u0005\u0002\r=\u0001\"CB\n\u0001\u0005\u0005I\u0011IB\u000b\u0011%\u0019I\u0002AA\u0001\n\u0003\u001aY\u0002C\u0005\u0004\u001e\u0001\t\t\u0011\"\u0011\u0004 !I1\u0011\u0005\u0001\u0002\u0002\u0013\u000531E\u0004\t\u0007O9\u0005\u0012A$\u0004*\u00199ai\u0012E\u0001\u000f\u000e-\u0002B\u0002:6\t\u0003\u0019i\u0004C\u0005\u0004@U\u0012\r\u0011\"\u0002\u0004B!A1qI\u001b!\u0002\u001b\u0019\u0019\u0005C\u0005\u0004JU\u0012\r\u0011\"\u0002\u0004L!A1\u0011K\u001b!\u0002\u001b\u0019i\u0005C\u0005\u0004TU\u0012\r\u0011\"\u0002\u0004V!A11L\u001b!\u0002\u001b\u00199\u0006C\u0005\u0004^U\u0012\r\u0011\"\u0002\u0004`!A1QM\u001b!\u0002\u001b\u0019\t\u0007C\u0005\u0004hU\u0012\r\u0011\"\u0002\u0004j!A1qN\u001b!\u0002\u001b\u0019Y\u0007C\u0005\u0004rU\u0012\r\u0011\"\u0002\u0004t!A1\u0011P\u001b!\u0002\u001b\u0019)\b\u0003\u0005\u0004|U\n\t\u0011\"!t\u0011%\u0019i(NA\u0001\n\u0003\u001by\bC\u0005\u0004\u0006V\n\t\u0011\"\u0003\u0004\b\niqJ]1dY\u0016$\u0015.\u00197fGRT!\u0001S%\u0002\t)$'m\u0019\u0006\u0003\u0015.\u000b1a]9m\u0015\taU*A\u0003ta\u0006\u00148N\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<7\u0001A\n\u0007\u0001M;V\f\u00194\u0011\u0005Q+V\"A$\n\u0005Y;%a\u0003&eE\u000e$\u0015.\u00197fGR\u0004\"\u0001W.\u000e\u0003eS!AW%\u0002\u0011\r\fG/\u00197zgRL!\u0001X-\u0003\u001bM\u000bFjQ8oM\"+G\u000e]3s!\t!f,\u0003\u0002`\u000f\n\tbj\u001c'fO\u0006\u001c\u0017P\u0013#C\u0007\u0016\u0013(o\u001c:\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\u000fA\u0013x\u000eZ;diB\u0011qm\u001c\b\u0003Q6t!!\u001b7\u000e\u0003)T!a[)\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0017B\u00018c\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00059\u0014\u0017A\u0002\u001fj]&$h\bF\u0001u!\t!\u0006!A\u0005dC:D\u0015M\u001c3mKR\u0011qO\u001f\t\u0003CbL!!\u001f2\u0003\u000f\t{w\u000e\\3b]\")1P\u0001a\u0001y\u0006\u0019QO\u001d7\u0011\u0007u\f\u0019A\u0004\u0002\u007f\u007fB\u0011\u0011NY\u0005\u0004\u0003\u0003\u0011\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u0002\t\fQ\u0005Z5ti&t7\r^+ogV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0005\u00055\u0001CBA\b\u00033\ti\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0018\t\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY\"!\u0005\u0003\u0007M+G\u000f\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t1\fgn\u001a\u0006\u0003\u0003O\tAA[1wC&!\u0011QAA\u0011\u0003\u0019\"\u0017n\u001d;j]\u000e$XK\\:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u001cgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u00029M,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005\u00112/\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8t\u0003M\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:!\u0003MI7oU;qa>\u0014H/\u001a3Gk:\u001cG/[8o)\r9\u0018\u0011\b\u0005\u0007\u0003wI\u0001\u0019\u0001?\u0002\u0011\u0019,hn\u0019(b[\u0016\f\u0011$[:PE*,7\r\u001e(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]R\u0019q/!\u0011\t\u000f\u0005\r#\u00021\u0001\u0002F\u0005\tQ\r\u0005\u0003\u0002H\u0005-SBAA%\u0015\rQ\u0015QE\u0005\u0005\u0003\u001b\nIE\u0001\u0007T#2+\u0005pY3qi&|gN\u0001\tPe\u0006\u001cG.Z*R\u0019\n+\u0018\u000e\u001c3feN\u00191\"a\u0015\u0011\t\u0005U\u0013qK\u0007\u0002\u0001%\u0019\u0011\u0011L+\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feR\u0011\u0011Q\f\t\u0004\u0003+Z\u0011\u0001\u0004<jg&$X\t\u001f;sC\u000e$Hc\u0001?\u0002d!9\u0011QM\u0007A\u0002\u0005\u001d\u0014aB3yiJ\f7\r\u001e\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005E\u0014*A\u0005d_:tWm\u0019;pe&!\u0011QOA6\u0005\u001d)\u0005\u0010\u001e:bGR\f\u0001C^5tSR\u001c\u0016\u000b\u0014$v]\u000e$\u0018n\u001c8\u0015\u000bq\fY(! \t\r\u0005mb\u00021\u0001}\u0011\u001d\tyH\u0004a\u0001\u0003\u0003\u000ba!\u001b8qkR\u001c\b\u0003B1\u0002\u0004rL1!!\"c\u0005\u0015\t%O]1z\u0003Y1\u0018n]5u\u0003\u001e<'/Z4bi\u00164UO\\2uS>tGc\u0002?\u0002\f\u00065\u0015\u0011\u0013\u0005\u0007\u0003wy\u0001\u0019\u0001?\t\r\u0005=u\u00021\u0001x\u0003)I7\u000fR5ti&t7\r\u001e\u0005\b\u0003\u007fz\u0001\u0019AAA\u0003U1\u0018n]5u\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:$r\u0001`AL\u00037\u000b)\u000b\u0003\u0004\u0002\u001aB\u0001\r\u0001`\u0001\u0005]\u0006lW\rC\u0004\u0002\u001eB\u0001\r!a(\u0002\u00051,\u0007\u0003BA5\u0003CKA!a)\u0002l\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005\u001d\u0006\u00031\u0001\u0002 \u0006\u0011!/Z\u0001\fG>l\u0007/\u0019:f\u00052|'\rF\u0004}\u0003[\u000b\t,!.\t\u000f\u0005=\u0016\u00031\u0001\u0002 \u0006\u0019A\u000e[:\t\r\u0005M\u0016\u00031\u0001}\u0003!y\u0007/\u001a:bi>\u0014\bbBA\\#\u0001\u0007\u0011qT\u0001\u0004e\"\u001c\u0018!E2p[BLG.Z#yaJ,7o]5p]R!\u0011QXAb!\u0011\t\u0017q\u0018?\n\u0007\u0005\u0005'M\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000b\u0014\u0002\u0019AAP\u0003\u0011)\u0007\u0010\u001d:\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"a3\u0002Z\u0006\r\u0018q]Av!\u0015\t\u0017qXAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAj\u0013\u0006)A/\u001f9fg&!\u0011q[Ai\u0005!!\u0015\r^1UsB,\u0007bBAn'\u0001\u0007\u0011Q\\\u0001\bgFdG+\u001f9f!\r\t\u0017q\\\u0005\u0004\u0003C\u0014'aA%oi\"1\u0011Q]\nA\u0002q\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003S\u001c\u0002\u0019AAo\u0003\u0011\u0019\u0018N_3\t\u000f\u000558\u00031\u0001\u0002p\u0006\u0011Q\u000e\u001a\t\u0005\u0003\u001f\f\t0\u0003\u0003\u0002t\u0006E'aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0005\u0003s\u0014\t\u0001E\u0003b\u0003\u007f\u000bY\u0010E\u0002U\u0003{L1!a@H\u0005!QEMY2UsB,\u0007b\u0002B\u0002)\u0001\u0007\u0011QZ\u0001\u0003IR\fAbY8na&dWMV1mk\u0016$BA!\u0003\u0003\u0010A\u0019\u0011Ma\u0003\n\u0007\t5!MA\u0002B]fDqA!\u0005\u0016\u0001\u0004\u0011I!A\u0003wC2,X-\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"Aa\u0006\u0011\t\u0005\fyl^\u0001\u0018SN\u001c\u0016P\u001c;bq\u0016\u0013(o\u001c:CKN$XI\u001a4peR$2a\u001eB\u000f\u0011\u001d\u0011yb\u0006a\u0001\u0003\u000b\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0002!\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH#\u0002?\u0003&\t%\u0002B\u0002B\u00141\u0001\u0007A0A\u0003uC\ndW\rC\u0005\u0003,a\u0001\n\u00111\u0001\u0003\u0018\u000591-Y:dC\u0012,\u0017AG4fiR\u0013XO\\2bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0019U\u0011\u00119Ba\r,\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0010c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\u0012IDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011cZ3u\u0003\u0012$7i\u001c7v[:\fV/\u001a:z)\u001da(\u0011\nB'\u0005#BaAa\u0013\u001b\u0001\u0004a\u0018!\u0003;bE2,g*Y7f\u0011\u0019\u0011yE\u0007a\u0001y\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\tM#\u00041\u0001}\u0003!!\u0017\r^1UsB,\u0017\u0001G4fiV\u0003H-\u0019;f\u0007>dW/\u001c8UsB,\u0017+^3ssR9AP!\u0017\u0003\\\tu\u0003B\u0002B&7\u0001\u0007A\u0010\u0003\u0004\u0003Pm\u0001\r\u0001 \u0005\u0007\u0005?Z\u0002\u0019\u0001?\u0002\u00179,w\u000fR1uCRK\b/Z\u0001 O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]:+H\u000e\\1cS2LG/_)vKJLHc\u0002?\u0003f\t\u001d$\u0011\u000e\u0005\u0007\u0005\u0017b\u0002\u0019\u0001?\t\r\t=C\u00041\u0001}\u0011\u0019\u0011Y\u0007\ba\u0001o\u0006Q\u0011n\u001d(vY2\f'\r\\3\u0002\u001d\u001d,G\u000fT5nSR\u001cE.Y;tKR\u0019AP!\u001d\t\u000f\tMT\u00041\u0001\u0003v\u0005)A.[7jiB!\u0011q\u0004B<\u0013\u0011\u0011I(!\t\u0003\u000f%sG/Z4fe\u0006yq-\u001a;PM\u001a\u001cX\r^\"mCV\u001cX\rF\u0002}\u0005\u007fBqA!!\u001f\u0001\u0004\u0011)(\u0001\u0004pM\u001a\u001cX\r\u001e\u0002\u0016\u001fJ\f7\r\\3T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s'\ry\"q\u0011\t\u0004)\n%\u0015b\u0001BF\u000f\n\u0019\"\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3fe\u00069A-[1mK\u000e$\u0018aB8qi&|gn\u001d\t\u0005\u0005'\u0013y*\u0004\u0002\u0003\u0016*\u0019\u0001Ja&\u000b\t\te%1T\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0003\u001e&\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\t\u0005&Q\u0013\u0002\f\u0015\u0012\u00135i\u00149uS>t7\u000f\u0006\u0004\u0003&\n\u001d&\u0011\u0016\t\u0004\u0003+z\u0002B\u0002BGE\u0001\u00071\u000bC\u0004\u0003\u0010\n\u0002\rA!%\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0003q\facZ3u\u0015\u0012\u00147mU)M#V,'/\u001f\"vS2$WM\u001d\u000b\u0005\u0005\u000f\u0013\u0019\fC\u0004\u0003\u0010\u0012\u0002\rA!%\u0002\u001bM,\b\u000f]8siNd\u0015.\\5u+\u00059\u0018AD:vaB|'\u000f^:PM\u001a\u001cX\r^\u0001\rgV\u0004\bo\u001c:ug\"Kg\u000e^\u0001\rgV\u0004\bo\u001c:ug*{\u0017N\\\u0001\u0012G2\f7o]5gs\u0016C8-\u001a9uS>tG\u0003\u0004Bb\u0005/\u0014IN!8\u0003h\n-(C\u0002Bc\u0005\u0013\u0014yM\u0002\u0004\u0003H\u0002\u0001!1\u0019\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004O\n-\u0017b\u0001Bgc\nIA\u000b\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005#\u0014\u0019.D\u0001L\u0013\r\u0011)n\u0013\u0002\u000f'B\f'o\u001b+ie><\u0018M\u00197f\u0011\u001d\t\u0019%\u000ba\u0001\u0005\u0013DaAa7*\u0001\u0004a\u0018!C2p]\u0012LG/[8o\u0011\u001d\u0011y.\u000ba\u0001\u0005C\f\u0011#\\3tg\u0006<W\rU1sC6,G/\u001a:t!\u0015i(1\u001d?}\u0013\u0011\u0011)/a\u0002\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0003j&\u0002\r\u0001`\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0003\u0004\u0003n&\u0002\ra^\u0001\nSN\u0014VO\u001c;j[\u0016\fAaY8qs\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0013\u0011i\u0010C\u0005\u0003\u00006\n\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0002\u0011\r\r\u001d1\u0011\u0002B\u0005\u001b\t\t)\"\u0003\u0003\u0004\f\u0005U!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a^B\t\u0011%\u0011ypLA\u0001\u0002\u0004\u0011I!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u000f\u0007/A\u0011Ba@1\u0003\u0003\u0005\r!!8\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\b\u0002\r\u0015\fX/\u00197t)\r98Q\u0005\u0005\n\u0005\u007f\u001c\u0014\u0011!a\u0001\u0005\u0013\tQb\u0014:bG2,G)[1mK\u000e$\bC\u0001+6'\u0015)4QFB\u001a!\r\t7qF\u0005\u0004\u0007c\u0011'AB!osJ+g\r\u0005\u0003\u00046\rmRBAB\u001c\u0015\u0011\u0019I$!\n\u0002\u0005%|\u0017b\u00019\u00048Q\u00111\u0011F\u0001\r\u0005&s\u0015IU-`\r2{\u0015\tV\u000b\u0003\u0007\u0007z!a!\u0012\u001e\u0003\u0011\fQBQ%O\u0003JKvL\u0012'P\u0003R\u0003\u0013!\u0004\"J\u001d\u0006\u0013\u0016l\u0018#P+\ncU)\u0006\u0002\u0004N=\u00111qJ\u000f\u0002K\u0006q!)\u0013(B%f{FiT+C\u0019\u0016\u0003\u0013\u0001\u0004+J\u001b\u0016\u001bF+Q'Q?RSVCAB,\u001f\t\u0019I&H\u0001\u001c\u00045!\u0016*T#T)\u0006k\u0005k\u0018+[A\u0005iA+S'F'R\u000bU\nU0M)j+\"a!\u0019\u0010\u0005\r\rT$\u0001N\u0002\u001dQKU*R*U\u00036\u0003v\f\u0014+[A\u0005Y\u0011J\u0014+F%Z\u000bEjX-N+\t\u0019Yg\u0004\u0002\u0004nu\t\u00114\u0001\u0007J\u001dR+%KV!M?fk\u0005%A\u0006J\u001dR+%KV!M?\u0012\u001bVCAB;\u001f\t\u00199(H\u0001\u0019\u00041Ie\nV#S-\u0006cu\fR*!\u0003\u0015\t\u0007\u000f\u001d7z\u0003\u001d)h.\u00199qYf$2a^BA\u0011!\u0019\u0019\tRA\u0001\u0002\u0004!\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0012\t\u0005\u0003?\u0019Y)\u0003\u0003\u0004\u000e\u0006\u0005\"AB(cU\u0016\u001cG\u000f")
public class OracleDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(OracleDialect x$0) {
        return OracleDialect$.MODULE$.unapply(x$0);
    }

    public static OracleDialect apply() {
        return OracleDialect$.MODULE$.apply();
    }

    public static int INTERVAL_DS() {
        return OracleDialect$.MODULE$.INTERVAL_DS();
    }

    public static int INTERVAL_YM() {
        return OracleDialect$.MODULE$.INTERVAL_YM();
    }

    public static int TIMESTAMP_LTZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_LTZ();
    }

    public static int TIMESTAMP_TZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_TZ();
    }

    public static int BINARY_DOUBLE() {
        return OracleDialect$.MODULE$.BINARY_DOUBLE();
    }

    public static int BINARY_FLOAT() {
        return OracleDialect$.MODULE$.BINARY_FLOAT();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    public Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getMessage().contains("ORA-00942") || e.getMessage().contains("ORA-39165");
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        OracleSQLBuilder oracleSQLBuilder = new OracleSQLBuilder(this);
        try {
            some = new Some((Object)oracleSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int n2 = size;
                switch (n2) {
                    case 0: {
                        return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                    }
                }
                if (scale == -127L) {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
                return None$.MODULE$;
            }
            case -102: 
            case -101: {
                return new Some((Object)TimestampType$.MODULE$);
            }
            case 100: {
                return new Some((Object)FloatType$.MODULE$);
            }
            case 101: {
                return new Some((Object)DoubleType$.MODULE$);
            }
            case -103: {
                return new Some((Object)YearMonthIntervalType$.MODULE$.apply());
            }
            case -104: {
                return new Some((Object)DayTimeIntervalType$.MODULE$.apply());
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            return new Some((Object)new JdbcType("VARCHAR2(" + varcharType.length() + ")", 12));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyOracleTimestampMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH LOCAL TIME ZONE", -102));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return "'" + this.escapeSql(string) + "'";
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return "{ts '" + timestamp + "'}";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "{d '" + date + "'}";
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("HEXTORAW('", "", "')");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return "42000".equals(exception.getSQLState());
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE " + table + " CASCADE";
        }
        return "TRUNCATE TABLE " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "WHERE rownum <= " + limit;
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "WHERE rn > " + offset;
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new OracleSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public boolean supportsJoin() {
        return true;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 955: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    public OracleDialect copy() {
        return new OracleDialect();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return 959235752;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof OracleDialect && ((OracleDialect)x$1).canEqual(this);
    }

    public OracleDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNC"})));
    }

    public class OracleSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(Extract extract2) {
            block12: {
                String field = extract2.field();
                String string = field;
                switch (string == null ? 0 : string.hashCode()) {
                    case -2020697580: {
                        if ("MINUTE".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 67452: {
                        if ("DAY".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 2223588: {
                        if ("HOUR".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 2719805: {
                        if ("YEAR".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 73542240: {
                        if ("MONTH".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return super.visitExtract(field, this.build(extract2.source()));
            }
            return this.visitUnexpectedExpr((Expression)extract2);
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case 80102796: {
                    if (!"TRUNC".equals(string)) break;
                    return "TRUNC(" + inputs[0] + ", 'IW')";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer().org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitBinaryComparison(String name, Expression le, Expression re) {
            Expression lit;
            Expression lit2;
            Tuple2 tuple2 = new Tuple2((Object)le, (Object)re);
            if (tuple2 != null && (lit2 = (Expression)tuple2._1()) instanceof Literal) {
                Literal literal = (Literal)lit2;
                DataType dataType = literal.dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                    return this.compareBlob((Expression)literal, name, re);
                }
            }
            if (tuple2 != null && (lit = (Expression)tuple2._2()) instanceof Literal) {
                Literal literal = (Literal)lit;
                DataType dataType = literal.dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                    return this.compareBlob(le, name, (Expression)literal);
                }
            }
            return super.visitBinaryComparison(name, le, re);
        }

        private String compareBlob(Expression lhs, String operator, Expression rhs) {
            String l = this.inputToSQL(lhs);
            String r = this.inputToSQL(rhs);
            String string = operator;
            String string2 = "<=>";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String compare = "DBMS_LOB.COMPARE(" + l + ", " + r + ") = 0";
                return "((" + l + " IS NOT NULL AND " + r + " IS NOT NULL AND " + compare + ") OR (" + l + " IS NULL AND " + r + " IS NULL))";
            }
            return "DBMS_LOB.COMPARE(" + l + ", " + r + ") " + operator + " 0";
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer() {
            return (OracleDialect)this.$outer;
        }

        public OracleSQLBuilder(OracleDialect $outer) {
        }
    }

    public class OracleSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ OracleDialect $outer;

        @Override
        public String build() {
            String string;
            String selectStmt = "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
            if (this.limit() > 0) {
                if (this.offset() > 0) {
                    string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) WHERE rn > " + this.offset() + " AND rn <= " + (this.limit() + this.offset());
                } else {
                    String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
                    string = "SELECT tab.* FROM (" + selectStmt + ") tab " + limitClause;
                }
            } else if (this.offset() > 0) {
                String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
                string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) " + offsetClause;
            } else {
                string = selectStmt;
            }
            String finalSelectStmt = string;
            return this.options.prepareQuery() + finalSelectStmt;
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public OracleSQLQueryBuilder(OracleDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

