/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class LeaseSpecFluent<A extends LeaseSpecFluent<A>>
extends BaseFluent<A> {
    private ZonedDateTime acquireTime;
    private Map<String, Object> additionalProperties;
    private String holderIdentity;
    private Integer leaseDurationSeconds;
    private Integer leaseTransitions;
    private String preferredHolder;
    private ZonedDateTime renewTime;
    private String strategy;

    public LeaseSpecFluent() {
    }

    public LeaseSpecFluent(LeaseSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(LeaseSpec instance) {
        LeaseSpec leaseSpec = instance = instance != null ? instance : new LeaseSpec();
        if (instance != null) {
            this.withAcquireTime(instance.getAcquireTime());
            this.withHolderIdentity(instance.getHolderIdentity());
            this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
            this.withLeaseTransitions(instance.getLeaseTransitions());
            this.withPreferredHolder(instance.getPreferredHolder());
            this.withRenewTime(instance.getRenewTime());
            this.withStrategy(instance.getStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaseSpecFluent that = (LeaseSpecFluent)((Object)o);
        if (!Objects.equals(this.acquireTime, that.acquireTime)) {
            return false;
        }
        if (!Objects.equals(this.holderIdentity, that.holderIdentity)) {
            return false;
        }
        if (!Objects.equals(this.leaseDurationSeconds, that.leaseDurationSeconds)) {
            return false;
        }
        if (!Objects.equals(this.leaseTransitions, that.leaseTransitions)) {
            return false;
        }
        if (!Objects.equals(this.preferredHolder, that.preferredHolder)) {
            return false;
        }
        if (!Objects.equals(this.renewTime, that.renewTime)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public ZonedDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    public String getPreferredHolder() {
        return this.preferredHolder;
    }

    public ZonedDateTime getRenewTime() {
        return this.renewTime;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public boolean hasAcquireTime() {
        return this.acquireTime != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasHolderIdentity() {
        return this.holderIdentity != null;
    }

    public boolean hasLeaseDurationSeconds() {
        return this.leaseDurationSeconds != null;
    }

    public boolean hasLeaseTransitions() {
        return this.leaseTransitions != null;
    }

    public boolean hasPreferredHolder() {
        return this.preferredHolder != null;
    }

    public boolean hasRenewTime() {
        return this.renewTime != null;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public int hashCode() {
        return Objects.hash(this.acquireTime, this.holderIdentity, this.leaseDurationSeconds, this.leaseTransitions, this.preferredHolder, this.renewTime, this.strategy, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acquireTime != null) {
            sb.append("acquireTime:");
            sb.append(this.acquireTime);
            sb.append(",");
        }
        if (this.holderIdentity != null) {
            sb.append("holderIdentity:");
            sb.append(this.holderIdentity);
            sb.append(",");
        }
        if (this.leaseDurationSeconds != null) {
            sb.append("leaseDurationSeconds:");
            sb.append(this.leaseDurationSeconds);
            sb.append(",");
        }
        if (this.leaseTransitions != null) {
            sb.append("leaseTransitions:");
            sb.append(this.leaseTransitions);
            sb.append(",");
        }
        if (this.preferredHolder != null) {
            sb.append("preferredHolder:");
            sb.append(this.preferredHolder);
            sb.append(",");
        }
        if (this.renewTime != null) {
            sb.append("renewTime:");
            sb.append(this.renewTime);
            sb.append(",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAcquireTime(ZonedDateTime acquireTime) {
        this.acquireTime = acquireTime;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withHolderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
        return (A)((Object)this);
    }

    public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return (A)((Object)this);
    }

    public A withLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
        return (A)((Object)this);
    }

    public A withPreferredHolder(String preferredHolder) {
        this.preferredHolder = preferredHolder;
        return (A)((Object)this);
    }

    public A withRenewTime(ZonedDateTime renewTime) {
        this.renewTime = renewTime;
        return (A)((Object)this);
    }

    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)((Object)this);
    }
}

