/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.types.variant;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantBuilder;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.types.variant.VariantUtil;

public class VariantShreddingWriter {
    public static ShreddedResult castShredded(Variant v, VariantSchema schema, ShreddedResultBuilder builder) {
        VariantUtil.Type variantType = v.getType();
        ShreddedResult result = builder.createEmpty(schema);
        if (schema.topLevelMetadataIdx >= 0) {
            result.addMetadata(v.getMetadata());
        }
        if (schema.arraySchema != null && variantType == VariantUtil.Type.ARRAY) {
            VariantSchema elementSchema = schema.arraySchema;
            int size = v.arraySize();
            ShreddedResult[] array = new ShreddedResult[size];
            for (int i = 0; i < size; ++i) {
                ShreddedResult shreddedArray;
                array[i] = shreddedArray = VariantShreddingWriter.castShredded(v.getElementAtIndex(i), elementSchema, builder);
            }
            result.addArray(array);
        } else if (schema.objectSchema != null && variantType == VariantUtil.Type.OBJECT) {
            int i;
            VariantSchema.ObjectField[] objectSchema = schema.objectSchema;
            ShreddedResult[] shreddedValues = new ShreddedResult[objectSchema.length];
            VariantBuilder variantBuilder = new VariantBuilder(false);
            ArrayList<VariantBuilder.FieldEntry> fieldEntries = new ArrayList<VariantBuilder.FieldEntry>();
            int numFieldsMatched = 0;
            int start = variantBuilder.getWritePos();
            for (i = 0; i < v.objectSize(); ++i) {
                Variant.ObjectField field = v.getFieldAtIndex(i);
                Integer fieldIdx = schema.objectSchemaMap.get(field.key);
                if (fieldIdx != null) {
                    ShreddedResult shreddedField;
                    shreddedValues[fieldIdx.intValue()] = shreddedField = VariantShreddingWriter.castShredded(field.value, objectSchema[fieldIdx.intValue()].schema, builder);
                    ++numFieldsMatched;
                    continue;
                }
                int id = v.getDictionaryIdAtIndex(i);
                fieldEntries.add(new VariantBuilder.FieldEntry(field.key, id, variantBuilder.getWritePos() - start));
                variantBuilder.shallowAppendVariant(field.value);
            }
            if (numFieldsMatched < objectSchema.length) {
                for (i = 0; i < objectSchema.length; ++i) {
                    ShreddedResult emptyChild;
                    if (shreddedValues[i] != null) continue;
                    VariantSchema.ObjectField fieldSchema = objectSchema[i];
                    shreddedValues[i] = emptyChild = builder.createEmpty(fieldSchema.schema);
                    ++numFieldsMatched;
                }
            }
            if (numFieldsMatched != objectSchema.length) {
                throw VariantUtil.malformedVariant();
            }
            result.addObject(shreddedValues);
            if (variantBuilder.getWritePos() != start) {
                variantBuilder.finishWritingObject(start, fieldEntries);
                result.addVariantValue(variantBuilder.valueWithoutMetadata());
            }
        } else if (schema.scalarSchema != null) {
            VariantSchema.ScalarType scalarType = schema.scalarSchema;
            Object typedValue = VariantShreddingWriter.tryTypedShred(v, variantType, scalarType, builder);
            if (typedValue != null) {
                result.addScalar(typedValue);
            } else {
                result.addVariantValue(v.getValue());
            }
        } else {
            result.addVariantValue(v.getValue());
        }
        return result;
    }

    private static Object tryTypedShred(Variant v, VariantUtil.Type variantType, VariantSchema.ScalarType targetType, ShreddedResultBuilder builder) {
        switch (variantType) {
            case LONG: {
                if (targetType instanceof VariantSchema.IntegralType) {
                    VariantSchema.IntegralType integralType = (VariantSchema.IntegralType)targetType;
                    VariantSchema.IntegralSize size = integralType.size;
                    long value = v.getLong();
                    switch (size) {
                        case BYTE: {
                            if (value != (long)((byte)value)) break;
                            return (byte)value;
                        }
                        case SHORT: {
                            if (value != (long)((short)value)) break;
                            return (short)value;
                        }
                        case INT: {
                            if (value != (long)((int)value)) break;
                            return (int)value;
                        }
                        case LONG: {
                            return value;
                        }
                    }
                    break;
                }
                if (!(targetType instanceof VariantSchema.DecimalType)) break;
                VariantSchema.DecimalType decimalType = (VariantSchema.DecimalType)targetType;
                if (!builder.allowNumericScaleChanges()) break;
                long value = v.getLong();
                BigDecimal decimalValue = BigDecimal.valueOf(value);
                BigDecimal scaledValue = decimalValue.setScale(decimalType.scale);
                assert (decimalValue.compareTo(scaledValue) == 0);
                if (scaledValue.precision() > decimalType.precision) break;
                return scaledValue;
            }
            case DECIMAL: {
                if (targetType instanceof VariantSchema.DecimalType) {
                    BigDecimal scaledValue;
                    VariantSchema.DecimalType decimalType = (VariantSchema.DecimalType)targetType;
                    BigDecimal value = VariantUtil.getDecimalWithOriginalScale(v.value, v.pos);
                    if (value.precision() <= decimalType.precision && value.scale() == decimalType.scale) {
                        return value;
                    }
                    if (!builder.allowNumericScaleChanges() || (scaledValue = value.setScale(decimalType.scale, RoundingMode.FLOOR)).compareTo(value) != 0 || scaledValue.precision() > decimalType.precision) break;
                    return scaledValue;
                }
                if (!(targetType instanceof VariantSchema.IntegralType)) break;
                VariantSchema.IntegralType integralType = (VariantSchema.IntegralType)targetType;
                if (!builder.allowNumericScaleChanges()) break;
                BigDecimal value = v.getDecimal();
                VariantSchema.IntegralSize size = integralType.size;
                switch (size) {
                    case BYTE: {
                        if (value.compareTo(BigDecimal.valueOf(value.byteValue())) != 0) break;
                        return value.byteValue();
                    }
                    case SHORT: {
                        if (value.compareTo(BigDecimal.valueOf(value.shortValue())) != 0) break;
                        return value.shortValue();
                    }
                    case INT: {
                        if (value.compareTo(BigDecimal.valueOf(value.intValue())) != 0) break;
                        return value.intValue();
                    }
                    case LONG: {
                        if (value.compareTo(BigDecimal.valueOf(value.longValue())) != 0) break;
                        return value.longValue();
                    }
                }
                break;
            }
            case BOOLEAN: {
                if (!(targetType instanceof VariantSchema.BooleanType)) break;
                return v.getBoolean();
            }
            case STRING: {
                if (!(targetType instanceof VariantSchema.StringType)) break;
                return v.getString();
            }
            case DOUBLE: {
                if (!(targetType instanceof VariantSchema.DoubleType)) break;
                return v.getDouble();
            }
            case DATE: {
                if (!(targetType instanceof VariantSchema.DateType)) break;
                return (int)v.getLong();
            }
            case TIMESTAMP: {
                if (!(targetType instanceof VariantSchema.TimestampType)) break;
                return v.getLong();
            }
            case TIMESTAMP_NTZ: {
                if (!(targetType instanceof VariantSchema.TimestampNTZType)) break;
                return v.getLong();
            }
            case FLOAT: {
                if (!(targetType instanceof VariantSchema.FloatType)) break;
                return Float.valueOf(v.getFloat());
            }
            case BINARY: {
                if (!(targetType instanceof VariantSchema.BinaryType)) break;
                return v.getBinary();
            }
            case UUID: {
                if (!(targetType instanceof VariantSchema.UuidType)) break;
                return v.getUuid();
            }
        }
        return null;
    }

    private static void addVariantValueVariant(Variant variantResult, VariantSchema schema, ShreddedResult result) {
        result.addVariantValue(variantResult.getValue());
    }

    public static interface ShreddedResultBuilder {
        public ShreddedResult createEmpty(VariantSchema var1);

        public boolean allowNumericScaleChanges();
    }

    public static interface ShreddedResult {
        public void addArray(ShreddedResult[] var1);

        public void addObject(ShreddedResult[] var1);

        public void addVariantValue(byte[] var1);

        public void addScalar(Object var1);

        public void addMetadata(byte[] var1);
    }
}

