/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.security.SecureRandom;
import java.util.UUID;

public final class UUIDv7Generator {
    private UUIDv7Generator() {
    }

    public static UUID generate() {
        long timestamp = System.currentTimeMillis();
        long msb = timestamp << 16 | 0x7000L | (long)(Holder.SECURE_RANDOM.nextInt() & 0xFFF);
        long randB = Holder.SECURE_RANDOM.nextLong();
        long lsb = randB & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }

    private static class Holder {
        static final SecureRandom SECURE_RANDOM = new SecureRandom();

        private Holder() {
        }
    }
}

