/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.runtime;

import coursierapi.shaded.scala.math.ScalaNumber;

public final class BoxesRunTime {
    private static int typeCode(Object a) {
        if (a instanceof Integer) {
            return 3;
        }
        if (a instanceof Double) {
            return 6;
        }
        if (a instanceof Long) {
            return 4;
        }
        if (a instanceof Character) {
            return 0;
        }
        if (a instanceof Float) {
            return 5;
        }
        if (a instanceof Byte || a instanceof Short) {
            return 3;
        }
        return 7;
    }

    public static Boolean boxToBoolean(boolean b) {
        return b;
    }

    public static Character boxToCharacter(char c) {
        return Character.valueOf(c);
    }

    public static Byte boxToByte(byte b) {
        return b;
    }

    public static Short boxToShort(short s) {
        return s;
    }

    public static Integer boxToInteger(int i) {
        return i;
    }

    public static Long boxToLong(long l) {
        return l;
    }

    public static Float boxToFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double boxToDouble(double d) {
        return d;
    }

    public static boolean unboxToBoolean(Object b) {
        return b == null ? false : (Boolean)b;
    }

    public static char unboxToChar(Object c) {
        return c == null ? (char)'\u0000' : ((Character)c).charValue();
    }

    public static byte unboxToByte(Object b) {
        return b == null ? (byte)0 : (Byte)b;
    }

    public static short unboxToShort(Object s) {
        return s == null ? (short)0 : (Short)s;
    }

    public static int unboxToInt(Object i) {
        return i == null ? 0 : (Integer)i;
    }

    public static long unboxToLong(Object l) {
        return l == null ? 0L : (Long)l;
    }

    public static float unboxToFloat(Object f) {
        return f == null ? 0.0f : ((Float)f).floatValue();
    }

    public static double unboxToDouble(Object d) {
        return d == null ? 0.0 : (Double)d;
    }

    public static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        return BoxesRunTime.equals2(x, y);
    }

    public static boolean equals2(Object x, Object y) {
        if (x instanceof Number) {
            return BoxesRunTime.equalsNumObject((Number)x, y);
        }
        if (x instanceof Character) {
            return BoxesRunTime.equalsCharObject((Character)x, y);
        }
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public static boolean equalsNumObject(Number xn, Object y) {
        if (y instanceof Number) {
            return BoxesRunTime.equalsNumNum(xn, (Number)y);
        }
        if (y instanceof Character) {
            return BoxesRunTime.equalsNumChar(xn, (Character)y);
        }
        if (xn == null) {
            return y == null;
        }
        return xn.equals(y);
    }

    public static boolean equalsNumNum(Number xn, Number yn) {
        int xcode = BoxesRunTime.typeCode(xn);
        int ycode = BoxesRunTime.typeCode(yn);
        switch (ycode > xcode ? ycode : xcode) {
            case 3: {
                return xn.intValue() == yn.intValue();
            }
            case 4: {
                return xn.longValue() == yn.longValue();
            }
            case 5: {
                return xn.floatValue() == yn.floatValue();
            }
            case 6: {
                return xn.doubleValue() == yn.doubleValue();
            }
        }
        if (yn instanceof ScalaNumber && !(xn instanceof ScalaNumber)) {
            return yn.equals(xn);
        }
        if (xn == null) {
            return yn == null;
        }
        return xn.equals(yn);
    }

    public static boolean equalsCharObject(Character xc, Object y) {
        if (y instanceof Character) {
            return xc.charValue() == ((Character)y).charValue();
        }
        if (y instanceof Number) {
            return BoxesRunTime.equalsNumChar((Number)y, xc);
        }
        if (xc == null) {
            return y == null;
        }
        return xc.equals(y);
    }

    public static boolean equalsNumChar(Number xn, Character yc) {
        if (yc == null) {
            return xn == null;
        }
        char ch = yc.charValue();
        switch (BoxesRunTime.typeCode(xn)) {
            case 3: {
                return xn.intValue() == ch;
            }
            case 4: {
                return xn.longValue() == (long)ch;
            }
            case 5: {
                return xn.floatValue() == (float)ch;
            }
            case 6: {
                return xn.doubleValue() == (double)ch;
            }
        }
        return xn.equals(yc);
    }
}

