/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.Polygon;

class MultiPolygon
extends GeometryModel {
    private final List<Polygon> polygons;

    MultiPolygon(List<Polygon> polygons, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.MULTI_POLYGON, srid, hasZ, hasM);
        this.polygons = polygons;
    }

    List<Polygon> getPolygons() {
        return this.polygons;
    }

    int getNumGeometries() {
        return this.polygons.size();
    }

    @Override
    boolean isEmpty() {
        return this.polygons.isEmpty() || this.polygons.stream().allMatch(Polygon::isEmpty);
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }
}

