/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;

class GeometryCollection
extends GeometryModel {
    private final List<GeometryModel> geometries;

    GeometryCollection(List<GeometryModel> geometries, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.GEOMETRY_COLLECTION, srid, hasZ, hasM);
        this.geometries = geometries;
    }

    List<GeometryModel> getGeometries() {
        return this.geometries;
    }

    int getNumGeometries() {
        return this.geometries.size();
    }

    @Override
    boolean isEmpty() {
        return this.geometries.isEmpty() || this.geometries.stream().allMatch(GeometryModel::isEmpty);
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }
}

