/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.HybridParameterContext;
import org.apache.spark.sql.catalyst.parser.NamedParameterContext;
import org.apache.spark.sql.catalyst.parser.ParameterContext;
import org.apache.spark.sql.catalyst.parser.ParameterExpectation$;
import org.apache.spark.sql.catalyst.parser.PositionMapper;
import org.apache.spark.sql.catalyst.parser.PositionMapper$;
import org.apache.spark.sql.catalyst.parser.PositionalParameterContext;
import org.apache.spark.sql.catalyst.parser.SubstituteParamsParser;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ParameterHandler$ {
    public static final ParameterHandler$ MODULE$ = new ParameterHandler$();
    private static final Pattern parameterMarkerPattern = Pattern.compile("[?:]");

    private Pattern parameterMarkerPattern() {
        return parameterMarkerPattern;
    }

    private Tuple2<String, PositionMapper> performSubstitution(String sqlText, Map<String, String> namedParams, List<String> positionalParams) {
        if (!this.parameterMarkerPattern().matcher(sqlText).find()) {
            return new Tuple2((Object)sqlText, (Object)PositionMapper$.MODULE$.identity(sqlText));
        }
        SubstituteParamsParser substitutor = new SubstituteParamsParser();
        Tuple3<String, Object, PositionMapper> tuple3 = substitutor.substitute(sqlText, namedParams, positionalParams, substitutor.substitute$default$4(), substitutor.substitute$default$5(), substitutor.substitute$default$6(), substitutor.substitute$default$7());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String substituted = (String)tuple3._1();
        PositionMapper positionMapper = (PositionMapper)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)substituted, (Object)positionMapper);
        String substituted2 = (String)tuple2._1();
        PositionMapper positionMapper2 = (PositionMapper)tuple2._2();
        return new Tuple2((Object)substituted2, (Object)positionMapper2);
    }

    private Map<String, String> performSubstitution$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private List<String> performSubstitution$default$3() {
        return package$.MODULE$.List().empty();
    }

    public Expression org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToExpression(Object value) {
        Literal literal;
        Object object = value;
        if (object instanceof Literal) {
            Literal literal2 = (Literal)object;
            return literal2;
        }
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            return expression;
        }
        if (object == null) {
            return Literal$.MODULE$.apply(null);
        }
        try {
            literal = Literal$.MODULE$.apply(object);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot convert value of type " + object.getClass().getSimpleName() + " to Expression: " + object);
        }
        return literal;
    }

    public String org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql(Expression expr) {
        Expression expression = expr;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return literal.sql();
        }
        throw new IllegalArgumentException("ParameterHandler only accepts resolved Literal expressions. Received: " + expression.getClass().getSimpleName() + ". All parameters must be resolved using SparkSession.resolveAndValidateParameters before being passed to the pre-parser.");
    }

    public Tuple2<String, PositionMapper> substituteParameters(String sqlText, ParameterContext context) {
        Predef$.MODULE$.require(context != null, (Function0 & Serializable)() -> "Parameter context cannot be null");
        ParameterContext parameterContext = context;
        if (parameterContext instanceof NamedParameterContext) {
            NamedParameterContext namedParameterContext = (NamedParameterContext)parameterContext;
            Map<String, Expression> params = namedParameterContext.params();
            return this.performSubstitution(sqlText, (Map<String, String>)((Map)params.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Expression expr = (Expression)tuple2._2();
                    return new Tuple2((Object)name, (Object)MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql(expr));
                }
                throw new MatchError((Object)tuple2);
            })), this.performSubstitution$default$3());
        }
        if (parameterContext instanceof PositionalParameterContext) {
            PositionalParameterContext positionalParameterContext = (PositionalParameterContext)parameterContext;
            Seq<Expression> params = positionalParameterContext.params();
            String x$1 = sqlText;
            List x$2 = ((IterableOnceOps)params.map((Function1 & Serializable)expr -> MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql((Expression)expr))).toList();
            Map<String, String> x$3 = this.performSubstitution$default$2();
            return this.performSubstitution(x$1, x$3, (List<String>)x$2);
        }
        if (parameterContext instanceof HybridParameterContext) {
            HybridParameterContext hybridParameterContext = (HybridParameterContext)parameterContext;
            Seq<Expression> args = hybridParameterContext.args();
            Seq<String> paramNames = hybridParameterContext.paramNames();
            return this.handleHybridParameters(sqlText, (Seq<Object>)args.toSeq(), (Seq<String>)paramNames.toSeq());
        }
        throw new MatchError((Object)parameterContext);
    }

    private Tuple2<String, PositionMapper> handleHybridParameters(String sqlText, Seq<Object> args, Seq<String> paramNames) {
        if (!this.parameterMarkerPattern().matcher(sqlText).find()) {
            return new Tuple2((Object)sqlText, (Object)PositionMapper$.MODULE$.identity(sqlText));
        }
        List positionalParams = ((IterableOnceOps)((IterableOps)args.map((Function1 & Serializable)value -> MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToExpression(value))).map((Function1 & Serializable)expr -> MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql((Expression)expr))).toList();
        Map namedParams = ((IterableOnceOps)((IterableOps)paramNames.zip(args)).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    Object value = A1._2();
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ParameterHandler$.MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql(ParameterHandler$.MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToExpression(value)));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                String name;
                Tuple2<String, Object> tuple2 = x1;
                return tuple2 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name = (String)tuple2._1()));
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean hasOnlyNamedParams = !paramNames.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()));
        SubstituteParamsParser substitutor = new SubstituteParamsParser();
        Tuple3<String, Object, PositionMapper> tuple3 = substitutor.substitute(sqlText, (Map<String, String>)namedParams, (List<String>)positionalParams, ParameterExpectation$.MODULE$.Unknown(), hasOnlyNamedParams, args, paramNames);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String substitutedSql = (String)tuple3._1();
        PositionMapper positionMapper = (PositionMapper)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)substitutedSql, (Object)positionMapper);
        String substitutedSql2 = (String)tuple2._1();
        PositionMapper positionMapper2 = (PositionMapper)tuple2._2();
        return new Tuple2((Object)substitutedSql2, (Object)positionMapper2);
    }

    public Tuple2<String, PositionMapper> substituteNamedParameters(String sqlText, Map<String, Expression> paramMap) {
        if (paramMap.isEmpty()) {
            return new Tuple2((Object)sqlText, (Object)PositionMapper$.MODULE$.identity(sqlText));
        }
        SubstituteParamsParser substitutor = new SubstituteParamsParser();
        Map namedParams = (Map)paramMap.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return new Tuple2((Object)name, (Object)MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql(expr));
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple3<String, Object, PositionMapper> tuple3 = substitutor.substitute(sqlText, (Map<String, String>)namedParams, (List<String>)package$.MODULE$.List().empty(), ParameterExpectation$.MODULE$.Named(), substitutor.substitute$default$5(), substitutor.substitute$default$6(), substitutor.substitute$default$7());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String substitutedSql = (String)tuple3._1();
        PositionMapper positionMapper = (PositionMapper)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)substitutedSql, (Object)positionMapper);
        String substitutedSql2 = (String)tuple2._1();
        PositionMapper positionMapper2 = (PositionMapper)tuple2._2();
        return new Tuple2((Object)substitutedSql2, (Object)positionMapper2);
    }

    public Tuple2<String, PositionMapper> substitutePositionalParameters(String sqlText, Seq<Expression> paramList) {
        if (paramList.isEmpty()) {
            return new Tuple2((Object)sqlText, (Object)PositionMapper$.MODULE$.identity(sqlText));
        }
        List positionalParams = ((IterableOnceOps)paramList.map((Function1 & Serializable)expr -> MODULE$.org$apache$spark$sql$catalyst$parser$ParameterHandler$$convertToSql((Expression)expr))).toList();
        SubstituteParamsParser substitutor = new SubstituteParamsParser();
        Tuple3<String, Object, PositionMapper> tuple3 = substitutor.substitute(sqlText, (Map<String, String>)Predef$.MODULE$.Map().empty(), (List<String>)positionalParams, ParameterExpectation$.MODULE$.Positional(), substitutor.substitute$default$5(), substitutor.substitute$default$6(), substitutor.substitute$default$7());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String substitutedSql = (String)tuple3._1();
        PositionMapper positionMapper = (PositionMapper)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)substitutedSql, (Object)positionMapper);
        String substitutedSql2 = (String)tuple2._1();
        PositionMapper positionMapper2 = (PositionMapper)tuple2._2();
        return new Tuple2((Object)substitutedSql2, (Object)positionMapper2);
    }

    private ParameterHandler$() {
    }
}

