/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a list of non-unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2,1]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001B\u00181\u0001~B\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\t[\u0002\u0011\t\u0012)A\u00051\"Aa\u000e\u0001BK\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\tE\t\u0015!\u0003q\u0011!!\bA!f\u0001\n\u0003y\u0007\u0002C;\u0001\u0005#\u0005\u000b\u0011\u00029\t\u0011Y\u0004!Q3A\u0005\u0002]D\u0001b\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006y\u0002!\t! \u0005\u0007y\u0002!\t!a\u0002\t\r\u0005-\u0001\u0001\"\u0015x\u0011)\ti\u0001\u0001EC\u0002\u0013\u0005\u0013q\u0002\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t\t\b\u0001C)\u0003gB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t\u0019\u000bAI\u0001\n\u0003\ty\nC\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002(\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\t\u0003{\u0003\u0011\u0011!C\u0001_\"I\u0011q\u0018\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u000f\u0004\u0011\u0011!C!\u0003\u0013D\u0011\"a5\u0001\u0003\u0003%\t!!6\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u000f%\u0011Y\u0001MA\u0001\u0012\u0003\u0011iA\u0002\u00050a\u0005\u0005\t\u0012\u0001B\b\u0011\u0019a8\u0005\"\u0001\u0003(!I\u0011QN\u0012\u0002\u0002\u0013\u0015#\u0011\u0006\u0005\n\u0005W\u0019\u0013\u0011!CA\u0005[A\u0011Ba\u000e$#\u0003%\t!a(\t\u0013\te2%%A\u0005\u0002\u0005}\u0005\"\u0003B\u001eGE\u0005I\u0011AAT\u0011%\u0011idIA\u0001\n\u0003\u0013y\u0004C\u0005\u0003R\r\n\n\u0011\"\u0001\u0002 \"I!1K\u0012\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0005+\u001a\u0013\u0013!C\u0001\u0003OC\u0011Ba\u0016$\u0003\u0003%IA!\u0017\u0003\u0017\r{G\u000e\\3di2K7\u000f\u001e\u0006\u0003cI\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005M\"\u0014aC3yaJ,7o]5p]NT!!\u000e\u001c\u0002\u0011\r\fG/\u00197zgRT!a\u000e\u001d\u0002\u0007M\fHN\u0003\u0002:u\u0005)1\u000f]1sW*\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001!S9~\u00032!\u0011\"E\u001b\u0005\u0001\u0014BA\"1\u0005\u001d\u0019u\u000e\u001c7fGR\u00042!\u0012'O\u001b\u00051%BA$I\u0003\u001diW\u000f^1cY\u0016T!!\u0013&\u0002\u0015\r|G\u000e\\3di&|gNC\u0001L\u0003\u0015\u00198-\u00197b\u0013\tieIA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA(Q\u001b\u0005Q\u0015BA)K\u0005\r\te.\u001f\t\u0004'ZCV\"\u0001+\u000b\u0005U#\u0014!\u0002;sK\u0016\u001c\u0018BA,U\u0005%)f.\u0019:z\u0019&\\W\r\u0005\u0002Z56\t!'\u0003\u0002\\e\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=k\u0016B\u00010K\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00195\u000f\u0005\u00054gB\u00012f\u001b\u0005\u0019'B\u00013?\u0003\u0019a$o\\8u}%\t1*\u0003\u0002h\u0015\u00069\u0001/Y2lC\u001e,\u0017BA5k\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t9'*A\u0003dQ&dG-F\u0001Y\u0003\u0019\u0019\u0007.\u001b7eA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001q!\ty\u0015/\u0003\u0002s\u0015\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\u0017%<gn\u001c:f\u001dVdGn]\u000b\u0002qB\u0011q*_\u0005\u0003u*\u0013qAQ8pY\u0016\fg.\u0001\u0007jO:|'/\u001a(vY2\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\t}~\f\t!a\u0001\u0002\u0006A\u0011\u0011\t\u0001\u0005\u0006W&\u0001\r\u0001\u0017\u0005\b]&\u0001\n\u00111\u0001q\u0011\u001d!\u0018\u0002%AA\u0002ADqA^\u0005\u0011\u0002\u0003\u0007\u0001\u0010F\u0002\u007f\u0003\u0013AQa\u001b\u0006A\u0002a\u000b!CY;gM\u0016\u00148i\u001c8uC&t7OT;mY\u0006\t\"-\u001e4gKJ,E.Z7f]R$\u0016\u0010]3\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]a'A\u0003usB,7/\u0003\u0003\u0002\u001c\u0005U!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002-\r|gN^3siR{')\u001e4gKJ,E.Z7f]R$2ATA\u0011\u0011\u0019\t\u0019#\u0004a\u0001\u001d\u0006)a/\u00197vK\u00061Q\u000f\u001d3bi\u0016$R\u0001RA\u0015\u0003[Aa!a\u000b\u000f\u0001\u0004!\u0015A\u00022vM\u001a,'\u000fC\u0004\u000209\u0001\r!!\r\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005M\u0012QG\u0007\u0002i%\u0019\u0011q\u0007\u001b\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011QHA\"!\r\t\u0015qH\u0005\u0004\u0003\u0003\u0002$aE%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007BBA#\u001f\u0001\u0007\u0001/A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002>\u0005-\u0003BBA'!\u0001\u0007\u0001/A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002\t\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005]\u0003\u0003BA-\u0003CrA!a\u0017\u0002^A\u0011!MS\u0005\u0004\u0003?R\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`)\u000bA!\u001a<bYR\u0019a*a\u001b\t\r\u0005-2\u00031\u0001E\u0003!!xn\u0015;sS:<GCAA,\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019a0!\u001e\t\r\u0005]T\u00031\u0001Y\u0003!qWm^\"iS2$\u0017\u0001B2paf$\u0012B`A?\u0003\u007f\n\t)a!\t\u000f-4\u0002\u0013!a\u00011\"9aN\u0006I\u0001\u0002\u0004\u0001\bb\u0002;\u0017!\u0003\u0005\r\u0001\u001d\u0005\bmZ\u0001\n\u00111\u0001y\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!#+\u0007a\u000bYi\u000b\u0002\u0002\u000eB!\u0011qRAM\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015!C;oG\",7m[3e\u0015\r\t9JS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAN\u0003#\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!)+\u0007A\fY)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0016\u0016\u0004q\u0006-\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00020B!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016\u0001\u00027b]\u001eT!!!/\u0002\t)\fg/Y\u0005\u0005\u0003G\n\u0019,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u00079\u000b\u0019\r\u0003\u0005\u0002Fv\t\t\u00111\u0001q\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u001a\t\u0006\u0003\u001b\fyMT\u0007\u0002\u0011&\u0019\u0011\u0011\u001b%\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004q\u0006]\u0007\u0002CAc?\u0005\u0005\t\u0019\u0001(\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003_\u000bi\u000e\u0003\u0005\u0002F\u0002\n\t\u00111\u0001q\u0003\u0019)\u0017/^1mgR\u0019\u00010a9\t\u0011\u0005\u0015\u0017%!AA\u00029Cs\u0003AAt\u0003[\fy/a=\u0002v\u0006e\u00181`A\u0000\u0005\u0003\u0011)Aa\u0002\u0011\u0007e\u000bI/C\u0002\u0002lJ\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002r\u0006\u0011uLR+O\u0007~CS\r\u001f9sS\u0001j\u0003eQ8mY\u0016\u001cGo\u001d\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u0019\u0011mSN$\be\u001c4!]>tW&\u001e8jcV,\u0007%\u001a7f[\u0016tGo\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a>\u0002E*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001B\u0013'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIb\u0013'\u0018\u0006!A\u0005!an\u001c;fC\t\ti0AA&\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007EY3dCV\u001cX\r\t;iK\u0002z'\u000fZ3sA=4\u0007eY8mY\u0016\u001cG/\u001a3!e\u0016\u001cX\u000f\u001c;tA\u0011,\u0007/\u001a8eg*\u0001\u0003\u0005\t\u0011p]\u0002\"\b.\u001a\u0011pe\u0012,'\u000fI8gAQDW\r\t:poN\u0004s\u000f[5dQ\u0002j\u0017-\u001f\u0011cK\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0011bMR,'\u000fI1!g\",hM\u001a7f])\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003\u0004\u0005I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0013\tQA\r\u00181]A\n1bQ8mY\u0016\u001cG\u000fT5tiB\u0011\u0011iI\n\u0006G\tE!Q\u0004\t\n\u0005'\u0011I\u0002\u00179qqzl!A!\u0006\u000b\u0007\t]!*A\u0004sk:$\u0018.\\3\n\t\tm!Q\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\t\t\r\u0012qW\u0001\u0003S>L1!\u001bB\u0011)\t\u0011i\u0001\u0006\u0002\u00020\u0006)\u0011\r\u001d9msRIaPa\f\u00032\tM\"Q\u0007\u0005\u0006W\u001a\u0002\r\u0001\u0017\u0005\b]\u001a\u0002\n\u00111\u0001q\u0011\u001d!h\u0005%AA\u0002ADqA\u001e\u0014\u0011\u0002\u0003\u0007\u00010A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\tB'!\u0015y%1\tB$\u0013\r\u0011)E\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f=\u0013I\u0005\u00179qq&\u0019!1\n&\u0003\rQ+\b\u000f\\35\u0011!\u0011yEKA\u0001\u0002\u0004q\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\\A!\u0011\u0011\u0017B/\u0013\u0011\u0011y&a-\u0003\r=\u0013'.Z2u\u0001")
public class CollectList
extends Collect<ArrayBuffer<Object>>
implements UnaryLike<Expression>,
Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final boolean ignoreNulls;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$4() {
        return CollectList$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return CollectList$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(CollectList x$0) {
        return CollectList$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return CollectList$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return CollectList$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectList$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple4<Expression, Object, Object, Object>, CollectList> tupled() {
        return CollectList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, Function1<Object, CollectList>>>> curried() {
        return CollectList$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public boolean bufferContainsNull() {
        return !this.ignoreNulls();
    }

    private DataType bufferElementType$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$0) {
                this.bufferElementType = this.child().dataType();
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public ArrayBuffer<Object> update(ArrayBuffer<Object> buffer, InternalRow input) {
        Object value = this.child().eval(input);
        Object object = value != null ? buffer.$plus$eq(this.convertToBufferElement(value)) : (!this.ignoreNulls() ? buffer.$plus$eq(null) : BoxedUnit.UNIT);
        return buffer;
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$1, x$3, x$4);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ArrayBuffer<Object> createAggregationBuffer() {
        return ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public String prettyName() {
        return "collect_list";
    }

    @Override
    public Object eval(ArrayBuffer<Object> buffer) {
        return new GenericArrayData((Object[])buffer.toArray(ClassTag$.MODULE$.Any()));
    }

    @Override
    public String toString() {
        String ignoreNullsStr = this.ignoreNulls() ? "" : " respect nulls";
        return this.prettyName() + "(" + this.child() + ")" + ignoreNullsStr;
    }

    @Override
    public CollectList withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public CollectList copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset, boolean ignoreNulls) {
        return new CollectList(child, mutableAggBufferOffset, inputAggBufferOffset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    public boolean copy$default$4() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "CollectList";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectList;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
            case 3: {
                return "ignoreNulls";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectList)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectList collectList = (CollectList)x$1;
        if (this.mutableAggBufferOffset() != collectList.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectList.inputAggBufferOffset()) return false;
        if (this.ignoreNulls() != collectList.ignoreNulls()) return false;
        Expression expression = this.child();
        Expression expression2 = collectList.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectList.canEqual(this)) return false;
        return true;
    }

    public CollectList(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset, boolean ignoreNulls) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.ignoreNulls = ignoreNulls;
        UnaryLike.$init$(this);
    }

    public CollectList(Expression child) {
        this(child, 0, 0, true);
    }
}

