/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TupleIntersectionBase;
import org.apache.spark.sql.catalyst.expressions.TupleIntersectionInteger$;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(tupleSketch1, tupleSketch2, mode) - Intersects two binary representations of Datasketches\n    TupleSketch objects with integer summary data type using a TupleSketch Intersection object.\n    Users can set mode to 'sum', 'min', 'max', or 'alwaysone' (defaults to 'sum'). ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_integer(_FUNC_(tuple_sketch_agg_integer(col1, val1), tuple_sketch_agg_integer(col2, val2))) FROM VALUES (1, 1, 1, 4), (2, 2, 2, 5), (3, 3, 4, 6) tab(col1, val1, col2, val2);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u0010!\u00016B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000ba\u0003A\u0011\u00010\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bM\u0004A\u0011\u000b;\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003k\u0001\u0011\u0013!C\u0001\u0003oA\u0011\"!\u0014\u0001#\u0003%\t!a\u000e\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005]\u0002\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u0017\u0003\u0011\u0011!C\u0001\u0003\u001bC\u0011\"a&\u0001\u0003\u0003%\t%!'\t\u0013\u0005u\u0005!!A\u0005B\u0005}u!CAbA\u0005\u0005\t\u0012AAc\r!y\u0002%!A\t\u0002\u0005\u001d\u0007B\u0002-\u001a\t\u0003\ty\u000eC\u0005\u0002bf\t\t\u0011\"\u0012\u0002d\"I\u0011Q]\r\u0002\u0002\u0013\u0005\u0015q\u001d\u0005\n\u0003_L\u0012\u0011!CA\u0003cD\u0011Ba\u0001\u001a\u0003\u0003%IA!\u0002\u00031Q+\b\u000f\\3J]R,'o]3di&|g.\u00138uK\u001e,'O\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0006\u0010\"\u0011\u0007=\u0002$'D\u0001!\u0013\t\t\u0004EA\u000bUkBdW-\u00138uKJ\u001cXm\u0019;j_:\u0014\u0015m]3\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014!C1oS:$XmZ3s\u0015\t9\u0004(A\u0003ukBdWM\u0003\u0002:Q\u0005aA-\u0019;bg.,Go\u00195fg&\u00111\b\u000e\u0002\u000f\u0013:$XmZ3s'VlW.\u0019:z!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$-\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe(A\u0003gSJ\u001cH/F\u0001Q!\ty\u0013+\u0003\u0002SA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\u0019L'o\u001d;!\u0003\u0019\u0019XmY8oI\u000691/Z2p]\u0012\u0004\u0013!\u0002;iSJ$\u0017A\u0002;iSJ$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00055ncV\f\u0005\u00020\u0001!)aj\u0002a\u0001!\")Ak\u0002a\u0001!\")ak\u0002a\u0001!R\u0019!l\u00181\t\u000b9C\u0001\u0019\u0001)\t\u000bQC\u0001\u0019\u0001)\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG\u0003\u0002.dK\u001eDQ\u0001Z\u0005A\u0002A\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0006M&\u0001\r\u0001U\u0001\n]\u0016<8+Z2p]\u0012DQ\u0001[\u0005A\u0002A\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u000baJ,G\u000f^=OC6,W#A6\u0011\u00051\u0004hBA7o!\t)e(\u0003\u0002p}\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyg(\u0001\u000ede\u0016\fG/Z*v[6\f'/_*fi>\u0003XM]1uS>t7\u000f\u0006\u0002vsB\u0019ao\u001e\u001a\u000e\u0003YJ!\u0001\u001f\u001c\u0003)M+X.\\1ssN+Go\u00149fe\u0006$\u0018n\u001c8t\u0011\u0015Q8\u00021\u0001|\u0003\u0011iw\u000eZ3\u0011\u0005q|X\"A?\u000b\u0005y\u0014\u0013\u0001B;uS2L1!!\u0001~\u0005A!V\u000f\u001d7f'VlW.\u0019:z\u001b>$W-A\tj]R,'o]3diN[W\r^2iKN$\u0002\"a\u0002\u0002\u000e\u0005u\u0011\u0011\u0005\t\u0004{\u0005%\u0011bAA\u0006}\t!QK\\5u\u0011\u001d\ty\u0001\u0004a\u0001\u0003#\tAb]6fi\u000eD\u0017GQ=uKN\u0004R!PA\n\u0003/I1!!\u0006?\u0005\u0015\t%O]1z!\ri\u0014\u0011D\u0005\u0004\u00037q$\u0001\u0002\"zi\u0016Dq!a\b\r\u0001\u0004\t\t\"\u0001\u0007tW\u0016$8\r\u001b\u001aCsR,7\u000fC\u0004\u0002$1\u0001\r!!\n\u0002\u0019%tG/\u001a:tK\u000e$\u0018n\u001c8\u0011\tY\f9CM\u0005\u0004\u0003S1$\u0001D%oi\u0016\u00148/Z2uS>t\u0017\u0001B2paf$rAWA\u0018\u0003c\t\u0019\u0004C\u0004O\u001bA\u0005\t\u0019\u0001)\t\u000fQk\u0001\u0013!a\u0001!\"9a+\u0004I\u0001\u0002\u0004\u0001\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sQ3\u0001UA\u001eW\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA$}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0013\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006L1!]A-\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0007E\u0002>\u0003SJ1!a\u001b?\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t(a\u001e\u0011\u0007u\n\u0019(C\u0002\u0002vy\u00121!\u00118z\u0011%\tIhEA\u0001\u0002\u0004\t9'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0002b!!!\u0002\b\u0006ETBAAB\u0015\r\t)IP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAE\u0003\u0007\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qRAK!\ri\u0014\u0011S\u0005\u0004\u0003's$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003s*\u0012\u0011!a\u0001\u0003c\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QKAN\u0011%\tIHFA\u0001\u0002\u0004\t9'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001f\u000b\t\u000bC\u0005\u0002z]\t\t\u00111\u0001\u0002r!\u001a\u0002!!*\u0002,\u00065\u0016\u0011WAZ\u0003o\u000bI,!0\u0002@B\u0019q&a*\n\u0007\u0005%\u0006EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005=\u0016Aa\r\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006^;qY\u0016\u001c6.\u001a;dQFb\u0003\u0005^;qY\u0016\u001c6.\u001a;dQJb\u0003%\\8eK&\u0002S\u0006I%oi\u0016\u00148/Z2ug\u0002\"xo\u001c\u0011cS:\f'/\u001f\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8tA=4\u0007\u0005R1uCN\\W\r^2iKNT\u0001\u0005\t\u0011!)V\u0004H.Z*lKR\u001c\u0007\u000eI8cU\u0016\u001cGo\u001d\u0011xSRD\u0007%\u001b8uK\u001e,'\u000fI:v[6\f'/\u001f\u0011eCR\f\u0007\u0005^=qK\u0002*8/\u001b8hA\u0005\u0004C+\u001e9mKN[W\r^2iA%sG/\u001a:tK\u000e$\u0018n\u001c8!_\nTWm\u0019;/\u0015\u0001\u0002\u0003\u0005I+tKJ\u001c\beY1oAM,G\u000fI7pI\u0016\u0004Co\u001c\u0011(gVlw\u0005\f\u0011([&tw\u0005\f\u0011([\u0006Dx\u0005\f\u0011pe\u0002:\u0013\r\\<bsN|g.Z\u0014!Q\u0011,g-Y;miN\u0004Co\u001c\u0011(gVlw%\u000b\u0018!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA[\u0003\u0005}'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;va2,wl]6fi\u000eDw,Z:uS6\fG/Z0j]R,w-\u001a:)?\u001a+fjQ0)iV\u0004H.Z0tW\u0016$8\r[0bO\u001e|\u0016N\u001c;fO\u0016\u0014\bfY8mc1\u0002c/\u001972S1\u0002C/\u001e9mK~\u001b8.\u001a;dQ~\u000bwmZ0j]R,w-\u001a:)G>d'\u0007\f\u0011wC2\u0014\u0014&K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152Y\u0001\nD\u0006I\u0019-AQJC\u0006\t\u00153Y\u0001\u0012D\u0006\t\u001a-AUJC\u0006\t\u00154Y\u0001\u001aD\u0006\t\u001b-AYJ\u0003\u0005^1cQ\r|G.\r\u0017!m\u0006d\u0017\u0007\f\u0011d_2\u0014D\u0006\t<bYJJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a/a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002<\u0006a1o[3uG\"|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011Y\u0001\u0006i9\u0012d\u0006M\u0001\u0019)V\u0004H.Z%oi\u0016\u00148/Z2uS>t\u0017J\u001c;fO\u0016\u0014\bCA\u0018\u001a'\u0015I\u0012\u0011ZAk!!\tY-!5Q!BSVBAAg\u0015\r\tyMP\u0001\beVtG/[7f\u0013\u0011\t\u0019.!4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002X\u0006uWBAAm\u0015\u0011\tY.!\u0018\u0002\u0005%|\u0017b\u0001'\u0002ZR\u0011\u0011QY\u0001\ti>\u001cFO]5oOR\u0011\u0011QK\u0001\u0006CB\u0004H.\u001f\u000b\b5\u0006%\u00181^Aw\u0011\u0015qE\u00041\u0001Q\u0011\u0015!F\u00041\u0001Q\u0011\u00151F\u00041\u0001Q\u0003\u001d)h.\u00199qYf$B!a=\u0002\u0000B)Q(!>\u0002z&\u0019\u0011q\u001f \u0003\r=\u0003H/[8o!\u0019i\u00141 )Q!&\u0019\u0011Q  \u0003\rQ+\b\u000f\\34\u0011!\u0011\t!HA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0001\t\u0005\u0003/\u0012I!\u0003\u0003\u0003\f\u0005e#AB(cU\u0016\u001cG\u000f")
public class TupleIntersectionInteger
extends TupleIntersectionBase<IntegerSummary>
implements Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(TupleIntersectionInteger x$0) {
        return TupleIntersectionInteger$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, TupleIntersectionInteger> tupled() {
        return TupleIntersectionInteger$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, TupleIntersectionInteger>>> curried() {
        return TupleIntersectionInteger$.MODULE$.curried();
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    @Override
    public TupleIntersectionInteger withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "tuple_intersection_integer";
    }

    @Override
    public SummarySetOperations<IntegerSummary> createSummarySetOperations(TupleSummaryMode mode) {
        IntegerSummary.Mode integerMode = mode.toIntegerSummaryMode();
        return new IntegerSummarySetOperations(integerMode, integerMode);
    }

    @Override
    public void intersectSketches(byte[] sketch1Bytes, byte[] sketch2Bytes, Intersection<IntegerSummary> intersection) {
        Sketch<IntegerSummary> tupleSketch1 = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(sketch1Bytes, this.prettyName());
        Sketch<IntegerSummary> tupleSketch2 = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(sketch2Bytes, this.prettyName());
        intersection.intersect(tupleSketch1);
        intersection.intersect(tupleSketch2);
    }

    public TupleIntersectionInteger copy(Expression first, Expression second, Expression third) {
        return new TupleIntersectionInteger(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "TupleIntersectionInteger";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
            case 2: {
                return this.third();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleIntersectionInteger;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleIntersectionInteger)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleIntersectionInteger tupleIntersectionInteger = (TupleIntersectionInteger)x$1;
        Expression expression = this.first();
        Expression expression2 = tupleIntersectionInteger.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = tupleIntersectionInteger.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = tupleIntersectionInteger.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!tupleIntersectionInteger.canEqual(this)) return false;
        return true;
    }

    public TupleIntersectionInteger(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public TupleIntersectionInteger(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()));
    }
}

