/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchMergeBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchMergeBigint$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Merges two sketch buffers together into one.\n  ", examples="\n    Examples:\n      > SELECT LENGTH(kll_sketch_to_string_bigint(_FUNC_(kll_sketch_agg_bigint(col), kll_sketch_agg_bigint(col)))) > 0 FROM VALUES (1), (2), (3), (4), (5) tab(col);\n       true\n  ", group="sketch_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u001d\u0019\u0007!!A\u0005\u0002\u0011Dqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001\u000eC\u0004t\u0001E\u0005I\u0011\u00015\t\u000fQ\u0004\u0011\u0011!C!k\"9Q\u0010AA\u0001\n\u0003q\b\"CA\u0003\u0001\u0005\u0005I\u0011AA\u0004\u0011%\ti\u0001AA\u0001\n\u0003\ny\u0001C\u0005\u0002\u001e\u0001\t\t\u0011\"\u0001\u0002 !I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00131\u0006\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003c9\u0011\"!\u0016\u001c\u0003\u0003E\t!a\u0016\u0007\u0011iY\u0012\u0011!E\u0001\u00033Baa\u0012\u000b\u0005\u0002\u0005E\u0004\"CA:)\u0005\u0005IQIA;\u0011%\t9\bFA\u0001\n\u0003\u000bI\bC\u0005\u0002\u0000Q\t\t\u0011\"!\u0002\u0002\"I\u00111\u0013\u000b\u0002\u0002\u0013%\u0011Q\u0013\u0002\u0015\u00172d7k[3uG\"lUM]4f\u0005&<\u0017N\u001c;\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0015.gA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0013\u00172d7k[3uG\"lUM]4f\u0005\u0006\u001cX\r\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0004Qe>$Wo\u0019;\u0011\u0005QbdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAt%\u0001\u0004=e>|GOP\u0005\u0002a%\u00111hL\u0001\ba\u0006\u001c7.Y4f\u0013\tidH\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002<_\u0005!A.\u001a4u+\u0005\t\u0005C\u0001\u0016C\u0013\t\u00195D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002J\u0015.\u0003\"A\u000b\u0001\t\u000b}*\u0001\u0019A!\t\u000b\u0015+\u0001\u0019A!\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA!O!\")qJ\u0002a\u0001\u0003\u00069a.Z<MK\u001a$\b\"B)\u0007\u0001\u0004\t\u0015\u0001\u00038foJKw\r\u001b;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001U!\t)\u0016L\u0004\u0002W/B\u0011agL\u0005\u00031>\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001lL\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004=\u0006\u0014\u0007C\u0001\u0018`\u0013\t\u0001wFA\u0002B]fDQa\u0010\u0005A\u0002yCQ!\u0012\u0005A\u0002y\u000bAaY8qsR\u0019\u0011*\u001a4\t\u000f}J\u0001\u0013!a\u0001\u0003\"9Q)\u0003I\u0001\u0002\u0004\t\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002S*\u0012\u0011I[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001]\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fA\u0001\\1oO*\t10\u0001\u0003kCZ\f\u0017B\u0001.y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005y\bc\u0001\u0018\u0002\u0002%\u0019\u00111A\u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007y\u000bI\u0001\u0003\u0005\u0002\f9\t\t\u00111\u0001\u0000\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0003\t\u0006\u0003'\tIBX\u0007\u0003\u0003+Q1!a\u00060\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0011\u0003O\u00012ALA\u0012\u0013\r\t)c\f\u0002\b\u0005>|G.Z1o\u0011!\tY\u0001EA\u0001\u0002\u0004q\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2A^A\u0017\u0011!\tY!EA\u0001\u0002\u0004y\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\"\u0005M\u0002\u0002CA\u0006%\u0005\u0005\t\u0019\u00010)'\u0001\t9$!\u0010\u0002@\u0005\r\u0013QIA%\u0003\u0017\ny%!\u0015\u0011\u0007)\nI$C\u0002\u0002<m\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002B\u0005Q%\u0002\t\u0011!A}3UKT\"`Q1,g\r\u001e\u0017!e&<\u0007\u000e^\u0015![\u0001jUM]4fg\u0002\"xo\u001c\u0011tW\u0016$8\r\u001b\u0011ck\u001a4WM]:!i><W\r\u001e5fe\u0002Jg\u000e^8!_:,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA$\u0003\u0005\u0015%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t'F\u001d\u001e#\u0006\nK6mY~\u001b8.\u001a;dQ~#xnX:ue&twm\u00182jO&tG\u000fK0G+:\u001bu\fK6mY~\u001b8.\u001a;dQ~\u000bwmZ0cS\u001eLg\u000e\u001e\u0015d_2LC\u0006I6mY~\u001b8.\u001a;dQ~\u000bwmZ0cS\u001eLg\u000e\u001e\u0015d_2L\u0013&K\u0015!}\u0001\u0002\u0004E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00154S1\u0002\u0003\u0006N\u0015-A!*\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)qM]8va\u0006\u0012\u0011QJ\u0001\rg.,Go\u00195`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003'\nQ\u0001\u000e\u00182]A\nAc\u00137m'.,Go\u00195NKJ<WMQ5hS:$\bC\u0001\u0016\u0015'\u0015!\u00121LA4!\u001d\ti&a\u0019B\u0003&k!!a\u0018\u000b\u0007\u0005\u0005t&A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0014q\f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055$0\u0001\u0002j_&\u0019Q(a\u001b\u0015\u0005\u0005]\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003Y\fQ!\u00199qYf$R!SA>\u0003{BQaP\fA\u0002\u0005CQ!R\fA\u0002\u0005\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0004\u0006=\u0005#\u0002\u0018\u0002\u0006\u0006%\u0015bAAD_\t1q\n\u001d;j_:\u0004RALAF\u0003\u0006K1!!$0\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0013\r\u0002\u0002\u0003\u0007\u0011*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a&\u0011\u0007]\fI*C\u0002\u0002\u001cb\u0014aa\u00142kK\u000e$\b")
public class KllSketchMergeBigint
extends KllSketchMergeBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchMergeBigint x$0) {
        return KllSketchMergeBigint$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchMergeBigint> tupled() {
        return KllSketchMergeBigint$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchMergeBigint>> curried() {
        return KllSketchMergeBigint$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_merge_bigint";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        byte[] byArray;
        try {
            byte[] leftBuffer = (byte[])left;
            byte[] rightBuffer = (byte[])right;
            KllLongsSketch leftSketch = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])leftBuffer));
            KllLongsSketch rightSketch = KllLongsSketch.wrap((Memory)Memory.wrap((byte[])rightBuffer));
            leftSketch.merge((KllSketch)rightSketch);
            byArray = leftSketch.toByteArray();
        }
        catch (Exception exception) {
            throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
        }
        return byArray;
    }

    public KllSketchMergeBigint copy(Expression left, Expression right) {
        return new KllSketchMergeBigint(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchMergeBigint";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchMergeBigint;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchMergeBigint)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchMergeBigint kllSketchMergeBigint = (KllSketchMergeBigint)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchMergeBigint.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchMergeBigint.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchMergeBigint.canEqual(this)) return false;
        return true;
    }

    public KllSketchMergeBigint(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

