/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta2.Device;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceAttribute;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCapacity;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumption;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumptionBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumptionFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaint;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaintBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceFluent<A extends DeviceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean allNodes;
    private Boolean allowMultipleAllocations;
    private Map<String, DeviceAttribute> attributes;
    private List<String> bindingConditions = new ArrayList<String>();
    private List<String> bindingFailureConditions = new ArrayList<String>();
    private Boolean bindsToNode;
    private Map<String, DeviceCapacity> capacity;
    private ArrayList<DeviceCounterConsumptionBuilder> consumesCounters = new ArrayList();
    private String name;
    private String nodeName;
    private NodeSelector nodeSelector;
    private ArrayList<DeviceTaintBuilder> taints = new ArrayList();

    public DeviceFluent() {
    }

    public DeviceFluent(Device instance) {
        this.copyInstance(instance);
    }

    public A addAllToBindingConditions(Collection<String> items) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBindingFailureConditions(Collection<String> items) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingFailureConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConsumesCounters(Collection<DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTaints(Collection<DeviceTaint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        }
        return (A)((Object)this);
    }

    public ConsumesCountersNested<A> addNewConsumesCounter() {
        return new ConsumesCountersNested(-1, null);
    }

    public ConsumesCountersNested<A> addNewConsumesCounterLike(DeviceCounterConsumption item) {
        return new ConsumesCountersNested(-1, item);
    }

    public TaintsNested<A> addNewTaint() {
        return new TaintsNested(-1, null);
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new DeviceTaint(effect, key, timeAdded, value));
    }

    public TaintsNested<A> addNewTaintLike(DeviceTaint item) {
        return new TaintsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAttributes(Map<String, DeviceAttribute> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<String, DeviceAttribute>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAttributes(String key, DeviceAttribute value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<String, DeviceAttribute>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBindingConditions(String ... items) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToBindingConditions(int index, String item) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToBindingFailureConditions(String ... items) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingFailureConditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToBindingFailureConditions(int index, String item) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToCapacity(Map<String, DeviceCapacity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, DeviceCapacity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToCapacity(String key, DeviceCapacity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, DeviceCapacity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConsumesCounters(DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConsumesCounters(int index, DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTaints(DeviceTaint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTaints(int index, DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DeviceCounterConsumption buildConsumesCounter(int index) {
        return this.consumesCounters.get(index).build();
    }

    public List<DeviceCounterConsumption> buildConsumesCounters() {
        return this.consumesCounters != null ? DeviceFluent.build(this.consumesCounters) : null;
    }

    public DeviceCounterConsumption buildFirstConsumesCounter() {
        return this.consumesCounters.get(0).build();
    }

    public DeviceTaint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    public DeviceCounterConsumption buildLastConsumesCounter() {
        return this.consumesCounters.get(this.consumesCounters.size() - 1).build();
    }

    public DeviceTaint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    public DeviceCounterConsumption buildMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        for (DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceTaint buildMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        for (DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceTaint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    public List<DeviceTaint> buildTaints() {
        return this.taints != null ? DeviceFluent.build(this.taints) : null;
    }

    protected void copyInstance(Device instance) {
        Device device = instance = instance != null ? instance : new Device();
        if (instance != null) {
            this.withAllNodes(instance.getAllNodes());
            this.withAllowMultipleAllocations(instance.getAllowMultipleAllocations());
            this.withAttributes(instance.getAttributes());
            this.withBindingConditions(instance.getBindingConditions());
            this.withBindingFailureConditions(instance.getBindingFailureConditions());
            this.withBindsToNode(instance.getBindsToNode());
            this.withCapacity(instance.getCapacity());
            this.withConsumesCounters(instance.getConsumesCounters());
            this.withName(instance.getName());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTaints(instance.getTaints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConsumesCountersNested<A> editConsumesCounter(int index) {
        if (this.consumesCounters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "consumesCounters"));
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public ConsumesCountersNested<A> editFirstConsumesCounter() {
        if (this.consumesCounters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "consumesCounters"));
        }
        return this.setNewConsumesCounterLike(0, this.buildConsumesCounter(0));
    }

    public TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "taints"));
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    public ConsumesCountersNested<A> editLastConsumesCounter() {
        int index = this.consumesCounters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "consumesCounters"));
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "taints"));
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public ConsumesCountersNested<A> editMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.consumesCounters.size(); ++i) {
            if (!predicate.test(this.consumesCounters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "consumesCounters"));
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public TaintsNested<A> editMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "taints"));
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "taints"));
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceFluent that = (DeviceFluent)((Object)o);
        if (!Objects.equals(this.allNodes, that.allNodes)) {
            return false;
        }
        if (!Objects.equals(this.allowMultipleAllocations, that.allowMultipleAllocations)) {
            return false;
        }
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.bindingConditions, that.bindingConditions)) {
            return false;
        }
        if (!Objects.equals(this.bindingFailureConditions, that.bindingFailureConditions)) {
            return false;
        }
        if (!Objects.equals(this.bindsToNode, that.bindsToNode)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.consumesCounters, that.consumesCounters)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public Boolean getAllowMultipleAllocations() {
        return this.allowMultipleAllocations;
    }

    public Map<String, DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public String getBindingCondition(int index) {
        return this.bindingConditions.get(index);
    }

    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public String getBindingFailureCondition(int index) {
        return this.bindingFailureConditions.get(index);
    }

    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public Boolean getBindsToNode() {
        return this.bindsToNode;
    }

    public Map<String, DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public String getFirstBindingCondition() {
        return this.bindingConditions.get(0);
    }

    public String getFirstBindingFailureCondition() {
        return this.bindingFailureConditions.get(0);
    }

    public String getLastBindingCondition() {
        return this.bindingConditions.get(this.bindingConditions.size() - 1);
    }

    public String getLastBindingFailureCondition() {
        return this.bindingFailureConditions.get(this.bindingFailureConditions.size() - 1);
    }

    public String getMatchingBindingCondition(Predicate<String> predicate) {
        for (String item : this.bindingConditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingBindingFailureCondition(Predicate<String> predicate) {
        for (String item : this.bindingFailureConditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllNodes() {
        return this.allNodes != null;
    }

    public boolean hasAllowMultipleAllocations() {
        return this.allowMultipleAllocations != null;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public boolean hasBindingConditions() {
        return this.bindingConditions != null && !this.bindingConditions.isEmpty();
    }

    public boolean hasBindingFailureConditions() {
        return this.bindingFailureConditions != null && !this.bindingFailureConditions.isEmpty();
    }

    public boolean hasBindsToNode() {
        return this.bindsToNode != null;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public boolean hasConsumesCounters() {
        return this.consumesCounters != null && !this.consumesCounters.isEmpty();
    }

    public boolean hasMatchingBindingCondition(Predicate<String> predicate) {
        for (String item : this.bindingConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingBindingFailureCondition(Predicate<String> predicate) {
        for (String item : this.bindingFailureConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        for (DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        for (DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.allowMultipleAllocations, this.attributes, this.bindingConditions, this.bindingFailureConditions, this.bindsToNode, this.capacity, this.consumesCounters, this.name, this.nodeName, this.nodeSelector, this.taints, this.additionalProperties);
    }

    public A removeAllFromBindingConditions(Collection<String> items) {
        if (this.bindingConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBindingFailureConditions(Collection<String> items) {
        if (this.bindingFailureConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingFailureConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConsumesCounters(Collection<DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            return (A)((Object)this);
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get((Object)"consumesCounters").remove((Object)builder);
            this.consumesCounters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTaints(Collection<DeviceTaint> items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get((Object)"taints").remove((Object)builder);
            this.taints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(String key) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(Map<String, DeviceAttribute> map) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromBindingConditions(String ... items) {
        if (this.bindingConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBindingFailureConditions(String ... items) {
        if (this.bindingFailureConditions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bindingFailureConditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(Map<String, DeviceCapacity> map) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConsumesCounters(DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            return (A)((Object)this);
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get((Object)"consumesCounters").remove((Object)builder);
            this.consumesCounters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTaints(DeviceTaint ... items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get((Object)"taints").remove((Object)builder);
            this.taints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConsumesCounters(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        if (this.consumesCounters == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceCounterConsumptionBuilder> each = this.consumesCounters.iterator();
        List visitables = this._visitables.get((Object)"consumesCounters");
        while (each.hasNext()) {
            DeviceCounterConsumptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTaints(Predicate<DeviceTaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceTaintBuilder> each = this.taints.iterator();
        List visitables = this._visitables.get((Object)"taints");
        while (each.hasNext()) {
            DeviceTaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConsumesCountersNested<A> setNewConsumesCounterLike(int index, DeviceCounterConsumption item) {
        return new ConsumesCountersNested(index, item);
    }

    public TaintsNested<A> setNewTaintLike(int index, DeviceTaint item) {
        return new TaintsNested(index, item);
    }

    public A setToBindingConditions(int index, String item) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToBindingFailureConditions(int index, String item) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToConsumesCounters(int index, DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get((Object)"consumesCounters").add(builder);
            this.consumesCounters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTaints(int index, DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get((Object)"taints").add(builder);
            this.taints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allNodes != null) {
            sb.append("allNodes:");
            sb.append(this.allNodes);
            sb.append(",");
        }
        if (this.allowMultipleAllocations != null) {
            sb.append("allowMultipleAllocations:");
            sb.append(this.allowMultipleAllocations);
            sb.append(",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes);
            sb.append(",");
        }
        if (this.bindingConditions != null && !this.bindingConditions.isEmpty()) {
            sb.append("bindingConditions:");
            sb.append(this.bindingConditions);
            sb.append(",");
        }
        if (this.bindingFailureConditions != null && !this.bindingFailureConditions.isEmpty()) {
            sb.append("bindingFailureConditions:");
            sb.append(this.bindingFailureConditions);
            sb.append(",");
        }
        if (this.bindsToNode != null) {
            sb.append("bindsToNode:");
            sb.append(this.bindsToNode);
            sb.append(",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(this.capacity);
            sb.append(",");
        }
        if (this.consumesCounters != null && !this.consumesCounters.isEmpty()) {
            sb.append("consumesCounters:");
            sb.append(this.consumesCounters);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName);
            sb.append(",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector);
            sb.append(",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(this.taints);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllNodes() {
        return this.withAllNodes(true);
    }

    public A withAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return (A)((Object)this);
    }

    public A withAllowMultipleAllocations() {
        return this.withAllowMultipleAllocations(true);
    }

    public A withAllowMultipleAllocations(Boolean allowMultipleAllocations) {
        this.allowMultipleAllocations = allowMultipleAllocations;
        return (A)((Object)this);
    }

    public <K, V> A withAttributes(Map<String, DeviceAttribute> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<String, DeviceAttribute>(attributes);
        return (A)((Object)this);
    }

    public A withBindingConditions(List<String> bindingConditions) {
        if (bindingConditions != null) {
            this.bindingConditions = new ArrayList<String>();
            for (String item : bindingConditions) {
                this.addToBindingConditions(item);
            }
        } else {
            this.bindingConditions = null;
        }
        return (A)((Object)this);
    }

    public A withBindingConditions(String ... bindingConditions) {
        if (this.bindingConditions != null) {
            this.bindingConditions.clear();
            this._visitables.remove((Object)"bindingConditions");
        }
        if (bindingConditions != null) {
            for (String item : bindingConditions) {
                this.addToBindingConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withBindingFailureConditions(List<String> bindingFailureConditions) {
        if (bindingFailureConditions != null) {
            this.bindingFailureConditions = new ArrayList<String>();
            for (String item : bindingFailureConditions) {
                this.addToBindingFailureConditions(item);
            }
        } else {
            this.bindingFailureConditions = null;
        }
        return (A)((Object)this);
    }

    public A withBindingFailureConditions(String ... bindingFailureConditions) {
        if (this.bindingFailureConditions != null) {
            this.bindingFailureConditions.clear();
            this._visitables.remove((Object)"bindingFailureConditions");
        }
        if (bindingFailureConditions != null) {
            for (String item : bindingFailureConditions) {
                this.addToBindingFailureConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withBindsToNode() {
        return this.withBindsToNode(true);
    }

    public A withBindsToNode(Boolean bindsToNode) {
        this.bindsToNode = bindsToNode;
        return (A)((Object)this);
    }

    public <K, V> A withCapacity(Map<String, DeviceCapacity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, DeviceCapacity>(capacity);
        return (A)((Object)this);
    }

    public A withConsumesCounters(List<DeviceCounterConsumption> consumesCounters) {
        if (this.consumesCounters != null) {
            this._visitables.get((Object)"consumesCounters").clear();
        }
        if (consumesCounters != null) {
            this.consumesCounters = new ArrayList();
            for (DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        } else {
            this.consumesCounters = null;
        }
        return (A)((Object)this);
    }

    public A withConsumesCounters(DeviceCounterConsumption ... consumesCounters) {
        if (this.consumesCounters != null) {
            this.consumesCounters.clear();
            this._visitables.remove((Object)"consumesCounters");
        }
        if (consumesCounters != null) {
            for (DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return (A)((Object)this);
    }

    public A withTaints(List<DeviceTaint> taints) {
        if (this.taints != null) {
            this._visitables.get((Object)"taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)((Object)this);
    }

    public A withTaints(DeviceTaint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove((Object)"taints");
        }
        if (taints != null) {
            for (DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)((Object)this);
    }

    public class TaintsNested<N>
    extends DeviceTaintFluent<TaintsNested<N>>
    implements Nested<N> {
        DeviceTaintBuilder builder;
        int index;

        TaintsNested(int index, DeviceTaint item) {
            this.index = index;
            this.builder = new DeviceTaintBuilder(this, item);
        }

        public N and() {
            return (N)DeviceFluent.this.setToTaints(this.index, this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }

    public class ConsumesCountersNested<N>
    extends DeviceCounterConsumptionFluent<ConsumesCountersNested<N>>
    implements Nested<N> {
        DeviceCounterConsumptionBuilder builder;
        int index;

        ConsumesCountersNested(int index, DeviceCounterConsumption item) {
            this.index = index;
            this.builder = new DeviceCounterConsumptionBuilder(this, item);
        }

        public N and() {
            return (N)DeviceFluent.this.setToConsumesCounters(this.index, this.builder.build());
        }

        public N endConsumesCounter() {
            return this.and();
        }
    }
}

