/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.session;

import org.sparkproject.jetty.http.HttpCookie;
import org.sparkproject.jetty.session.SessionCache;
import org.sparkproject.jetty.session.SessionIdManager;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;

public interface SessionConfig {
    public static final String __SessionCookieProperty = "org.sparkproject.jetty.session.SessionCookie";
    public static final String __DefaultSessionCookie = "JSESSIONID";
    public static final String __SessionIdPathParameterNameProperty = "org.sparkproject.jetty.session.SessionIdPathParameterName";
    public static final String __DefaultSessionIdPathParameterName = "jsessionid";
    public static final String __CheckRemoteSessionEncodingProperty = "org.sparkproject.jetty.session.CheckingRemoteSessionIdEncoding";
    public static final String __SessionDomainProperty = "org.sparkproject.jetty.session.SessionDomain";
    public static final String __DefaultSessionDomain = null;
    public static final String __SessionPathProperty = "org.sparkproject.jetty.session.SessionPath";
    public static final String __MaxAgeProperty = "org.sparkproject.jetty.session.MaxAge";

    @ManagedAttribute(value="if greater the zero, the time in seconds a session cookie will last for")
    public int getMaxCookieAge();

    @ManagedAttribute(value="default maximum time a session may be idle for (in s)")
    public int getMaxInactiveInterval();

    @ManagedAttribute(value="time before a session cookie is re-set (in s)")
    public int getRefreshCookieAge();

    @ManagedAttribute(value="the session cookie sameSite mode")
    public HttpCookie.SameSite getSameSite();

    @ManagedAttribute(value="the cookie comment to use when setting session tracking cookies")
    public String getSessionComment();

    @ManagedAttribute(value="the cookie name used to track sessions with cookies")
    public String getSessionCookie();

    @ManagedAttribute(value="domain of the session cookie, or null for the default")
    public String getSessionDomain();

    @ManagedAttribute(value="parameter name to use for URL session tracking")
    public String getSessionIdPathParameterName();

    public String getSessionIdPathParameterNamePrefix();

    @ManagedAttribute(value="path of the session cookie, or null for default")
    public String getSessionPath();

    @ManagedAttribute(value="check remote session id encoding")
    public boolean isCheckingRemoteSessionIdEncoding();

    @ManagedAttribute(value="true if cookies use the http only flag")
    public boolean isHttpOnly();

    @ManagedAttribute(value="true if cookies have the Partitioned attribute")
    public boolean isPartitioned();

    @ManagedAttribute(value="if true, secure cookie flag is set on session cookies")
    public boolean isSecureCookies();

    @ManagedAttribute(value="true if ???? TODO")
    public boolean isSecureRequestOnly();

    @ManagedAttribute(value="true if sessions are tracked with cookies")
    public boolean isUsingCookies();

    @ManagedAttribute(value="true if sessions are tracked with URLs")
    public boolean isUsingUriParameters();

    public static interface Mutable
    extends SessionConfig {
        public void setCheckingRemoteSessionIdEncoding(boolean var1);

        public void setHttpOnly(boolean var1);

        public void setPartitioned(boolean var1);

        public void setMaxCookieAge(int var1);

        public void setMaxInactiveInterval(int var1);

        public void setRefreshCookieAge(int var1);

        public void setSameSite(HttpCookie.SameSite var1);

        public void setSecureCookies(boolean var1);

        public void setSecureRequestOnly(boolean var1);

        public void setSessionComment(String var1);

        public void setSessionCookie(String var1);

        public void setSessionDomain(String var1);

        public void setSessionIdPathParameterName(String var1);

        public void setSessionPath(String var1);

        public void setUsingCookies(boolean var1);

        public void setUsingUriParameters(boolean var1);

        public void setSessionCache(SessionCache var1);

        public void setSessionIdManager(SessionIdManager var1);
    }
}

