/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.net.Socket;
import org.sparkproject.jetty.io.Connection;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.io.SocketChannelEndPoint;
import org.sparkproject.jetty.io.ssl.SslConnection;

public class SocketCustomizationListener
implements Connection.Listener {
    private final boolean _ssl;

    public SocketCustomizationListener() {
        this(true);
    }

    public SocketCustomizationListener(boolean ssl) {
        this._ssl = ssl;
    }

    @Override
    public void onOpened(Connection connection) {
        EndPoint endPoint = connection.getEndPoint();
        boolean ssl = false;
        if (this._ssl && endPoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endPoint;
            endPoint = sslEndPoint.getSslConnection().getEndPoint();
            ssl = true;
        }
        if (endPoint instanceof SocketChannelEndPoint) {
            SocketChannelEndPoint socketEndPoint = (SocketChannelEndPoint)endPoint;
            Socket socket = socketEndPoint.getChannel().socket();
            this.customize(socket, connection.getClass(), ssl);
        }
    }

    protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
    }

    @Override
    public void onClosed(Connection connection) {
    }
}

