/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.EventListener;
import java.util.concurrent.Executor;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.io.Connection;
import org.sparkproject.jetty.io.DatagramChannelEndPoint;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.io.ManagedSelector;
import org.sparkproject.jetty.io.SelectorManager;
import org.sparkproject.jetty.server.AbstractNetworkConnector;
import org.sparkproject.jetty.server.ConnectionFactory;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.thread.Scheduler;

public class DatagramServerConnector
extends AbstractNetworkConnector {
    private final ServerDatagramSelectorManager selectorManager = new ServerDatagramSelectorManager(this.getExecutor(), this.getScheduler(), 1);
    private volatile DatagramChannel datagramChannel;
    private volatile int localPort = -1;

    public DatagramServerConnector(Server server, ConnectionFactory ... factories) {
        this(server, (Executor)null, (Scheduler)null, (ByteBufferPool)null, factories);
    }

    public DatagramServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public boolean isOpen() {
        DatagramChannel channel = this.datagramChannel;
        return channel != null && channel.isOpen();
    }

    @Override
    protected void doStart() throws Exception {
        this.addBean(this.selectorManager);
        this.addBean(this.datagramChannel);
        for (EventListener eventListener : this.getBeans(SelectorManager.SelectorManagerListener.class)) {
            this.selectorManager.addEventListener(eventListener);
        }
        super.doStart();
        this.selectorManager.accept(this.datagramChannel);
    }

    @Override
    public void open() throws IOException {
        if (this.datagramChannel == null) {
            this.datagramChannel = this.openDatagramChannel();
            this.datagramChannel.configureBlocking(false);
            this.localPort = this.datagramChannel.socket().getLocalPort();
            if (this.localPort <= 0) {
                throw new IOException("DatagramChannel not bound");
            }
            super.open();
        }
    }

    protected DatagramChannel openDatagramChannel() throws IOException {
        InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        DatagramChannel datagramChannel = DatagramChannel.open();
        try {
            datagramChannel.bind(bindAddress);
            return datagramChannel;
        }
        catch (Throwable e) {
            IO.close(datagramChannel);
            throw new IOException("Failed to bind to " + String.valueOf(bindAddress), e);
        }
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.selectorManager.setIdleTimeout(idleTimeout);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.datagramChannel);
        this.datagramChannel = null;
        for (EventListener l : this.getBeans(EventListener.class)) {
            this.selectorManager.removeEventListener(l);
        }
    }

    @Override
    public void close() {
        super.close();
        this.localPort = -2;
    }

    @Override
    public Object getTransport() {
        return this.datagramChannel;
    }

    @Override
    protected void accept(int acceptorID) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " has no accept mechanism");
    }

    protected EndPoint newEndPoint(DatagramChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
        return new DatagramChannelEndPoint(channel, selector, selectionKey, this.getScheduler());
    }

    protected Connection newConnection(EndPoint endpoint) {
        return this.getDefaultConnectionFactory().newConnection(this, endpoint);
    }

    private class ServerDatagramSelectorManager
    extends SelectorManager {
        protected ServerDatagramSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            EndPoint endPoint = DatagramServerConnector.this.newEndPoint((DatagramChannel)channel, selector, selectionKey);
            endPoint.setIdleTimeout(DatagramServerConnector.this.getIdleTimeout());
            return endPoint;
        }

        @Override
        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            return DatagramServerConnector.this.newConnection(endpoint);
        }

        @Override
        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            DatagramServerConnector.this.onEndPointOpened(endpoint);
        }

        @Override
        protected void endPointClosed(EndPoint endpoint) {
            DatagramServerConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }

        private void setIdleTimeout(long idleTimeout) {
            DatagramServerConnector.this.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(idleTimeout));
        }
    }
}

