/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security.jaas.callback;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.sparkproject.jetty.security.jaas.callback.AbstractCallbackHandler;
import org.sparkproject.jetty.security.jaas.callback.ObjectCallback;
import org.sparkproject.jetty.security.jaas.callback.RequestCallback;
import org.sparkproject.jetty.security.jaas.callback.RequestParameterCallback;
import org.sparkproject.jetty.server.FormFields;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.util.Fields;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request) {
        this._request = request;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.getUserName());
                continue;
            }
            if (callback instanceof ObjectCallback) {
                ((ObjectCallback)callback).setObject(this.getCredential());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.getCredential().toString().toCharArray());
                continue;
            }
            if (callback instanceof RequestParameterCallback) {
                if (this._request == null) continue;
                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                Fields queryFields = Request.extractQueryParameters(this._request);
                Fields formFields = FormFields.getFields(this._request);
                Fields fields = Fields.combine(queryFields, formFields);
                rpc.setParameterValues(fields.getValues(rpc.getParameterName()));
                continue;
            }
            if (callback instanceof RequestCallback) {
                ((RequestCallback)callback).setRequest(this._request);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

