/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.Part;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.sparkproject.jetty.ee10.servlet.ServletApiRequest;
import org.sparkproject.jetty.ee10.servlet.ServletContextHandler;
import org.sparkproject.jetty.ee10.servlet.ServletContextRequest;
import org.sparkproject.jetty.ee10.servlet.ServletContextResponse;
import org.sparkproject.jetty.ee10.servlet.ServletHandler;
import org.sparkproject.jetty.ee10.servlet.ServletMultiPartFormData;
import org.sparkproject.jetty.ee10.servlet.ServletPathMapping;
import org.sparkproject.jetty.ee10.servlet.ServletRequestHttpWrapper;
import org.sparkproject.jetty.ee10.servlet.ServletResponseHttpWrapper;
import org.sparkproject.jetty.ee10.servlet.util.ServletOutputStreamWrapper;
import org.sparkproject.jetty.http.HttpURI;
import org.sparkproject.jetty.http.pathmap.MatchedResource;
import org.sparkproject.jetty.io.WriterOutputStream;
import org.sparkproject.jetty.util.Fields;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_PREFIX = "jakarta.servlet.include.";
    public static final String __FORWARD_PREFIX = "jakarta.servlet.forward.";
    public static final String __ORIGINAL_REQUEST = "org.sparkproject.jetty.originalRequest";
    public static final String JETTY_INCLUDE_HEADER_PREFIX = "org.sparkproject.jetty.server.include.";
    public static final String WRAPPED_REQUEST_ATTRIBUTE = "org.sparkproject.jetty.server.wrappedRequest";
    private final ServletContextHandler _contextHandler;
    private final HttpURI _uri;
    private final String _decodedPathInContext;
    private final String _named;
    private final ServletHandler.MappedServlet _mappedServlet;
    private final ServletHandler _servletHandler;
    private final ServletPathMapping _servletPathMapping;

    public Dispatcher(ServletContextHandler contextHandler, HttpURI uri, String decodedPathInContext) {
        this._contextHandler = contextHandler;
        this._uri = uri.asImmutable();
        this._decodedPathInContext = decodedPathInContext;
        this._named = null;
        this._servletHandler = this._contextHandler.getServletHandler();
        MatchedResource<ServletHandler.MappedServlet> matchedServlet = this._servletHandler.getMatchedServlet(decodedPathInContext);
        if (matchedServlet == null) {
            throw new IllegalArgumentException("No servlet matching: " + decodedPathInContext);
        }
        this._mappedServlet = matchedServlet.getResource();
        this._servletPathMapping = this._mappedServlet.getServletPathMapping(this._decodedPathInContext, matchedServlet.getMatchedPath());
        if (this._servletPathMapping == null) {
            throw new IllegalArgumentException("No servlet path mapping: " + String.valueOf(this._servletPathMapping));
        }
    }

    public Dispatcher(ServletContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._uri = null;
        this._decodedPathInContext = null;
        this._named = name;
        this._servletHandler = this._contextHandler.getServletHandler();
        this._mappedServlet = this._servletHandler.getMappedServlet(name);
        this._servletPathMapping = null;
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        assert (this._named == null) : "not allowed to have a named dispatch on error";
        assert (this._servletPathMapping != null) : "Servlet Path Mapping required";
        assert (this._uri != null) : "URI is required";
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        this._mappedServlet.handle(this._servletHandler, this._decodedPathInContext, (HttpServletRequest)new ErrorRequest(httpRequest), httpResponse);
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(request);
        servletContextRequest.getServletContextResponse().resetForForward();
        this._mappedServlet.handle(this._servletHandler, this._decodedPathInContext, (HttpServletRequest)new ForwardRequest(httpRequest), httpResponse);
        if (!servletContextRequest.getState().isAsync() && !servletContextRequest.getServletContextResponse().hasLastWrite()) {
            Object closeable;
            try {
                closeable = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                closeable = response.getWriter();
            }
            IO.close((Closeable)closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        ServletContextResponse servletContextResponse = ServletContextResponse.getServletContextResponse(response);
        IncludeResponse includeResponse = new IncludeResponse(httpResponse);
        try {
            this._mappedServlet.handle(this._servletHandler, this._decodedPathInContext, (HttpServletRequest)new IncludeRequest(httpRequest), (HttpServletResponse)includeResponse);
        }
        finally {
            includeResponse.onIncluded();
            servletContextResponse.included();
        }
    }

    public void async(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        this._mappedServlet.handle(this._servletHandler, this._decodedPathInContext, (HttpServletRequest)new AsyncRequest(httpRequest), httpResponse);
    }

    public String toString() {
        return String.format("Dispatcher@0x%x{%s,%s}", this.hashCode(), this._named, this._uri);
    }

    private class ErrorRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public ErrorRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.ERROR;
        }

        public String getPathInfo() {
            return Dispatcher.this._servletPathMapping.getPathInfo();
        }

        public String getServletPath() {
            return Dispatcher.this._servletPathMapping.getServletPath();
        }

        public HttpServletMapping getHttpServletMapping() {
            return Dispatcher.this._servletPathMapping;
        }

        public String getRequestURI() {
            return Dispatcher.this._uri.getPath();
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(HttpURI.build(Dispatcher.this._uri).scheme(this.getScheme()).host(this.getServerName()).port(this.getServerPort()).asString());
        }

        public Object getAttribute(String name) {
            return switch (name) {
                case "jakarta.servlet.error.request_uri" -> this._httpServletRequest.getRequestURI();
                case "jakarta.servlet.error.status_code" -> super.getAttribute("org.sparkproject.jetty.server.error_status");
                case "jakarta.servlet.error.message" -> super.getAttribute("org.sparkproject.jetty.server.error_message");
                case "jakarta.servlet.error.servlet_name" -> super.getAttribute("org.sparkproject.jetty.server.error_origin");
                case "jakarta.servlet.error.exception" -> super.getAttribute("org.sparkproject.jetty.server.error_exception");
                case "jakarta.servlet.error.exception_type" -> {
                    Object err = super.getAttribute("org.sparkproject.jetty.server.error_exception");
                    if (err == null) {
                        yield null;
                    }
                    yield err.getClass();
                }
                default -> super.getAttribute(name);
            };
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList<String> names = new ArrayList<String>(List.of("jakarta.servlet.error.request_uri", "jakarta.servlet.error.status_code", "jakarta.servlet.error.message", "jakarta.servlet.error.servlet_name", "jakarta.servlet.error.exception", "jakarta.servlet.error.exception_type"));
            names.addAll(Collections.list(super.getAttributeNames()));
            return Collections.enumeration(names);
        }
    }

    private class ForwardRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public ForwardRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.FORWARD;
        }

        public String getPathInfo() {
            if (Dispatcher.this._servletPathMapping == null) {
                return super.getPathInfo();
            }
            return Dispatcher.this._servletPathMapping.getPathInfo();
        }

        public String getServletPath() {
            if (Dispatcher.this._servletPathMapping == null) {
                return super.getServletPath();
            }
            return Dispatcher.this._servletPathMapping.getServletPath();
        }

        public HttpServletMapping getHttpServletMapping() {
            if (Dispatcher.this._named != null) {
                return super.getHttpServletMapping();
            }
            return Dispatcher.this._servletPathMapping;
        }

        public String getRequestURI() {
            return Dispatcher.this._uri == null ? super.getRequestURI() : Dispatcher.this._uri.getPath();
        }

        public StringBuffer getRequestURL() {
            return Dispatcher.this._uri == null ? super.getRequestURL() : new StringBuffer(HttpURI.build(Dispatcher.this._uri).query(null).scheme(super.getScheme()).host(super.getServerName()).port(super.getServerPort()).asString());
        }

        public Object getAttribute(String name) {
            if (name == null) {
                return null;
            }
            if (Dispatcher.this._named != null && name.startsWith(Dispatcher.__FORWARD_PREFIX)) {
                return null;
            }
            if (name.startsWith(Dispatcher.__FORWARD_PREFIX)) {
                HttpServletRequest originalRequest = (HttpServletRequest)super.getAttribute(Dispatcher.__ORIGINAL_REQUEST);
                if (originalRequest == null) {
                    originalRequest = this._httpServletRequest;
                }
                return switch (name) {
                    case "jakarta.servlet.forward.request_uri" -> originalRequest.getRequestURI();
                    case "jakarta.servlet.forward.servlet_path" -> originalRequest.getServletPath();
                    case "jakarta.servlet.forward.path_info" -> originalRequest.getPathInfo();
                    case "jakarta.servlet.forward.context_path" -> originalRequest.getContextPath();
                    case "jakarta.servlet.forward.mapping" -> originalRequest.getHttpServletMapping();
                    case "jakarta.servlet.forward.query_string" -> originalRequest.getQueryString();
                    default -> super.getAttribute(name);
                };
            }
            switch (name) {
                case "org.sparkproject.jetty.originalRequest": {
                    HttpServletRequest originalRequest = (HttpServletRequest)super.getAttribute(name);
                    return originalRequest == null ? this._httpServletRequest : originalRequest;
                }
                case "jakarta.servlet.include.mapping": 
                case "jakarta.servlet.include.servlet_path": 
                case "jakarta.servlet.include.path_info": 
                case "jakarta.servlet.include.request_uri": 
                case "jakarta.servlet.include.context_path": 
                case "jakarta.servlet.include.query_string": {
                    return null;
                }
                case "org.sparkproject.jetty.multipartConfig": {
                    if (super.getAttribute(ServletMultiPartFormData.class.getName()) != null) {
                        return super.getAttribute(name);
                    }
                    return Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement();
                }
            }
            return super.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            if (names.contains("org.sparkproject.jetty.multipartConfig") && Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement() == null) {
                names.remove("org.sparkproject.jetty.multipartConfig");
            }
            if (Dispatcher.this._named != null) {
                return Collections.enumeration(names);
            }
            names.add("jakarta.servlet.forward.request_uri");
            names.add("jakarta.servlet.forward.servlet_path");
            names.add("jakarta.servlet.forward.path_info");
            names.add("jakarta.servlet.forward.context_path");
            names.add("jakarta.servlet.forward.mapping");
            names.add("jakarta.servlet.forward.query_string");
            return Collections.enumeration(names);
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Collection collection = super.getParts();
                return collection;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }

        public Part getPart(String name) throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Part part = super.getPart(name);
                return part;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }
    }

    private static class IncludeResponse
    extends HttpServletResponseWrapper {
        ServletOutputStream _servletOutputStream;
        PrintWriter _printWriter;
        PrintWriter _mustFlush;

        public IncludeResponse(HttpServletResponse response) {
            super(response);
        }

        public void onIncluded() {
            if (this._mustFlush != null) {
                this._mustFlush.flush();
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._printWriter != null) {
                throw new IllegalStateException("getWriter() called");
            }
            if (this._servletOutputStream == null) {
                try {
                    this._servletOutputStream = new ServletOutputStreamWrapper(this.getResponse().getOutputStream()){

                        @Override
                        public void close() {
                        }
                    };
                }
                catch (IllegalStateException ise) {
                    final WriterOutputStream os = new WriterOutputStream(this.getResponse().getWriter(), this.getResponse().getCharacterEncoding());
                    this._servletOutputStream = new ServletOutputStream(this){
                        final /* synthetic */ IncludeResponse this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean isReady() {
                            return true;
                        }

                        public void setWriteListener(WriteListener writeListener) {
                            throw new UnsupportedOperationException();
                        }

                        public void write(int b) throws IOException {
                            os.write(b);
                        }

                        public void write(byte[] b) throws IOException {
                            os.write(b);
                        }

                        public void write(byte[] b, int off, int len) throws IOException {
                            os.write(b, off, len);
                        }

                        public void flush() throws IOException {
                            os.flush();
                        }

                        public void close() {
                        }
                    };
                }
            }
            return this._servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._servletOutputStream != null) {
                throw new IllegalStateException("getOutputStream called");
            }
            if (this._printWriter == null) {
                try {
                    this._printWriter = super.getWriter();
                }
                catch (IllegalStateException ise) {
                    this._printWriter = this._mustFlush = new PrintWriter(new OutputStreamWriter((OutputStream)super.getOutputStream(), super.getCharacterEncoding()));
                }
            }
            return this._printWriter;
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setLocale(Locale loc) {
        }

        public void setContentLength(int len) {
        }

        public void setContentLengthLong(long len) {
        }

        public void setContentType(String type) {
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
            if (!StringUtil.isBlank(name) && name.startsWith(Dispatcher.JETTY_INCLUDE_HEADER_PREFIX)) {
                super.setHeader(name.substring(Dispatcher.JETTY_INCLUDE_HEADER_PREFIX.length()), value);
            }
        }

        public void addHeader(String name, String value) {
            if (!StringUtil.isBlank(name) && name.startsWith(Dispatcher.JETTY_INCLUDE_HEADER_PREFIX)) {
                super.addHeader(name.substring(Dispatcher.JETTY_INCLUDE_HEADER_PREFIX.length()), value);
            }
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }
    }

    private class IncludeRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public IncludeRequest(HttpServletRequest request) {
            super(request);
            this._httpServletRequest = request;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.INCLUDE;
        }

        public Object getAttribute(String name) {
            if (name == null) {
                return null;
            }
            if (Dispatcher.this._named != null && name.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return switch (name) {
                case "jakarta.servlet.include.mapping" -> Dispatcher.this._servletPathMapping;
                case "jakarta.servlet.include.servlet_path" -> Dispatcher.this._servletPathMapping.getServletPath();
                case "jakarta.servlet.include.path_info" -> Dispatcher.this._servletPathMapping.getPathInfo();
                case "jakarta.servlet.include.request_uri" -> {
                    if (Dispatcher.this._uri == null) {
                        yield null;
                    }
                    yield Dispatcher.this._uri.getPath();
                }
                case "jakarta.servlet.include.context_path" -> this._httpServletRequest.getContextPath();
                case "jakarta.servlet.include.query_string" -> {
                    if (Dispatcher.this._uri == null) {
                        yield null;
                    }
                    yield Dispatcher.this._uri.getQuery();
                }
                case "org.sparkproject.jetty.multipartConfig" -> {
                    if (super.getAttribute(ServletMultiPartFormData.class.getName()) != null) {
                        yield super.getAttribute(name);
                    }
                    yield Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement();
                }
                default -> super.getAttribute(name);
            };
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            if (Dispatcher.this._named != null) {
                return Collections.enumeration(names);
            }
            if (names.contains("org.sparkproject.jetty.multipartConfig") && Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement() == null) {
                names.remove("org.sparkproject.jetty.multipartConfig");
            }
            names.add("jakarta.servlet.include.mapping");
            names.add("jakarta.servlet.include.servlet_path");
            names.add("jakarta.servlet.include.path_info");
            names.add("jakarta.servlet.include.request_uri");
            names.add("jakarta.servlet.include.context_path");
            names.add("jakarta.servlet.include.query_string");
            return Collections.enumeration(names);
        }

        @Override
        public String getQueryString() {
            return this._httpServletRequest.getQueryString();
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Collection collection = super.getParts();
                return collection;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }

        public Part getPart(String name) throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Part part = super.getPart(name);
                return part;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }
    }

    private class AsyncRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public AsyncRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
            Objects.requireNonNull(Dispatcher.this._servletPathMapping);
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.ASYNC;
        }

        public String getPathInfo() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping).getPathInfo();
        }

        public String getServletPath() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping).getServletPath();
        }

        public HttpServletMapping getHttpServletMapping() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping);
        }

        public String getRequestURI() {
            return Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getPath();
        }

        public StringBuffer getRequestURL() {
            return Dispatcher.this._uri == null ? super.getRequestURL() : new StringBuffer(HttpURI.build(Dispatcher.this._uri).query(null).scheme(super.getScheme()).host(super.getServerName()).port(super.getServerPort()).asString());
        }

        public Object getAttribute(String name) {
            return switch (name) {
                case "jakarta.servlet.async.request_uri" -> this._httpServletRequest.getRequestURI();
                case "jakarta.servlet.async.context_path" -> this._httpServletRequest.getContextPath();
                case "jakarta.servlet.async.mapping" -> this._httpServletRequest.getHttpServletMapping();
                case "jakarta.servlet.async.path_info" -> this._httpServletRequest.getPathInfo();
                case "jakarta.servlet.async.servlet_path" -> this._httpServletRequest.getServletPath();
                case "jakarta.servlet.async.query_string" -> this._httpServletRequest.getQueryString();
                case "org.sparkproject.jetty.multipartConfig" -> {
                    if (super.getAttribute(ServletMultiPartFormData.class.getName()) != null) {
                        yield super.getAttribute(name);
                    }
                    yield Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement();
                }
                default -> super.getAttribute(name);
            };
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            if (names.contains("org.sparkproject.jetty.multipartConfig") && Dispatcher.this._mappedServlet.getServletHolder().getMultipartConfigElement() == null) {
                names.remove("org.sparkproject.jetty.multipartConfig");
            }
            names.add("jakarta.servlet.async.request_uri");
            names.add("jakarta.servlet.async.servlet_path");
            names.add("jakarta.servlet.async.path_info");
            names.add("jakarta.servlet.async.context_path");
            names.add("jakarta.servlet.async.mapping");
            names.add("jakarta.servlet.async.query_string");
            return Collections.enumeration(names);
        }

        @Override
        protected Fields getParameters() {
            ServletRequest servletRequest = this.getRequest();
            if (servletRequest instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                HttpURI.Mutable requestURI = HttpURI.build(httpServletRequest.getRequestURI()).query(httpServletRequest.getQueryString());
                if (((Object)requestURI).equals(Dispatcher.this._uri)) {
                    ServletRequest servletRequest2 = this.getRequest();
                    if (servletRequest2 instanceof ParameterRequestWrapper) {
                        ParameterRequestWrapper parameterRequestWrapper = (ParameterRequestWrapper)servletRequest2;
                        return parameterRequestWrapper.getParameters();
                    }
                    servletRequest2 = this.getRequest();
                    if (servletRequest2 instanceof ServletApiRequest) {
                        ServletApiRequest servletApiRequest = (ServletApiRequest)servletRequest2;
                        return servletApiRequest.getParameters();
                    }
                    return super.getParameters();
                }
                return super.getParameters();
            }
            return super.getParameters();
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Collection collection = super.getParts();
                return collection;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }

        public Part getPart(String name) throws IOException, ServletException {
            try {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, (Object)this);
                Part part = super.getPart(name);
                return part;
            }
            finally {
                this.setAttribute(Dispatcher.WRAPPED_REQUEST_ATTRIBUTE, null);
            }
        }
    }

    public class ParameterRequestWrapper
    extends HttpServletRequestWrapper {
        private Fields _parameters;

        public ParameterRequestWrapper(HttpServletRequest request) {
            super(request);
            this._parameters = null;
        }

        protected Fields getParameters() {
            if (this._parameters == null) {
                String targetQuery = Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getQuery();
                ServletRequest servletRequest = this.getRequest();
                if (servletRequest instanceof ServletApiRequest) {
                    ServletApiRequest servletApiRequest = (ServletApiRequest)servletRequest;
                    Fields parameters = servletApiRequest.getParameters();
                    if (targetQuery == null) {
                        this._parameters = parameters;
                    } else {
                        this._parameters = new Fields(true);
                        UrlEncoded.decodeTo(targetQuery, this._parameters::add, UrlEncoded.ENCODING);
                        this._parameters.addAll(parameters);
                    }
                } else {
                    this._parameters = new Fields(true);
                    if (targetQuery != null) {
                        UrlEncoded.decodeTo(targetQuery, this._parameters::add, UrlEncoded.ENCODING);
                    }
                    Enumeration names = this.getRequest().getParameterNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        this._parameters.add(name, this.getRequest().getParameterValues(name));
                    }
                }
            }
            return this._parameters;
        }

        public String getQueryString() {
            String targetQuery;
            if (Dispatcher.this._uri != null && !StringUtil.isEmpty(targetQuery = Dispatcher.this._uri.getQuery())) {
                return targetQuery;
            }
            return super.getQueryString();
        }

        public String getParameter(String name) {
            return this.getParameters().getValue(name);
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParameters().getNames());
        }

        public String[] getParameterValues(String name) {
            List<String> vals = this.getParameters().getValues(name);
            if (vals == null) {
                return null;
            }
            return vals.toArray(new String[0]);
        }

        public String toString() {
            return "%s@%x{%s}".formatted(TypeUtil.toShortName(((Object)((Object)this)).getClass()), ((Object)((Object)this)).hashCode(), this.getRequest());
        }
    }
}

