/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import org.sparkproject.jetty.client.Connection;
import org.sparkproject.jetty.client.Destination;
import org.sparkproject.jetty.client.MultiplexConnectionPool;
import org.sparkproject.jetty.util.ConcurrentPool;
import org.sparkproject.jetty.util.annotation.ManagedObject;

@ManagedObject
public class RoundRobinConnectionPool
extends MultiplexConnectionPool {
    public RoundRobinConnectionPool(Destination destination, int maxConnections) {
        this(destination, maxConnections, 1);
    }

    public RoundRobinConnectionPool(Destination destination, int maxConnections, int initialMaxMultiplex) {
        super(destination, () -> new ConcurrentPool<Connection>(ConcurrentPool.StrategyType.ROUND_ROBIN, maxConnections, RoundRobinConnectionPool.newMaxMultiplexer(initialMaxMultiplex)), initialMaxMultiplex);
        this.setMaximizeConnections(true);
    }
}

