/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.HttpRedirector;
import org.sparkproject.jetty.client.HttpRequestException;
import org.sparkproject.jetty.client.ProtocolHandler;
import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.client.Response;
import org.sparkproject.jetty.client.Result;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpHeader;

public class RedirectProtocolHandler
implements ProtocolHandler,
Response.Listener {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        return field.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onSuccess(Response response) {
        Request request = response.getRequest();
        if (request.getBody() != null) {
            request.abort(new HttpRequestException("Aborting request after receiving a %d response".formatted(response.getStatus()), request));
        }
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        this.redirector.redirect(request, response, null);
    }
}

