/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import scala.Function0;

public class TransientBestEffortLazyVal<T>
implements Serializable {
    private volatile Function0<T> compute;
    protected volatile transient T cached;
    private static final VarHandle HANDLE;

    public TransientBestEffortLazyVal(Function0<T> compute) {
        this.compute = compute;
    }

    public T apply() {
        T value = this.cached;
        if (value != null) {
            return value;
        }
        Object newValue = this.compute.apply();
        assert (newValue != null) : "compute function cannot return null.";
        HANDLE.compareAndSet(this, null, newValue);
        return this.cached;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.cached = null;
    }

    static {
        try {
            HANDLE = MethodHandles.lookup().in(TransientBestEffortLazyVal.class).findVarHandle(TransientBestEffortLazyVal.class, "cached", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to initialize VarHandle", e);
        }
    }
}

