/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.MemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a!\u0002\t\u0012\u0001EI\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u00119\u0002!\u0011!Q\u0001\n=BQA\r\u0001\u0005\u0002MBaa\u000e\u0001!B\u0013A\u0004\"B&\u0001\t\u0003b\u0005\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0003O\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005^\u0001\u0001\u0007\t\u0011)Q\u0005\u001f\")a\f\u0001C\u0001\u001d\")q\f\u0001C\u0003A\")1\r\u0001C\u0001I\")1\r\u0001C\u0001a\")a\u000f\u0001C\u0001o\")!\u0010\u0001C\u0001w\")A\u0010\u0001C\u0001{\n\t2\u000b^8sC\u001e,W*Z7pef\u0004vn\u001c7\u000b\u0005I\u0019\u0012AB7f[>\u0014\u0018P\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h'\r\u0001!D\b\t\u00037qi\u0011!E\u0005\u0003;E\u0011!\"T3n_JL\bk\\8m!\ty\"%D\u0001!\u0015\t\t3#\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\t1|7m[\u0002\u0001!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u00142kK\u000e$\u0018AC7f[>\u0014\u00180T8eKB\u00111\u0004M\u0005\u0003cE\u0011!\"T3n_JLXj\u001c3f\u0003\u0019a\u0014N\\5u}Q\u0019A'\u000e\u001c\u0011\u0005m\u0001\u0001\"\u0002\u0013\u0004\u0001\u00041\u0003\"\u0002\u0018\u0004\u0001\u0004y\u0013aC0nK6|'/_+tK\u0012\u0004\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012A\u0001T8oO\"\"AaP%K!\t\u0001u)D\u0001B\u0015\t\u00115)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001R#\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0001G\u0003\u0015Q\u0017M^1y\u0013\tA\u0015IA\u0005Hk\u0006\u0014H-\u001a3Cs\u0006)a/\u00197vK\u0006\nA%\u0001\u0006nK6|'/_+tK\u0012,\u0012\u0001O\u0001\r?6,Wn\u001c:z'R|'/Z\u000b\u0002\u001fB\u0011\u0001\u000bV\u0007\u0002#*\u0011!C\u0015\u0006\u0003'N\tqa\u001d;pe\u0006<W-\u0003\u0002V#\nYQ*Z7pef\u001cFo\u001c:f\u0003AyV.Z7pef\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011\u0011(W\u0005\u00035j\u0012A!\u00168ji\"9AlBA\u0001\u0002\u0004y\u0015a\u0001=%c\u0005iq,\\3n_JL8\u000b^8sK\u0002\n1\"\\3n_JL8\u000b^8sK\u0006q1/\u001a;NK6|'/_*u_J,GC\u0001-b\u0011\u0015\u0011'\u00021\u0001P\u0003\u0015\u0019Ho\u001c:f\u00035\t7-];je\u0016lU-\\8ssR\u0019Q\r\u001b8\u0011\u0005e2\u0017BA4;\u0005\u001d\u0011un\u001c7fC:DQ![\u0006A\u0002)\fqA\u00197pG.LE\r\u0005\u0002lY6\t!+\u0003\u0002n%\n9!\t\\8dW&#\u0007\"B8\f\u0001\u0004A\u0014\u0001\u00038v[\nKH/Z:\u0015\t\u0015\f(\u000f\u001e\u0005\u0006S2\u0001\rA\u001b\u0005\u0006g2\u0001\r\u0001O\u0001\u0012]Vl')\u001f;fgR{\u0017iY9vSJ,\u0007\"B;\r\u0001\u0004A\u0014A\u00048v[\nKH/Z:U_\u001a\u0013X-Z\u0001\u000ee\u0016dW-Y:f\u001b\u0016lwN]=\u0015\u0005aC\b\"B=\u000e\u0001\u0004A\u0014\u0001B:ju\u0016\f\u0001C]3mK\u0006\u001cX-\u00117m\u001b\u0016lwN]=\u0015\u0003a\u000bQC\u001a:fKN\u0003\u0018mY3U_NC'/\u001b8l!>|G\u000e\u0006\u00029}\")qp\u0004a\u0001q\u0005Y1\u000f]1dKR{gI]3f\u0001")
public class StorageMemoryPool
extends MemoryPool
implements Logging {
    private final Object lock;
    private final MemoryMode memoryMode;
    @GuardedBy(value="lock")
    private long _memoryUsed;
    private MemoryStore _memoryStore;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public long memoryUsed() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            l = this._memoryUsed;
        }
        return l;
    }

    private MemoryStore _memoryStore() {
        return this._memoryStore;
    }

    private void _memoryStore_$eq(MemoryStore x$1) {
        this._memoryStore = x$1;
    }

    public MemoryStore memoryStore() {
        if (this._memoryStore() == null) {
            throw SparkException$.MODULE$.internalError("memory store not initialized yet", "MEMORY");
        }
        return this._memoryStore();
    }

    public final void setMemoryStore(MemoryStore store) {
        this._memoryStore_$eq(store);
    }

    public boolean acquireMemory(BlockId blockId, long numBytes) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            long numBytesToFree = package$.MODULE$.max(0L, numBytes - this.memoryFree());
            bl = this.acquireMemory(blockId, numBytes, numBytesToFree);
        }
        return bl;
    }

    public boolean acquireMemory(BlockId blockId, long numBytesToAcquire, long numBytesToFree) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            boolean enoughMemory;
            Predef$.MODULE$.assert(numBytesToAcquire >= 0L);
            Predef$.MODULE$.assert(numBytesToFree >= 0L);
            Predef$.MODULE$.assert(this.memoryUsed() <= this.poolSize());
            Object object2 = numBytesToFree > 0L ? BoxesRunTime.boxToLong((long)this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)new Some((Object)blockId), numBytesToFree, this.memoryMode)) : BoxedUnit.UNIT;
            boolean bl2 = enoughMemory = numBytesToAcquire <= this.memoryFree();
            if (enoughMemory) {
                this._memoryUsed += numBytesToAcquire;
            }
            bl = enoughMemory;
        }
        return bl;
    }

    public void releaseMemory(long size) {
        Object object = this.lock;
        synchronized (object) {
            if (size > this._memoryUsed) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to release ", " bytes of storage "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)size))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"memory when we only have ", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES_USED, BoxesRunTime.boxToLong((long)$this._memoryUsed))})))));
                this._memoryUsed = 0L;
            } else {
                this._memoryUsed -= size;
            }
        }
    }

    public void releaseAllMemory() {
        Object object = this.lock;
        synchronized (object) {
            this._memoryUsed = 0L;
        }
    }

    public long freeSpaceToShrinkPool(long spaceToFree) {
        long l;
        Object object = this.lock;
        synchronized (object) {
            long l2;
            long spaceFreedByReleasingUnusedMemory = package$.MODULE$.min(spaceToFree, this.memoryFree());
            long remainingSpaceToFree = spaceToFree - spaceFreedByReleasingUnusedMemory;
            if (remainingSpaceToFree > 0L) {
                long spaceFreedByEviction = this.memoryStore().evictBlocksToFreeSpace((Option<BlockId>)None$.MODULE$, remainingSpaceToFree, this.memoryMode);
                l2 = spaceFreedByReleasingUnusedMemory + spaceFreedByEviction;
            } else {
                l2 = spaceFreedByReleasingUnusedMemory;
            }
            l = l2;
        }
        return l;
    }

    public StorageMemoryPool(Object lock, MemoryMode memoryMode) {
        this.lock = lock;
        this.memoryMode = memoryMode;
        super(lock);
        Logging.$init$((Logging)this);
        this._memoryUsed = 0L;
    }
}

