/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.CRC32C;
import java.util.zip.CheckedOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.Checksum;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumCheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumFileCreatorInfo;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumFileCreatorInfo$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a4Aa\u0004\t\u0001?!Aa\b\u0001BC\u0002\u0013%q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003!\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011B \t\u0011-\u0003!\u0011!Q\u0001\n\u0001B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%I!\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001d\")q\u000b\u0001C\u00011\"9q\f\u0001a\u0001\n\u0013\u0001\u0007bB3\u0001\u0001\u0004%IA\u001a\u0005\u0007Y\u0002\u0001\u000b\u0015B1\t\u000bE\u0004A\u0011\t:\t\u000bM\u0004A\u0011\t:\t\u0017Q\u0004\u0001\u0013aA\u0001\u0002\u0013%!/\u001e\u0002&\u0007\",7m[:v[\u000e\u000bgnY3mY\u0006\u0014G.\u001a$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6T!!\u0005\n\u0002\u001b\rDWmY6q_&tG/\u001b8h\u0015\t\u0019B#A\u0005tiJ,\u0017-\\5oO*\u0011QCF\u0001\nKb,7-\u001e;j_:T!a\u0006\r\u0002\u0007M\fHN\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00119!\t\tSG\u0004\u0002#g9\u00111E\r\b\u0003IEr!!\n\u0019\u000f\u0005\u0019zcBA\u0014/\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,=\u00051AH]8pizJ\u0011!H\u0005\u00037qI!!\u0007\u000e\n\u0005]A\u0012BA\u000b\u0017\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011A\u0007E\u0001\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u0013\t1tGA\u000fDC:\u001cW\r\u001c7bE2,gi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0015\t!\u0004\u0003\u0005\u0002:y5\t!H\u0003\u0002<1\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002>u\t9Aj\\4hS:<\u0017AC7bS:\u001cFO]3b[V\t\u0001%A\u0006nC&t7\u000b\u001e:fC6\u0004\u0013\u0001\u00029bi\"\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0005\u0019\u001c(BA$\u001b\u0003\u0019A\u0017\rZ8pa&\u0011\u0011\n\u0012\u0002\u0005!\u0006$\b.\u0001\bdQ\u0016\u001c7n];n'R\u0014X-Y7\u0002\u001f\rDWmY6tk6\u001cFO]3b[\u0002\n\u0001#\u001e9m_\u0006$G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0016\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u0015\r|gnY;se\u0016tGOC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)\u0006K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\tR\u000f\u001d7pC\u0012$\u0006N]3bIB{w\u000e\u001c\u0011\u0002\rqJg.\u001b;?)\u0015I6\fX/_!\tQ\u0006!D\u0001\u0011\u0011\u0015q\u0004\u00021\u0001!\u0011\u0015\t\u0005\u00021\u0001C\u0011\u0015Q\u0005\u00021\u0001!\u0011\u0015a\u0005\u00021\u0001O\u0003\u0019\u0019Gn\\:fIV\t\u0011\r\u0005\u0002cG6\t!+\u0003\u0002e%\n9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0011qM\u001b\t\u0003E\"L!!\u001b*\u0003\tUs\u0017\u000e\u001e\u0005\bW*\t\t\u00111\u0001b\u0003\rAH%M\u0001\bG2|7/\u001a3!Q\tYa\u000e\u0005\u0002c_&\u0011\u0001O\u0015\u0002\tm>d\u0017\r^5mK\u000611-\u00198dK2$\u0012aZ\u0001\u0006G2|7/Z\u0001\fgV\u0004XM\u001d\u0013dY>\u001cX-\u0003\u0002tm&\u0011q\u000f\u0012\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e")
public class ChecksumCancellableFSDataOutputStream
extends CheckpointFileManager.CancellableFSDataOutputStream
implements Logging {
    private final CheckpointFileManager.CancellableFSDataOutputStream mainStream;
    private final Path path;
    private final CheckpointFileManager.CancellableFSDataOutputStream checksumStream;
    private final ExecutionContext uploadThreadPool;
    private volatile boolean closed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ void super$close() {
        super.close();
    }

    private CheckpointFileManager.CancellableFSDataOutputStream mainStream() {
        return this.mainStream;
    }

    private CheckpointFileManager.CancellableFSDataOutputStream checksumStream() {
        return this.checksumStream;
    }

    private ExecutionContext uploadThreadPool() {
        return this.uploadThreadPool;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public void cancel() {
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable)() -> this.mainStream().cancel(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checksumStream().cancel());
    }

    public void close() {
        if (!this.closed()) {
            this.closed_$eq(true);
            ChecksumFileCreatorInfo creator = ChecksumFileCreatorInfo$.MODULE$.apply();
            int chkValue = (int)((CheckedOutputStream)this.underlyingStream()).getChecksum().getValue();
            long mainFileSize = this.mainStream().getPos();
            Future mainFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$close(), this.uploadThreadPool());
            Future checksumFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String json = new Checksum("CRC32C", chkValue, mainFileSize, System.currentTimeMillis(), creator).json();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Created checksum for file ", ": ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, $this.path), this.MDC((LogKey)LogKeys.CHECKSUM, json)}))));
                this.checksumStream().write(json.getBytes(StandardCharsets.UTF_8));
                this.checksumStream().close();
            }, this.uploadThreadPool());
            ChecksumCheckpointFileManager$.MODULE$.awaitResult(mainFuture, (Duration)Duration$.MODULE$.Inf());
            ChecksumCheckpointFileManager$.MODULE$.awaitResult(checksumFuture, (Duration)Duration$.MODULE$.Inf());
            return;
        }
    }

    public ChecksumCancellableFSDataOutputStream(CheckpointFileManager.CancellableFSDataOutputStream mainStream, Path path, CheckpointFileManager.CancellableFSDataOutputStream checksumStream, ExecutionContext uploadThreadPool) {
        this.mainStream = mainStream;
        this.path = path;
        this.checksumStream = checksumStream;
        this.uploadThreadPool = uploadThreadPool;
        super(new CheckedOutputStream((OutputStream)((Object)mainStream), new CRC32C()));
        Logging.$init$((Logging)this);
        this.closed = false;
    }
}

