/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.execution;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkEnv$;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteResponseObserver;
import org.apache.spark.sql.connect.execution.SparkConnectPlanExecution$;
import org.apache.spark.sql.connect.planner.InvalidInputErrors$;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.utils.MetricGenerator$;
import org.apache.spark.sql.connect.utils.PipelineAnalysisContextUtils$;
import org.apache.spark.sql.execution.DoNotCleanup$;
import org.apache.spark.sql.execution.LocalTableScanExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.RemoveShuffleFiles$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ShuffleCleanupMode;
import org.apache.spark.sql.execution.SkipMigration$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.arrow.ArrowConverters;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.ByteString;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg!B\t\u0013\u0001Iq\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b5\u0002A\u0011\u0001\u0018\t\u000fI\u0002!\u0019!C\u0005g!1q\u0007\u0001Q\u0001\nQBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!\tAQ\u0003\u0005%\u0002\u00011\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\u001d9\u0011q\u0010\n\t\u0002\u0005\u0005eAB\t\u0013\u0011\u0003\t\u0019\t\u0003\u0004.\u001b\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u000fkA\u0011AAE\u0011\u001d\t9,\u0004C\u0001\u0003s\u0013\u0011d\u00159be.\u001cuN\u001c8fGR\u0004F.\u00198Fq\u0016\u001cW\u000f^5p]*\u00111\u0003F\u0001\nKb,7-\u001e;j_:T!!\u0006\f\u0002\u000f\r|gN\\3di*\u0011q\u0003G\u0001\u0004gFd'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-A\u0007fq\u0016\u001cW\u000f^3I_2$WM]\u0002\u0001!\tA3&D\u0001*\u0015\tQC#A\u0004tKJ4\u0018nY3\n\u00051J#!D#yK\u000e,H/\u001a%pY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u0003IAQ!\n\u0002A\u0002\u001d\nQb]3tg&|g\u000eS8mI\u0016\u0014X#\u0001\u001b\u0011\u0005!*\u0014B\u0001\u001c*\u00055\u0019Vm]:j_:Du\u000e\u001c3fe\u0006q1/Z:tS>t\u0007j\u001c7eKJ\u0004\u0013aB:fgNLwN\\\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QHF\u0001\bG2\f7o]5d\u0013\tyDH\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003)A\u0017M\u001c3mKBc\u0017M\u001c\u000b\u0003\u0007\u001a\u0003\"\u0001\t#\n\u0005\u0015\u000b#\u0001B+oSRDQaR\u0004A\u0002!\u000b\u0001C]3ta>t7/Z(cg\u0016\u0014h/\u001a:\u0011\u0007AJ5*\u0003\u0002K%\t9R\t_3dkR,'+Z:q_:\u001cXm\u00142tKJ4XM\u001d\t\u0003\u0019Bk\u0011!\u0014\u0006\u0003\u001d>\u000bQ\u0001\u001d:pi>T!!\u0006\r\n\u0005Ek%aE#yK\u000e,H/\u001a)mC:\u0014Vm\u001d9p]N,'!\u0002\"bi\u000eD\u0007\u0003\u0002\u0011U-rK!!V\u0011\u0003\rQ+\b\u000f\\33!\r\u0001s+W\u0005\u00031\u0006\u0012Q!\u0011:sCf\u0004\"\u0001\t.\n\u0005m\u000b#\u0001\u0002\"zi\u0016\u0004\"\u0001I/\n\u0005y\u000b#\u0001\u0002'p]\u001e\f1C]8x)>\f%O]8x\u0007>tg/\u001a:uKJ$B\"Y=\u0002\u0004\u00055\u0011\u0011CA\u0013\u0003_\u0001B\u0001\t2em&\u00111-\t\u0002\n\rVt7\r^5p]F\u00022!Z7q\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002jM\u00051AH]8pizJ\u0011AI\u0005\u0003Y\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002o_\nA\u0011\n^3sCR|'O\u0003\u0002mCA\u0011\u0011\u000f^\u0007\u0002e*\u00111OF\u0001\tG\u0006$\u0018\r\\=ti&\u0011QO\u001d\u0002\f\u0013:$XM\u001d8bYJ{w\u000fE\u0002f[^\u0004\"\u0001\u001f\u0005\u000e\u0003\u0001AQA_\u0005A\u0002m\faa]2iK6\f\u0007C\u0001?\u0000\u001b\u0005i(B\u0001@\u0017\u0003\u0015!\u0018\u0010]3t\u0013\r\t\t! \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0003\u0013\u0001\u0007\u0011qA\u0001\u0013[\u0006D(+Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007\u000eE\u0002!\u0003\u0013I1!a\u0003\"\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u001fI\u0001\u0019\u0001/\u0002\u00195\f\u0007PQ1uG\"\u001c\u0016N_3\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016\u0005QA/[7f5>tW-\u00133\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002hC%\u0019\u0011QD\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"\t\u0005\b\u0003OI\u0001\u0019AA\u0015\u0003m)'O]8s\u001f:$U\u000f\u001d7jG\u0006$X\r\u001a$jK2$g*Y7fgB\u0019\u0001%a\u000b\n\u0007\u00055\u0012EA\u0004C_>dW-\u00198\t\u000f\u0005E\u0012\u00021\u0001\u0002*\u0005iA.\u0019:hKZ\u000b'\u000fV=qKN\fQ\u0003\u001d:pG\u0016\u001c8/Q:BeJ|wOQ1uG\",7\u000fF\u0004D\u0003o\tY&!\u001d\t\u000f\u0005e\"\u00021\u0001\u0002<\u0005IA-\u0019;bMJ\fW.\u001a\t\u0005\u0003{\t)F\u0004\u0003\u0002@\u0005Mc\u0002BA!\u0003#rA!a\u0011\u0002P9!\u0011QIA'\u001d\u0011\t9%a\u0013\u000f\u0007\u001d\fI%C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003{YI!\u0001\u001c\u001f\n\t\u0005]\u0013\u0011\f\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001\u001c\u001f\t\r\u001dS\u0001\u0019AA/!\u0015\ty&!\u001cL\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001B:uk\nTA!a\u001a\u0002j\u0005!qM\u001d9d\u0015\t\tY'\u0001\u0002j_&!\u0011qNA1\u00059\u0019FO]3b[>\u00137/\u001a:wKJDa!a\u001d\u000b\u0001\u00049\u0013aC3yK\u000e,H/\u001a)mC:\fAc\u0019:fCR,7k\u00195f[\u0006\u0014Vm\u001d9p]N,G#B&\u0002z\u0005u\u0004bBA>\u0017\u0001\u0007\u0011QC\u0001\ng\u0016\u001c8/[8o\u0013\u0012DQA_\u0006A\u0002m\f\u0011d\u00159be.\u001cuN\u001c8fGR\u0004F.\u00198Fq\u0016\u001cW\u000f^5p]B\u0011\u0001'D\n\u0003\u001b}!\"!!!\u0002/Q|wJY:feZ,G-T3ue&\u001c7OV1mk\u0016\u001cH\u0003BAF\u0003W\u0003R!ZAG\u0003#K1!a$p\u0005\r\u0019V-\u001d\t\nA\u0005M\u0015qSAO\u0003GK1!!&\"\u0005\u0019!V\u000f\u001d7fgA)\u0001%!'\u0002\u0016%\u0019\u00111T\u0011\u0003\r=\u0003H/[8o!\r\u0001\u0013qT\u0005\u0004\u0003C\u000b#aA!osB)\u0001%!'\u0002&B\u0019A0a*\n\u0007\u0005%VP\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tik\u0004a\u0001\u0003_\u000b1A]8x!\u0011\t\t,a-\u000e\u0003YI1!!.\u0017\u0005\r\u0011vn^\u0001\u001eGJ,\u0017\r^3PEN,'O^3e\u001b\u0016$(/[2t%\u0016\u001c\bo\u001c8tKRI1*a/\u0002>\u0006\u0005\u00171\u001a\u0005\b\u0003w\u0002\u0002\u0019AA\u000b\u0011\u001d\ty\f\u0005a\u0001\u0003+\tqb]3sm\u0016\u00148+Z:tS>t\u0017\n\u001a\u0005\b\u0003\u0007\u0004\u0002\u0019AAc\u0003Uy'm]3sm\u0006$\u0018n\u001c8B]\u0012\u0004F.\u00198JIN\u0004r!a\u0006\u0002H\u0006UA,\u0003\u0003\u0002J\u0006\r\"aA'ba\"9\u0011Q\u001a\tA\u0002\u0005=\u0017aB7fiJL7m\u001d\t\t\u0003/\t9-!\u0006\u0002\f\u0002")
public class SparkConnectPlanExecution {
    private final ExecuteHolder executeHolder;
    private final SessionHolder sessionHolder;
    private final SparkSession session;

    public static ExecutePlanResponse createObservedMetricsResponse(String sessionId, String serverSessionId, Map<String, Object> observationAndPlanIds, Map<String, Seq<Tuple3<Option<String>, Object, Option<DataType>>>> metrics) {
        return SparkConnectPlanExecution$.MODULE$.createObservedMetricsResponse(sessionId, serverSessionId, observationAndPlanIds, metrics);
    }

    public static Seq<Tuple3<Option<String>, Object, Option<DataType>>> toObservedMetricsValues(Row row) {
        return SparkConnectPlanExecution$.MODULE$.toObservedMetricsValues(row);
    }

    private SessionHolder sessionHolder() {
        return this.sessionHolder;
    }

    private SparkSession session() {
        return this.session;
    }

    public void handlePlan(ExecuteResponseObserver<ExecutePlanResponse> responseObserver) {
        ExecutePlanRequest request = this.executeHolder.request();
        SparkConnectPlanner planner = new SparkConnectPlanner(this.executeHolder);
        QueryPlanningTracker tracker = this.executeHolder.eventsManager().createQueryPlanningTracker();
        SQLConf conf = this.session().sessionState().conf();
        RemoveShuffleFiles$ shuffleCleanupMode = BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.CONNECT_SHUFFLE_DEPENDENCY_FILE_CLEANUP_ENABLED())) ? RemoveShuffleFiles$.MODULE$ : (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.SHUFFLE_DEPENDENCY_SKIP_MIGRATION_ENABLED())) ? SkipMigration$.MODULE$ : DoNotCleanup$.MODULE$);
        UserContext userContext = request.getUserContext();
        if (PipelineAnalysisContextUtils$.MODULE$.isUnsupportedEagerExecutionInsideFlowFunction(userContext, request.getPlan())) {
            throw new AnalysisException("ATTEMPT_ANALYSIS_IN_PIPELINE_QUERY_FUNCTION", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        }
        Plan.OpTypeCase opTypeCase = request.getPlan().getOpTypeCase();
        if (Plan.OpTypeCase.ROOT.equals(opTypeCase)) {
            org.apache.spark.sql.classic.Dataset dataframe = Dataset$.MODULE$.ofRows(this.sessionHolder().session(), planner.transformRelation(request.getPlan().getRoot(), true), tracker, (ShuffleCleanupMode)shuffleCleanupMode);
            responseObserver.onNext(this.createSchemaResponse(request.getSessionId(), dataframe.schema()));
            this.processAsArrowBatches((org.apache.spark.sql.classic.Dataset<Row>)dataframe, responseObserver, this.executeHolder);
            responseObserver.onNext(MetricGenerator$.MODULE$.createMetricsResponse(this.sessionHolder(), (Dataset<Row>)dataframe));
            return;
        }
        if (Plan.OpTypeCase.COMMAND.equals(opTypeCase)) {
            Command command = request.getPlan().getCommand();
            Option<Function1<QueryPlanningTracker, LogicalPlan>> option = planner.transformCommand(command);
            if (option instanceof Some) {
                Some some = (Some)option;
                Function1 transformer = (Function1)some.value();
                SparkSession x$1 = this.session();
                LogicalPlan x$2 = (LogicalPlan)transformer.apply((Object)tracker);
                QueryPlanningTracker x$3 = tracker;
                Some x$4 = new Some((Object)shuffleCleanupMode);
                Enumeration.Value x$5 = QueryExecution$.MODULE$.$lessinit$greater$default$4();
                boolean x$6 = QueryExecution$.MODULE$.$lessinit$greater$default$6();
                UUID x$7 = QueryExecution$.MODULE$.$lessinit$greater$default$7();
                QueryExecution qe = new QueryExecution(x$1, x$2, x$3, x$5, (Option)x$4, x$6, x$7);
                qe.assertCommandExecuted();
                this.executeHolder.eventsManager().postFinished(this.executeHolder.eventsManager().postFinished$default$1(), this.executeHolder.eventsManager().postFinished$default$2());
            } else if (None$.MODULE$.equals(option)) {
                planner.process(command, responseObserver);
            } else {
                throw new MatchError(option);
            }
            return;
        }
        throw InvalidInputErrors$.MODULE$.invalidOneOfField(opTypeCase, request.getPlan().getDescriptorForType());
    }

    public Function1<Iterator<InternalRow>, Iterator<Tuple2<byte[], Object>>> rowToArrowConverter(StructType schema, int maxRecordsPerBatch, long maxBatchSize, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return (Function1 & Serializable)rows -> {
            ArrowConverters.ArrowBatchWithSchemaIterator batches = ArrowConverters$.MODULE$.toBatchWithSchemaIterator(rows, schema, (long)maxRecordsPerBatch, maxBatchSize, timeZoneId, errorOnDuplicatedFieldNames, largeVarTypes);
            return batches.map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b), (Object)BoxesRunTime.boxToLong((long)batches.rowCountInLastBatch())));
        };
    }

    public void processAsArrowBatches(org.apache.spark.sql.classic.Dataset<Row> dataframe, StreamObserver<ExecutePlanResponse> responseObserver, ExecuteHolder executePlan) {
        String sessionId = executePlan.sessionHolder().sessionId();
        SparkSession spark = dataframe.sparkSession();
        StructType schema = dataframe.schema();
        TypeUtils$.MODULE$.failUnsupportedDataType((DataType)schema, spark.sessionState().conf());
        int maxRecordsPerBatch = spark.sessionState().conf().arrowMaxRecordsPerBatch();
        String timeZoneId = spark.sessionState().conf().sessionLocalTimeZone();
        boolean largeVarTypes = spark.sessionState().conf().arrowUseLargeVarTypes();
        long maxBatchSize = (long)((double)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_ARROW_MAX_BATCH_SIZE())) * 0.7);
        boolean isResultChunkingEnabled = executePlan.resultChunkingEnabled();
        Function1<Iterator<InternalRow>, Iterator<Tuple2<byte[], Object>>> converter = this.rowToArrowConverter(schema, maxRecordsPerBatch, maxBatchSize, timeZoneId, false, largeVarTypes);
        IntRef numSent = IntRef.create((int)0);
        SparkPlan sparkPlan = dataframe.queryExecution().executedPlan();
        if (sparkPlan instanceof LocalTableScanExec) {
            LocalTableScanExec localTableScanExec = (LocalTableScanExec)sparkPlan;
            Seq rows = localTableScanExec.rows();
            executePlan.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)rows.length())), executePlan.eventsManager().postFinished$default$2());
            LongRef offset = LongRef.create((long)0L);
            ((IterableOnceOps)converter.apply((Object)rows.iterator())).foreach((Function1 & Serializable)x0$1 -> {
                SparkConnectPlanExecution.$anonfun$processAsArrowBatches$2(this, offset, sessionId, isResultChunkingEnabled, executePlan, spark, responseObserver, numSent, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            SQLExecution$.MODULE$.withNewExecutionId(dataframe.queryExecution(), (Option)new Some((Object)"collectArrow"), (Function0 & Serializable)() -> {
                RDD rows = dataframe.queryExecution().executedPlan().execute();
                int numPartitions = rows.getNumPartitions();
                if (numPartitions > 0) {
                    RDD batches = rows.mapPartitionsInternal(converter, rows.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                    Object signal = new Object();
                    Tuple2[][] partitions = new Tuple2[numPartitions][];
                    IntRef numFinishedPartitions = IntRef.create((int)0);
                    LongRef totalNumRows = LongRef.create((long)0L);
                    ObjectRef error = ObjectRef.create((Object)None$.MODULE$);
                    Function2 & Serializable resultHandler = (Function2 & Serializable)(partitionId, partition) -> {
                        SparkConnectPlanExecution.$anonfun$processAsArrowBatches$4(signal, partitions, totalNumRows, numFinishedPartitions, numPartitions, executePlan, BoxesRunTime.unboxToInt((Object)partitionId), partition);
                        return BoxedUnit.UNIT;
                    };
                    Future future = spark.sparkContext().submitJob(batches, (Function1 & Serializable)iter -> (Tuple2[])iter.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), (Seq)scala.package$.MODULE$.Seq().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)numPartitions), (Integral)Numeric.IntIsIntegral$.MODULE$), (Function2)resultHandler, (Function0 & Serializable)() -> (JFunction0.mcV.sp & Serializable)() -> {}).andThen((PartialFunction)new Serializable(null, signal, error){
                        private static final long serialVersionUID = 0L;
                        private final Object signal$1;
                        private final ObjectRef error$1;

                        public final <A1 extends Try<Function0<BoxedUnit>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof Success) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof Failure) {
                                Failure failure = (Failure)A1;
                                Throwable throwable = failure.exception();
                                Object object = this.signal$1;
                                synchronized (object) {
                                    this.error$1.elem = new Some((Object)throwable);
                                    this.signal$1.notify();
                                }
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Try<Function0<BoxedUnit>> x1) {
                            Try<Function0<BoxedUnit>> try_ = x1;
                            if (try_ instanceof Success) {
                                return true;
                            }
                            return try_ instanceof Failure;
                        }
                        {
                            this.signal$1 = signal$1;
                            this.error$1 = error$1;
                        }
                    }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                    LongRef currentOffset = LongRef.create((long)0L);
                    for (int currentPartitionId = 0; currentPartitionId < numPartitions; ++currentPartitionId) {
                        Tuple2[] tuple2Array;
                        Object object = signal;
                        synchronized (object) {
                            Tuple2[] part = partitions[currentPartitionId];
                            while (part == null && ((Option)error.elem).isEmpty()) {
                                signal.wait();
                                part = partitions[currentPartitionId];
                            }
                            partitions[currentPartitionId] = null;
                            ((Option)error.elem).foreach((Function1 & Serializable)other -> {
                                throw other;
                            });
                            tuple2Array = part;
                        }
                        Tuple2[] partition2 = tuple2Array;
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partition2), (Function1 & Serializable)x0$2 -> {
                            SparkConnectPlanExecution.$anonfun$processAsArrowBatches$10(this, currentOffset, sessionId, isResultChunkingEnabled, executePlan, spark, responseObserver, numSent, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    return ThreadUtils$.MODULE$.awaitReady((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                executePlan.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)), executePlan.eventsManager().postFinished$default$2());
                return BoxedUnit.UNIT;
            });
        }
        if (numSent.elem == 0) {
            this.sendBatch$1(ArrowConverters$.MODULE$.createEmptyArrowBatch(schema, timeZoneId, false, largeVarTypes), 0L, 0L, sessionId, isResultChunkingEnabled, executePlan, spark, responseObserver, numSent);
            return;
        }
    }

    private ExecutePlanResponse createSchemaResponse(String sessionId, StructType schema) {
        return ExecutePlanResponse.newBuilder().setSessionId(sessionId).setServerSideSessionId(this.sessionHolder().serverSessionId()).setSchema(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)schema, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())).build();
    }

    private final ExecutePlanResponse.Builder newExecutePlanResponseBuilder$1(String sessionId$1) {
        return ExecutePlanResponse.newBuilder().setSessionId(sessionId$1).setServerSideSessionId(this.sessionHolder().serverSessionId());
    }

    private final void sendBatch$1(byte[] bytes, long count, long startOffset, String sessionId$1, boolean isResultChunkingEnabled$1, ExecuteHolder executePlan$1, SparkSession spark$1, StreamObserver responseObserver$1, IntRef numSent$1) {
        if (isResultChunkingEnabled$1) {
            Some some;
            int preferred;
            Option<Object> option = executePlan$1.preferredArrowChunkSize();
            int maxChunkSize = option instanceof Some && (preferred = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 1024 && (long)preferred <= BoxesRunTime.unboxToLong((Object)spark$1.conf().get(Connect$.MODULE$.CONNECT_SESSION_RESULT_CHUNKING_MAX_CHUNK_SIZE())) ? preferred : (int)BoxesRunTime.unboxToLong((Object)spark$1.conf().get(Connect$.MODULE$.CONNECT_SESSION_RESULT_CHUNKING_MAX_CHUNK_SIZE()));
            int numChunks = (bytes.length + maxChunkSize - 1) / maxChunkSize;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numChunks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                int from = i * maxChunkSize;
                int to = package$.MODULE$.min(from + maxChunkSize, bytes.length);
                int length = to - from;
                ExecutePlanResponse.Builder response = this.newExecutePlanResponseBuilder$1(sessionId$1);
                ExecutePlanResponse.ArrowBatch batch = ExecutePlanResponse.ArrowBatch.newBuilder().setRowCount(count).setData(ByteString.copyFrom(bytes, from, length)).setStartOffset(startOffset).setChunkIndex(i).setNumChunksInBatch(numChunks).build();
                response.setArrowBatch(batch);
                responseObserver$1.onNext(response.build());
            });
        } else {
            ExecutePlanResponse.Builder response = this.newExecutePlanResponseBuilder$1(sessionId$1);
            ExecutePlanResponse.ArrowBatch batch = ExecutePlanResponse.ArrowBatch.newBuilder().setRowCount(count).setData(ByteString.copyFrom(bytes)).setStartOffset(startOffset).build();
            response.setArrowBatch(batch);
            responseObserver$1.onNext(response.build());
        }
        ++numSent$1.elem;
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$2(SparkConnectPlanExecution $this, LongRef offset$1, String sessionId$1, boolean isResultChunkingEnabled$1, ExecuteHolder executePlan$1, SparkSession spark$1, StreamObserver responseObserver$1, IntRef numSent$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            byte[] bytes = (byte[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            $this.sendBatch$1(bytes, count, offset$1.elem, sessionId$1, isResultChunkingEnabled$1, executePlan$1, spark$1, responseObserver$1, numSent$1);
            offset$1.elem += count;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$4(Object signal$1, Tuple2[][] partitions$1, LongRef totalNumRows$1, IntRef numFinishedPartitions$1, int numPartitions$1, ExecuteHolder executePlan$1, int partitionId, Tuple2[] partition) {
        Object object = signal$1;
        synchronized (object) {
            partitions$1[partitionId] = partition;
            totalNumRows$1.elem += BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partition), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._2$mcJ$sp()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            ++numFinishedPartitions$1.elem;
            if (numFinishedPartitions$1.elem == numPartitions$1) {
                executePlan$1.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)totalNumRows$1.elem)), executePlan$1.eventsManager().postFinished$default$2());
            }
            signal$1.notify();
        }
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$10(SparkConnectPlanExecution $this, LongRef currentOffset$1, String sessionId$1, boolean isResultChunkingEnabled$1, ExecuteHolder executePlan$1, SparkSession spark$1, StreamObserver responseObserver$1, IntRef numSent$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            byte[] bytes = (byte[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            $this.sendBatch$1(bytes, count, currentOffset$1.elem, sessionId$1, isResultChunkingEnabled$1, executePlan$1, spark$1, responseObserver$1, numSent$1);
            currentOffset$1.elem += count;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public SparkConnectPlanExecution(ExecuteHolder executeHolder) {
        this.executeHolder = executeHolder;
        this.sessionHolder = executeHolder.sessionHolder();
        this.session = executeHolder.session();
    }
}

