/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.FMClassificationModel$;
import org.apache.spark.ml.classification.FMClassificationModel$FMClassificationModelReader$;
import org.apache.spark.ml.classification.FMClassificationModel$FMClassificationModelWriter$;
import org.apache.spark.ml.classification.FMClassificationSummary;
import org.apache.spark.ml.classification.FMClassificationSummaryImpl;
import org.apache.spark.ml.classification.FMClassificationTrainingSummary;
import org.apache.spark.ml.classification.FMClassificationTrainingSummaryImpl;
import org.apache.spark.ml.classification.FMClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUe\u0001B$I\u0001MC\u0001B\u001c\u0001\u0003\u0006\u0004%\te\u001c\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\nAD!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\n\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003G\u0001!Q1A\u0005\u0002\u0005\u0015\u0002\"CA\u0015\u0001\t\u0005\t\u0015!\u0003Y\u0011)\ti\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003s\u0001!\u0011!Q\u0001\n\u0005E\u0002\u0002CA\u001f\u0001\u0011\u0005\u0001*a\u0010\t\u0011\u0005u\u0002\u0001\"\u0001K\u0003#B\u0011\"a\u0015\u0001\u0005\u0004%\t%!\u0016\t\u0011\u0005}\u0003\u0001)A\u0005\u0003/B\u0011\"a\u0019\u0001\u0005\u0004%\t%!\u0016\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003/Bq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u00111\u0017\u0001\u0005R\u0005U\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\tY\u000e\u0001C!\u0003;Dq!a:\u0001\t\u0003\nI\u000f\u0003\u0005\u0002l\u0002!\t\u0001TAw\u0011!\u0011Y\u0001\u0001C!\u0019\n5\u0001\u0002\u0003B\n\u0001\u0011\u0005CJ!\u0006\b\u000f\tm\u0002\n#\u0001\u0003>\u00191q\t\u0013E\u0001\u0005\u007fAq!!\u0010\u001c\t\u0003\u0011iFB\u0004\u0003`m\u0001%J!\u0019\t\u0015\u0005EQD!f\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002 u\u0011\t\u0012)A\u0005\u0003+A!\"a\t\u001e\u0005+\u0007I\u0011AA\u0013\u0011%\tI#\bB\tB\u0003%\u0001\f\u0003\u0006\u0002.u\u0011)\u001a!C\u0001\u0003_A!\"!\u000f\u001e\u0005#\u0005\u000b\u0011BA\u0019\u0011\u001d\ti$\bC\u0001\u0005oB\u0011\"a/\u001e\u0003\u0003%\tAa!\t\u0013\t-U$%A\u0005\u0002\t5\u0005\"\u0003BQ;E\u0005I\u0011\u0001BR\u0011%\u00119+HI\u0001\n\u0003\u0011I\u000bC\u0005\u0003.v\t\t\u0011\"\u0011\u00030\"I!1X\u000f\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0005{k\u0012\u0011!C\u0001\u0005\u007fC\u0011B!2\u001e\u0003\u0003%\tEa2\t\u0013\tUW$!A\u0005\u0002\t]\u0007\"\u0003Bq;\u0005\u0005I\u0011\tBr\u0011%\u00119/HA\u0001\n\u0003\u0012I\u000fC\u0005\u0002hv\t\t\u0011\"\u0011\u0003l\"I!Q^\u000f\u0002\u0002\u0013\u0005#q^\u0004\u000b\u0005g\\\u0012\u0011!E\u0001\u0015\nUhA\u0003B07\u0005\u0005\t\u0012\u0001&\u0003x\"9\u0011QH\u001a\u0005\u0002\r\u0015\u0001\"CAtg\u0005\u0005IQ\tBv\u0011%\u00199aMA\u0001\n\u0003\u001bI\u0001C\u0005\u0004\u0012M\n\t\u0011\"!\u0004\u0014!I1QE\u001a\u0002\u0002\u0013%1q\u0005\u0005\t\u0007_YB\u0011\u0001&\u00042!A1\u0011I\u000e\u0005\u0002)\u001b\u0019\u0005C\u0004\u0004Pm!\te!\u0015\t\u000f\rm3\u0004\"\u0011\u0004^\u0019911M\u000e\u00017\r\u0015\u0004\"CB:{\t\u0005\t\u0015!\u0003_\u0011\u001d\ti$\u0010C\u0001\u0007kBqaa\u001f>\t#\u001aiH\u0002\u0004\u0004\u0002n!11\u0011\u0005\b\u0003{\tE\u0011ABC\u0011%\u0019I)\u0011b\u0001\n\u0013\u0011y\u000b\u0003\u0005\u0004\f\u0006\u0003\u000b\u0011\u0002BY\u0011\u001d\u0019Y&\u0011C!\u0007\u001bC\u0011b!\n\u001c\u0003\u0003%Iaa\n\u0003+\u0019k5\t\\1tg&4\u0017nY1uS>tWj\u001c3fY*\u0011\u0011JS\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tYE*\u0001\u0002nY*\u0011QJT\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fB\u000ba!\u00199bG\",'\"A)\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001!vL\u00195\u0011\tU3\u0006LX\u0007\u0002\u0011&\u0011q\u000b\u0013\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\u0015\u00061A.\u001b8bY\u001eL!!\u0018.\u0003\rY+7\r^8s!\t)\u0006\u0001\u0005\u0002VA&\u0011\u0011\r\u0013\u0002\u0013\r6\u001bE.Y:tS\u001aLWM\u001d)be\u0006l7\u000f\u0005\u0002dM6\tAM\u0003\u0002f\u0015\u0006!Q\u000f^5m\u0013\t9GM\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u00042aY5l\u0013\tQGM\u0001\nICN$&/Y5oS:<7+^7nCJL\bCA+m\u0013\ti\u0007JA\u0010G\u001b\u000ec\u0017m]:jM&\u001c\u0017\r^5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7bef\f1!^5e+\u0005\u0001\bCA9{\u001d\t\u0011\b\u0010\u0005\u0002tm6\tAO\u0003\u0002v%\u00061AH]8pizR\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\fa\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011P\u001e\u0015\u0005\u0003y\fI\u0001E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA*\u0001\u0006b]:|G/\u0019;j_:LA!a\u0002\u0002\u0002\t)1+\u001b8dK\u0006\u0012\u00111B\u0001\u0006g9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005\u000b\u0003\u0003}\u0006%\u0011!C5oi\u0016\u00148-\u001a9u+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"\u0001<\n\u0007\u0005maO\u0001\u0004E_V\u0014G.\u001a\u0015\u0005\u0007y\fI!\u0001\u0006j]R,'oY3qi\u0002BC\u0001\u0002@\u0002\n\u00051A.\u001b8fCJ,\u0012\u0001\u0017\u0015\u0005\u000by\fI!A\u0004mS:,\u0017M\u001d\u0011)\t\u0019q\u0018\u0011B\u0001\bM\u0006\u001cGo\u001c:t+\t\t\t\u0004E\u0002Z\u0003gI1!!\u000e[\u0005\u0019i\u0015\r\u001e:jq\"\"qA`A\u0005\u0003!1\u0017m\u0019;peN\u0004\u0003\u0006\u0002\u0005\u007f\u0003\u0013\ta\u0001P5oSRtD#\u00030\u0002B\u0005\u0015\u0013\u0011JA'\u0011\u0015q\u0017\u00021\u0001qQ\u0015\t\tE`A\u0005\u0011\u001d\t\t\"\u0003a\u0001\u0003+AS!!\u0012\u007f\u0003\u0013Aa!a\t\n\u0001\u0004A\u0006&BA%}\u0006%\u0001bBA\u0017\u0013\u0001\u0007\u0011\u0011\u0007\u0015\u0006\u0003\u001br\u0018\u0011\u0002\u000b\u0002=\u0006Qa.^7DY\u0006\u001c8/Z:\u0016\u0005\u0005]\u0003\u0003BA\f\u00033J1!a\u0017w\u0005\rIe\u000e\u001e\u0015\u0005\u0017y\fI!A\u0006ok6\u001cE.Y:tKN\u0004\u0003\u0006\u0002\u0007\u007f\u0003\u0013\t1B\\;n\r\u0016\fG/\u001e:fg\"\"QB`A\u0005\u00031qW/\u001c$fCR,(/Z:!Q\u0011qa0!\u0003\u0002\u000fM,X.\\1ssV\t1\u000e\u000b\u0003\u0010}\u0006E\u0014EAA:\u0003\u0015\u0019d&\r\u00181\u0003!)g/\u00197vCR,G\u0003BA=\u0003\u007f\u00022!VA>\u0013\r\ti\b\u0013\u0002\u0018\r6\u001bE.Y:tS\u001aL7-\u0019;j_:\u001cV/\\7befDq!!!\u0011\u0001\u0004\t\u0019)A\u0004eCR\f7/\u001a;1\t\u0005\u0015\u0015Q\u0013\t\u0007\u0003\u000f\u000bi)!%\u000e\u0005\u0005%%bAAF\u0019\u0006\u00191/\u001d7\n\t\u0005=\u0015\u0011\u0012\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019*!&\r\u0001\u0011a\u0011qSA@\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\n\u0019q\f\n\u001b\u0012\t\u0005m\u0015\u0011\u0015\t\u0005\u0003/\ti*C\u0002\u0002 Z\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0018\u0005\r\u0016bAASm\n\u0019\u0011I\\=)\tAq\u0018\u0011O\u0001\u000baJ,G-[2u%\u0006<Hc\u0001-\u0002.\"1\u0011qV\tA\u0002a\u000b\u0001BZ3biV\u0014Xm\u001d\u0015\u0005#y\fI!\u0001\fsC^\u0014\u0004O]8cC\nLG.\u001b;z\u0013:\u0004F.Y2f)\rA\u0016q\u0017\u0005\u0007\u0003s\u0013\u0002\u0019\u0001-\u0002\u001bI\fw\u000f\u0015:fI&\u001cG/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0007y\u000by\fC\u0004\u0002BN\u0001\r!a1\u0002\u000b\u0015DHO]1\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fT1!!3K\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ti-a2\u0003\u0011A\u000b'/Y7NCBDCa\u0005@\u0002\n\u0005iQm\u001d;j[\u0006$X\rZ*ju\u0016,\"!!6\u0011\t\u0005]\u0011q[\u0005\u0004\u000334(\u0001\u0002'p]\u001e\fQa\u001e:ji\u0016,\"!a8\u0011\u0007\r\f\t/C\u0002\u0002d\u0012\u0014\u0001\"\u0014'Xe&$XM\u001d\u0015\u0005+y\fI!\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0018!D2sK\u0006$XmU;n[\u0006\u0014\u0018\u0010\u0006\u0004\u0002p\u0006U(\u0011\u0001\t\u0005\u0003/\t\t0C\u0002\u0002tZ\u0014A!\u00168ji\"9\u0011\u0011Q\fA\u0002\u0005]\b\u0007BA}\u0003{\u0004b!a\"\u0002\u000e\u0006m\b\u0003BAJ\u0003{$A\"a@\u0002v\u0006\u0005\t\u0011!B\u0001\u00033\u00131a\u0018\u00136\u0011\u001d\u0011\u0019a\u0006a\u0001\u0005\u000b\t\u0001c\u001c2kK\u000e$\u0018N^3ISN$xN]=\u0011\r\u0005]!qAA\u000b\u0013\r\u0011IA\u001e\u0002\u0006\u0003J\u0014\u0018-_\u0001\fg\u00064XmU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002p\n=\u0001B\u0002B\t1\u0001\u0007\u0001/\u0001\u0003qCRD\u0017a\u00037pC\u0012\u001cV/\\7bef$b!a<\u0003\u0018\te\u0001B\u0002B\t3\u0001\u0007\u0001\u000fC\u0004\u0002\u0002f\u0001\rAa\u0007\u0011\t\tu!1\u0007\b\u0005\u0005?\u0011yC\u0004\u0003\u0003\"\t5b\u0002\u0002B\u0012\u0005WqAA!\n\u0003*9\u00191Oa\n\n\u0003EK!a\u0014)\n\u00055s\u0015bAAF\u0019&!!\u0011GAE\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u000e\u00038\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0005c\tI\t\u000b\u0003\u0001}\u0006%\u0011!\u0006$N\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003+n\u0019ra\u0007B!\u0005\u000f\u0012i\u0005\u0005\u0003\u0002\u0018\t\r\u0013b\u0001B#m\n1\u0011I\\=SK\u001a\u0004Ba\u0019B%=&\u0019!1\n3\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003P\teSB\u0001B)\u0015\u0011\u0011\u0019F!\u0016\u0002\u0005%|'B\u0001B,\u0003\u0011Q\u0017M^1\n\t\tm#\u0011\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005{\u0011A\u0001R1uCN9QD!\u0011\u0003d\t%\u0004\u0003BA\f\u0005KJ1Aa\u001aw\u0005\u001d\u0001&o\u001c3vGR\u0004BAa\u001b\u0003t9!!Q\u000eB9\u001d\r\u0019(qN\u0005\u0002o&\u0019!\u0011\u0007<\n\t\tm#Q\u000f\u0006\u0004\u0005c1H\u0003\u0003B=\u0005{\u0012yH!!\u0011\u0007\tmT$D\u0001\u001c\u0011\u001d\t\t\u0002\na\u0001\u0003+Aa!a\t%\u0001\u0004A\u0006bBA\u0017I\u0001\u0007\u0011\u0011\u0007\u000b\t\u0005s\u0012)Ia\"\u0003\n\"I\u0011\u0011C\u0013\u0011\u0002\u0003\u0007\u0011Q\u0003\u0005\t\u0003G)\u0003\u0013!a\u00011\"I\u0011QF\u0013\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yI\u000b\u0003\u0002\u0016\tE5F\u0001BJ!\u0011\u0011)J!(\u000e\u0005\t]%\u0002\u0002BM\u00057\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\ra/\u0003\u0003\u0003 \n]%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BSU\rA&\u0011S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YK\u000b\u0003\u00022\tE\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00032B!!1\u0017B]\u001b\t\u0011)L\u0003\u0003\u00038\nU\u0013\u0001\u00027b]\u001eL1a\u001fB[\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!)\u0003B\"I!1Y\u0016\u0002\u0002\u0003\u0007\u0011qK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t%\u0007C\u0002Bf\u0005#\f\t+\u0004\u0002\u0003N*\u0019!q\u001a<\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003T\n5'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!7\u0003`B!\u0011q\u0003Bn\u0013\r\u0011iN\u001e\u0002\b\u0005>|G.Z1o\u0011%\u0011\u0019-LA\u0001\u0002\u0004\t\t+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BY\u0005KD\u0011Ba1/\u0003\u0003\u0005\r!a\u0016\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0016\u0015\u0005\tE\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0003Z\nE\b\"\u0003Bbc\u0005\u0005\t\u0019AAQ\u0003\u0011!\u0015\r^1\u0011\u0007\tm4gE\u00034\u0005s\u0014i\u0005E\u0006\u0003|\u000e\u0005\u0011Q\u0003-\u00022\teTB\u0001B\u007f\u0015\r\u0011yP^\u0001\beVtG/[7f\u0013\u0011\u0019\u0019A!@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003v\u0006)\u0011\r\u001d9msRA!\u0011PB\u0006\u0007\u001b\u0019y\u0001C\u0004\u0002\u0012Y\u0002\r!!\u0006\t\r\u0005\rb\u00071\u0001Y\u0011\u001d\tiC\u000ea\u0001\u0003c\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0016\r\u0005\u0002CBA\f\u0007/\u0019Y\"C\u0002\u0004\u001aY\u0014aa\u00149uS>t\u0007#CA\f\u0007;\t)\u0002WA\u0019\u0013\r\u0019yB\u001e\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r\rr'!AA\u0002\te\u0014a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0006\t\u0005\u0005g\u001bY#\u0003\u0003\u0004.\tU&AB(cU\u0016\u001cG/A\u0007tKJL\u0017\r\\5{K\u0012\u000bG/\u0019\u000b\u0007\u0003_\u001c\u0019da\u000e\t\u000f\rU\u0012\b1\u0001\u0003z\u0005!A-\u0019;b\u0011\u001d\u0019I$\u000fa\u0001\u0007w\t1\u0001Z8t!\u0011\u0011ye!\u0010\n\t\r}\"\u0011\u000b\u0002\u0011\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\fq\u0002Z3tKJL\u0017\r\\5{K\u0012\u000bG/\u0019\u000b\u0005\u0005s\u001a)\u0005C\u0004\u0004Hi\u0002\ra!\u0013\u0002\u0007\u0011L7\u000f\u0005\u0003\u0003P\r-\u0013\u0002BB'\u0005#\u0012q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0005e\u0016\fG-\u0006\u0002\u0004TA!1m!\u0016_\u0013\r\u00199\u0006\u001a\u0002\t\u001b2\u0013V-\u00193fe\"\"1H`A\u0005\u0003\u0011aw.\u00193\u0015\u0007y\u001by\u0006\u0003\u0004\u0003\u0012q\u0002\r\u0001\u001d\u0015\u0005yy\fIAA\u000eG\u001b\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7Xe&$XM]\n\u0006{\u0005}7q\r\t\u0005\u0007S\u001ay'\u0004\u0002\u0004l)\u00191Q\u000e'\u0002\u0011%tG/\u001a:oC2LAa!\u001d\u0004l\t9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\r]4\u0011\u0010\t\u0004\u0005wj\u0004BBB:\u007f\u0001\u0007a,\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\tyoa \t\r\tE\u0001\t1\u0001q\u0005m1Uj\u00117bgNLg-[2bi&|g.T8eK2\u0014V-\u00193feN\u0019\u0011ia\u0015\u0015\u0005\r\u001d\u0005c\u0001B>\u0003\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004Cc\u00010\u0004\u0010\"1!\u0011C#A\u0002ADCa\u0007@\u0002\n!\"!D`A\u0005\u0001")
public class FMClassificationModel
extends ProbabilisticClassificationModel<Vector, FMClassificationModel>
implements FMClassifierParams,
MLWritable,
HasTrainingSummary<FMClassificationTrainingSummary> {
    private final String uid;
    private final double intercept;
    private final Vector linear;
    private final Matrix factors;
    private final int numClasses;
    private final int numFeatures;
    private Option<FMClassificationTrainingSummary> trainingSummary;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMClassificationModel load(String path) {
        return FMClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<FMClassificationModel> read() {
        return FMClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<FMClassificationTrainingSummary> setSummary(Option<FMClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<FMClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<FMClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double intercept() {
        return this.intercept;
    }

    public Vector linear() {
        return this.linear;
    }

    public Matrix factors() {
        return this.factors;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public FMClassificationTrainingSummary summary() {
        return (FMClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public FMClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probability = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probability, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probability2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        return new FMClassificationSummaryImpl(summaryModel2.transform(dataset), probability2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double rawPrediction = FactorizationMachines$.MODULE$.getRawPrediction(features, this.intercept(), this.linear(), this.factors());
        return Vectors$.MODULE$.dense(new double[]{-rawPrediction, rawPrediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[1] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector.values()[1]));
            denseVector.values()[0] = 1.0 - denseVector.values()[1];
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in FMClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public FMClassificationModel copy(ParamMap extra) {
        return this.copyValues(new FMClassificationModel(this.uid(), this.intercept(), this.linear(), this.factors()), extra);
    }

    @Override
    public long estimatedSize() {
        long size;
        block1: {
            size = this.estimateMatadataSize();
            if (this.linear() != null) {
                size += this.linear().getSizeInBytes();
            }
            if (this.factors() == null) break block1;
            size += this.factors().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new FMClassificationModelWriter(this);
    }

    @Override
    public String toString() {
        return "FMClassificationModel: uid=" + Identifiable.toString$(this) + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures() + ", factorSize=" + this.$(this.factorSize()) + ", fitLinear=" + this.$(this.fitLinear()) + ", fitIntercept=" + this.$(this.fitIntercept());
    }

    public void createSummary(Dataset<?> dataset, double[] objectiveHistory) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        FMClassificationTrainingSummaryImpl summary = new FMClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName, objectiveHistory);
        this.setSummary((Option<FMClassificationTrainingSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1(FMClassificationModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple1((Object)this.summary().objectiveHistory()), (Function2 & Serializable)(data, dos) -> {
            ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._1(), dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$1(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double[] objectiveHistory;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModel.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2(FMClassificationModel $outer) {
            }
        }
        Tuple1 tuple1 = (Tuple1)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> new Tuple1((Object)ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis)), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$$typecreator1$2(null)));
        if (tuple1 == null || (objectiveHistory = (double[])tuple1._1()) == null) {
            throw new MatchError((Object)tuple1);
        }
        double[] dArray = objectiveHistory;
        double[] objectiveHistory2 = dArray;
        this.createSummary(dataset, objectiveHistory2);
    }

    public FMClassificationModel(String uid, double intercept, Vector linear, Matrix factors) {
        this.uid = uid;
        this.intercept = intercept;
        this.linear = linear;
        this.factors = factors;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numClasses = 2;
        this.numFeatures = linear.size();
        Statics.releaseFence();
    }

    public FMClassificationModel() {
        this("", Double.NaN, (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    public static class Data
    implements Product,
    Serializable {
        private final double intercept;
        private final Vector linear;
        private final Matrix factors;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double intercept() {
            return this.intercept;
        }

        public Vector linear() {
            return this.linear;
        }

        public Matrix factors() {
            return this.factors;
        }

        public Data copy(double intercept, Vector linear, Matrix factors) {
            return new Data(intercept, linear, factors);
        }

        public double copy$default$1() {
            return this.intercept();
        }

        public Vector copy$default$2() {
            return this.linear();
        }

        public Matrix copy$default$3() {
            return this.factors();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
                case 1: {
                    return this.linear();
                }
                case 2: {
                    return this.factors();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "intercept";
                }
                case 1: {
                    return "linear";
                }
                case 2: {
                    return "factors";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.linear()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.factors()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            Vector vector = this.linear();
            Vector vector2 = data.linear();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Matrix matrix = this.factors();
            Matrix matrix2 = data.factors();
            if (matrix == null) {
                if (matrix2 != null) {
                    return false;
                }
            } else if (!matrix.equals(matrix2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double intercept, Vector linear, Matrix factors) {
            this.intercept = intercept;
            this.linear = linear;
            this.factors = factors;
            Product.$init$((Product)this);
        }
    }

    private static class FMClassificationModelReader
    extends MLReader<FMClassificationModel> {
        private final String className = FMClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public FMClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.FMClassificationModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4(FMClassificationModelReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> FMClassificationModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelReader$$typecreator1$4(null)));
            FMClassificationModel model = new FMClassificationModel(metadata.uid(), data.intercept(), data.linear(), data.factors());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class FMClassificationModelWriter
    extends MLWriter {
        private final FMClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.FMClassificationModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3(FMClassificationModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.intercept(), this.instance.linear(), this.instance.factors());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMClassificationModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                FMClassificationModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_FMClassificationModel$FMClassificationModelWriter$$typecreator1$3(null)));
        }

        public FMClassificationModelWriter(FMClassificationModel instance) {
            this.instance = instance;
        }
    }
}

