/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SQLOpenHashSet;
import org.apache.spark.sql.util.SQLOpenHashSet$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011!1\u0006\u0001#b\u0001\n\u00139\u0006\"\u00020\u0001\t\u0003:\u0006\u0002C0\u0001\u0011\u000b\u0007I\u0011\u00011\t\u000b9\u0004A\u0011I8\t\u000b]\u0004A\u0011\t=\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u00028!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\u001eI\u00111X\u0010\u0002\u0002#\u0005\u0011Q\u0018\u0004\t=}\t\t\u0011#\u0001\u0002@\"1\u0011\u000b\u0007C\u0001\u0003/D\u0011\"!7\u0019\u0003\u0003%)%a7\t\u0013\u0005u\u0007$!A\u0005\u0002\u0006}\u0007\"CAs1\u0005\u0005I\u0011QAt\u0011%\tI\u0010GA\u0001\n\u0013\tYP\u0001\bBeJ\f\u00170\u00138uKJ\u001cXm\u0019;\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00172i]j\u0004C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0010\u0003J\u0014\u0018-\u001f\"j]\u0006\u0014\u0018\u0010T5lKB\u0011a&N\u0005\u0003m}\u0011AdQ8na2,\u0007\u0010V=qK6+'oZ5oO\u0016C\bO]3tg&|g\u000e\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u00115&\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005!A.\u001a4u+\u0005Y\u0005C\u0001\u0018M\u0013\tiuD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"A\f\u0001\t\u000b%+\u0001\u0019A&\t\u000b=+\u0001\u0019A&\u0002!%tG/\u001a:oC2$\u0015\r^1UsB,W#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m\u001b\u0013!\u0002;za\u0016\u001c\u0018BA/[\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u001b\u00154\u0018\r\\%oi\u0016\u00148/Z2u+\u0005\t\u0007#\u0002\u001dcI\u0012$\u0017BA2:\u0005%1UO\\2uS>t'\u0007\u0005\u0002fQ6\taM\u0003\u0002hC\u0005!Q\u000f^5m\u0013\tIgMA\u0005BeJ\f\u0017\u0010R1uC\"\u0012\u0001b\u001b\t\u0003q1L!!\\\u001d\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGc\u00019tkB\u0011\u0001(]\u0005\u0003ef\u00121!\u00118z\u0011\u0015!\u0018\u00021\u0001q\u0003\u0019Ig\u000e];uc!)a/\u0003a\u0001a\u00061\u0011N\u001c9viJ\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\te|\u0018\u0011\u0002\t\u0003uvl\u0011a\u001f\u0006\u0003y~\tqaY8eK\u001e,g.\u0003\u0002\u007fw\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u0002)\u0001\r!a\u0001\u0002\u0007\r$\b\u0010E\u0002{\u0003\u000bI1!a\u0002|\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0003\u000b\u0001\u0004I\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001c9!\u0011QCA\f!\t\u0001\u0015(C\u0002\u0002\u001ae\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\rs\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006'\u0006\u0015\u0012\u0011\u0006\u0005\u0007\u0003Oa\u0001\u0019A&\u0002\u000f9,w\u000fT3gi\"1\u00111\u0006\u0007A\u0002-\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003T\u0003c\t\u0019\u0004C\u0004J\u001bA\u0005\t\u0019A&\t\u000f=k\u0001\u0013!a\u0001\u0017\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001dU\rY\u00151H\u0016\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0005v]\u000eDWmY6fI*\u0019\u0011qI\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0005\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003;\t9&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002fA\u0019\u0001(a\u001a\n\u0007\u0005%\u0014HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002q\u0003_B\u0011\"!\u001d\u0013\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\bE\u0003\u0002z\u0005}\u0004/\u0004\u0002\u0002|)\u0019\u0011QP\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0002\u0006m$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\"\u0002\u000eB\u0019\u0001(!#\n\u0007\u0005-\u0015HA\u0004C_>dW-\u00198\t\u0011\u0005ED#!AA\u0002A\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111KAJ\u0011%\t\t(FA\u0001\u0002\u0004\t)'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000bI\n\u0003\u0005\u0002rY\t\t\u00111\u0001qQM\u0001\u0011QTAR\u0003K\u000bI+a+\u00020\u0006E\u0016QWA\\!\rq\u0013qT\u0005\u0004\u0003C{\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\u000b\u00111\u0001\u0006!A}3UKT\"`Q\u0005\u0014(/Y=2Y\u0001\n'O]1ze%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011b]\u0002\n'O]1zA=4\u0007\u0005\u001e5fA\u0015dW-\\3oiN\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c;feN,7\r^5p]\u0002zg\rI1se\u0006L\u0018\u0007I1oI*\u0001\u0003\u0005\t\u0011beJ\f\u0017P\r\u0017!o&$\bn\\;uA\u0011,\b\u000f\\5dCR,7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002.\u0006)&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023'\u000b\u0017!CJ\u0014\u0018-\u001f\u00152Y\u0001\u001aD\u0006I\u001b*SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00174;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u00024\u0006Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI,A\u00033]Qr\u0003'\u0001\bBeJ\f\u00170\u00138uKJ\u001cXm\u0019;\u0011\u00059B2#\u0002\r\u0002B\u00065\u0007cBAb\u0003\u0013\\5jU\u0007\u0003\u0003\u000bT1!a2:\u0003\u001d\u0011XO\u001c;j[\u0016LA!a3\u0002F\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#TA!a5\u0002\\\u0005\u0011\u0011n\\\u0005\u0004\u000f\u0006EGCAA_\u0003!!xn\u0015;sS:<GCAA*\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u0016\u0011]Ar\u0011\u0015I5\u00041\u0001L\u0011\u0015y5\u00041\u0001L\u0003\u001d)h.\u00199qYf$B!!;\u0002vB)\u0001(a;\u0002p&\u0019\u0011Q^\u001d\u0003\r=\u0003H/[8o!\u0015A\u0014\u0011_&L\u0013\r\t\u00190\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005]H$!AA\u0002M\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u0010\u0005\u0003\u0002V\u0005}\u0018\u0002\u0002B\u0001\u0003/\u0012aa\u00142kK\u000e$\b")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
Serializable {
    private DataType internalDataType;
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final Expression left;
    private final Expression right;
    private transient scala.collection.immutable.Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect x$0) {
        return ArrayIntersect$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullIntolerant() {
        return ArrayBinaryLike.nullIntolerant$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public boolean resultArrayElementNullable() {
        return ArraySetLike.resultArrayElementNullable$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex, String functionName) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex, functionName);
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(scala.collection.immutable.Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private scala.collection.immutable.Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public scala.collection.immutable.Seq<DataType> inputTypesForMerging() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.canUseSpecializedHashSet$lzycompute();
        }
        return this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.hsPostFix$lzycompute();
        }
        return this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.hsTypeName$lzycompute();
        }
        return this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.hsValueCast$lzycompute();
        }
        return this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.nullValueHolder$lzycompute();
        }
        return this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataTypeCheck();
                this.internalDataType = new ArrayType(this.elementType(), this.leftArrayElementNullable() && this.rightArrayElementNullable());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.internalDataType$lzycompute();
        }
        return this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(array1, array2) -> {
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        int i;
                        SQLOpenHashSet<Object> hs = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                        SQLOpenHashSet<Object> hsResult = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        Function1<Object, BoxedUnit> withArray2NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                            hs.add(value);
                            return BoxedUnit.UNIT;
                        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)valueNaN -> {
                            ArrayIntersect.$anonfun$evalIntersect$3(valueNaN);
                            return BoxedUnit.UNIT;
                        });
                        Function2<ArrayData, Object, BoxedUnit> withArray2NullCheckFunc = SQLOpenHashSet$.MODULE$.withNullCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                            withArray2NaNCheckFunc.apply(value);
                            return BoxedUnit.UNIT;
                        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
                        Function1<Object, BoxedUnit> withArray1NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hsResult, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                            ArrayIntersect.$anonfun$evalIntersect$6(hs, hsResult, arrayBuffer, value);
                            return BoxedUnit.UNIT;
                        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)valueNaN -> {
                            ArrayIntersect.$anonfun$evalIntersect$7(hs, arrayBuffer, valueNaN);
                            return BoxedUnit.UNIT;
                        });
                        Function2<ArrayData, Object, BoxedUnit> withArray1NullCheckFunc = SQLOpenHashSet$.MODULE$.withNullCheckFunc(this.elementType(), hsResult, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                            withArray1NaNCheckFunc.apply(value);
                            return BoxedUnit.UNIT;
                        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (hs.containsNull()) {
                                arrayBuffer.$plus$eq(null);
                                return;
                            }
                        });
                        for (i = 0; i < array2.numElements(); ++i) {
                            withArray2NullCheckFunc.apply(array2, (Object)BoxesRunTime.boxToInteger((int)i));
                        }
                        for (i = 0; i < array1.numElements(); ++i) {
                            withArray1NullCheckFunc.apply(array1, (Object)BoxesRunTime.boxToInteger((int)i));
                        }
                        return new GenericArrayData((Seq<Object>)arrayBuffer);
                    }
                    return new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                } : (Function2 & Serializable)(array1, array2) -> {
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        boolean alreadySeenNull = false;
                        for (int i = 0; i < array1.numElements(); ++i) {
                            boolean found = false;
                            Object elem1 = array1.get(i, this.elementType());
                            if (array1.isNullAt(i)) {
                                if (!alreadySeenNull) {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        found = array2.isNullAt(j);
                                    }
                                    alreadySeenNull = true;
                                }
                            } else {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    if (array2.isNullAt(j)) continue;
                                    Object elem2 = array2.get(j, this.elementType());
                                    if (!this.ordering().equiv(elem1, elem2)) continue;
                                    boolean foundArrayBuffer = false;
                                    for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                        Object va = arrayBuffer.apply(k);
                                        foundArrayBuffer = va != null && this.ordering().equiv(va, elem1);
                                    }
                                    found = !foundArrayBuffer;
                                }
                            }
                            Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                        }
                        return new GenericArrayData((Seq<Object>)arrayBuffer);
                    }
                    return new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalIntersect;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.evalIntersect$lzycompute();
        }
        return this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = SQLOpenHashSet.class.getName();
                String classTag = "scala.reflect.ClassTag$.MODULE$." + this.hsTypeName() + "()";
                String hashSet = ctx.freshName("hashSet");
                String hashSetResult = ctx.freshName("hashSetResult");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = arrayBuilder + "$of" + ptName;
                Function2 & Serializable withArray2NaNCheckCodeGenerator = (Function2 & Serializable)(array, index) -> jt + " " + value + " = " + this.genGetValue((String)array, (String)index) + ";" + SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSet, hashSet + ".add" + this.hsPostFix() + "(" + this.hsValueCast() + value + ");", (Function1<String, String>)(Function1 & Serializable)valueNaN -> "");
                String writeArray2ToHashSet = SQLOpenHashSet$.MODULE$.withNullCheckCode(this.rightArrayElementNullable(), this.leftArrayElementNullable(), (String)array2, i, hashSet, (Function2<String, String, String>)withArray2NaNCheckCodeGenerator, "");
                String body = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (" + hashSet + ".contains(" + this.hsValueCast() + value + ") &&\n             |    !" + hashSetResult + ".contains(" + this.hsValueCast() + value + ")) {\n             |  if (++" + size + " > " + 0x7FFFFFF0 + ") {\n             |    break;\n             |  }\n             |  " + hashSetResult + ".add" + this.hsPostFix() + "(" + this.hsValueCast() + value + ");\n             |  " + builder + ".$plus$eq(" + value + ");\n             |}\n           "));
                Function2 & Serializable withArray1NaNCheckCodeGenerator = (Function2 & Serializable)(array, index) -> jt + " " + value + " = " + this.genGetValue((String)array, (String)index) + ";" + SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSetResult, body, (Function1<String, String>)(Function1 & Serializable)valueNaN -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                     |if (" + hashSet + ".containsNaN()) {\n                     |  ++" + size + ";\n                     |  " + builder + ".$plus$eq(" + valueNaN + ");\n                     |}\n                 ")));
                String processArray1 = SQLOpenHashSet$.MODULE$.withNullCheckCode(this.leftArrayElementNullable(), this.rightArrayElementNullable(), (String)array1, i, hashSetResult, (Function2<String, String, String>)withArray1NaNCheckCodeGenerator, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (" + hashSet + ".containsNull()) {\n             |  " + nullElementIndex + " = " + size + ";\n             |  " + size + "++;\n             |  " + builder + ".$plus$eq(" + this.nullValueHolder() + ");\n             |}\n           ")));
                String declareNullTrackVariables = this.resultArrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |int " + nullElementIndex + " = -1;\n           ")) : "";
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + openHashSet + " " + hashSet + " = new " + openHashSet + this.hsPostFix() + "(" + classTag + ");\n           |" + openHashSet + " " + hashSetResult + " = new " + openHashSet + this.hsPostFix() + "(" + classTag + ");\n           |" + declareNullTrackVariables + "\n           |for (int " + i + " = 0; " + i + " < " + array2 + ".numElements(); " + i + "++) {\n           |  " + writeArray2ToHashSet + "\n           |}\n           |" + arrayBuilderClass + " " + builder + " = new " + arrayBuilderClass + "();\n           |int " + size + " = 0;\n           |for (int " + i + " = 0; " + i + " < " + array1 + ".numElements(); " + i + "++) {\n           |  " + processArray1 + "\n           |}\n           |" + this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex, this.prettyName()) + "\n         "));
            });
        }
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
            String expr = ctx.addReferenceObj("arrayIntersectExpr", this, ctx.addReferenceObj$default$3());
            return ev.value() + " = (ArrayData)" + expr + ".nullSafeEval(" + array1 + ", " + array2 + ");";
        });
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    @Override
    public ArrayIntersect withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$3(Object valueNaN) {
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$6(SQLOpenHashSet hs$3, SQLOpenHashSet hsResult$1, ArrayBuffer arrayBuffer$5, Object value) {
        if (hs$3.contains(value) && !hsResult$1.contains(value)) {
            arrayBuffer$5.$plus$eq(value);
            hsResult$1.add(value);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$7(SQLOpenHashSet hs$3, ArrayBuffer arrayBuffer$5, Object valueNaN) {
        if (hs$3.containsNaN()) {
            arrayBuffer$5.$plus$eq(valueNaN);
            return;
        }
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

