/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockChunkId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d!B\u0010!\u0001\tB\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006\t\u0002!\tA\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002(\t\u000bE\u0003A\u0011\u0001*\t\r\u0001\u0004\u0001\u0015!\u0003b\u0011\u0019\u0011\b\u0001)A\u0005g\"A\u0011q\u0001\u0001!\u0002\u0013\tI\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005%\u0001\u0002CA\n\u0001\u0001\u0006I!!\u0003\t\u0015\u0005U\u0001\u0001#b\u0001\n\u0013\t9\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA\u001e\u0001\u0011\u0005\u0011q\n\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!!!\u0001\t\u0003\t)\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002(\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAV\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u00030\u0001!\tA!\r\t\u0011\t\u001d\u0003\u0001\"\u0001#\u0005\u0013\u0012\u0011cU3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s\u0015\t\t#%\u0001\u0006tKJL\u0017\r\\5{KJT!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\n\u0003\u0001%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0017!\u00053fM\u0006,H\u000e^*fe&\fG.\u001b>fe\u000e\u0001\u0001C\u0001\u001a4\u001b\u0005\u0001\u0013B\u0001\u001b!\u0005)\u0019VM]5bY&TXM]\u0001\u0005G>tg\r\u0005\u00028q5\t!%\u0003\u0002:E\tI1\u000b]1sW\u000e{gNZ\u0001\u000eK:\u001c'/\u001f9uS>t7*Z=\u0011\u0007)bd(\u0003\u0002>W\t1q\n\u001d;j_:\u00042AK B\u0013\t\u00015FA\u0003BeJ\f\u0017\u0010\u0005\u0002+\u0005&\u00111i\u000b\u0002\u0005\u0005f$X-\u0001\u0004=S:LGO\u0010\u000b\u0005\r\u001eC\u0015\n\u0005\u00023\u0001!)q\u0006\u0002a\u0001c!)Q\u0007\u0002a\u0001m!)!\b\u0002a\u0001wQ\u0019ai\u0013'\t\u000b=*\u0001\u0019A\u0019\t\u000bU*\u0001\u0019\u0001\u001c\u0002\u001d-\u0014\u0018p\\*fe&\fG.\u001b>feB\u0011!gT\u0005\u0003!\u0002\u0012ab\u0013:z_N+'/[1mSj,'/A\u000btKR$UMZ1vYR\u001cE.Y:t\u0019>\fG-\u001a:\u0015\u0005M3\u0006C\u0001\u0016U\u0013\t)6F\u0001\u0003V]&$\b\"B,\b\u0001\u0004A\u0016aC2mCN\u001cHj\\1eKJ\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t1\fgn\u001a\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&LA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018AD:ue&twm\u00117bgN$\u0016m\u001a\t\u0004E\u0016<W\"A2\u000b\u0005\u0011\\\u0013a\u0002:fM2,7\r^\u0005\u0003M\u000e\u0014\u0001b\u00117bgN$\u0016m\u001a\t\u0003Q>t!![7\u0011\u0005)\\S\"A6\u000b\u00051\u0004\u0014A\u0002\u001fs_>$h(\u0003\u0002oW\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tq7&A\u0012qe&l\u0017\u000e^5wK\u0006sG\r\u0015:j[&$\u0018N^3BeJ\f\u0017p\u00117bgN$\u0016mZ:\u0011\u0007!$h/\u0003\u0002vc\n\u00191+\u001a;1\u0005]T\bc\u00012fqB\u0011\u0011P\u001f\u0007\u0001\t%Y\u0018\"!A\u0001\u0002\u000b\u0005APA\u0002`IE\n2!`A\u0001!\tQc0\u0003\u0002\u0000W\t9aj\u001c;iS:<\u0007c\u0001\u0016\u0002\u0004%\u0019\u0011QA\u0016\u0003\u0007\u0005s\u00170A\td_6\u0004(/Z:t\u0005J|\u0017\rZ2bgR\u00042AKA\u0006\u0013\r\tia\u000b\u0002\b\u0005>|G.Z1o\u0003=\u0019w.\u001c9sKN\u001c8\u000b[;gM2,\u0017\u0001D2p[B\u0014Xm]:SI\u0012\u001c\u0018\u0001F2p[B\u0014Xm]:TQV4g\r\\3Ta&dG.\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u0012\u0002\u0005%|\u0017\u0002BA\u0012\u0003;\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002#\u0015t7M]=qi&|g.\u00128bE2,G-\u0006\u0002\u0002\n\u0005Q1-\u00198Vg\u0016\\%/_8\u0015\t\u0005%\u0011Q\u0006\u0005\b\u0003_\u0001\u0002\u0019AA\u0019\u0003\t\u0019G\u000f\r\u0003\u00024\u0005]\u0002\u0003\u00022f\u0003k\u00012!_A\u001c\t-\tI$!\f\u0002\u0002\u0003\u0005)\u0011\u0001?\u0003\u0007}#3'A\u0007hKR\u001cVM]5bY&TXM\u001d\u000b\u0006c\u0005}\u00121\n\u0005\b\u0003_\t\u0002\u0019AA!a\u0011\t\u0019%a\u0012\u0011\t\t,\u0017Q\t\t\u0004s\u0006\u001dCaCA%\u0003\u007f\t\t\u0011!A\u0003\u0002q\u00141a\u0018\u00135\u0011\u001d\ti%\u0005a\u0001\u0003\u0013\t\u0001\"Y;u_BK7m\u001b\u000b\u0006c\u0005E\u0013q\f\u0005\b\u0003'\u0012\u0002\u0019AA+\u0003-YW-_\"mCN\u001cH+Y41\t\u0005]\u00131\f\t\u0005E\u0016\fI\u0006E\u0002z\u00037\"1\"!\u0018\u0002R\u0005\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u001b\t\u000f\u0005\u0005$\u00031\u0001\u0002d\u0005ia/\u00197vK\u000ec\u0017m]:UC\u001e\u0004D!!\u001a\u0002jA!!-ZA4!\rI\u0018\u0011\u000e\u0003\f\u0003W\ny&!A\u0001\u0002\u000b\u0005APA\u0002`IY\nab\u001d5pk2$7i\\7qe\u0016\u001c8\u000f\u0006\u0003\u0002\n\u0005E\u0004bBA:'\u0001\u0007\u0011QO\u0001\bE2|7m[%e!\u0011\t9(! \u000e\u0005\u0005e$bAA>E\u000591\u000f^8sC\u001e,\u0017\u0002BA@\u0003s\u0012qA\u00117pG.LE-\u0001\u0006xe\u0006\u00048\u000b\u001e:fC6$b!!\"\u0002\u0010\u0006E\u0005\u0003BAD\u0003\u0017k!!!#\u000b\u0007\u0005}A,\u0003\u0003\u0002\u000e\u0006%%aC%oaV$8\u000b\u001e:fC6Dq!a\u001d\u0015\u0001\u0004\t)\bC\u0004\u0002\u0014R\u0001\r!!\"\u0002\u0003M$b!a&\u0002\u001e\u0006}\u0005\u0003BAD\u00033KA!a'\u0002\n\naq*\u001e;qkR\u001cFO]3b[\"9\u00111O\u000bA\u0002\u0005U\u0004bBAJ+\u0001\u0007\u0011qS\u0001\u0012oJ\f\u0007OR8s\u000b:\u001c'/\u001f9uS>tG\u0003BAC\u0003KCq!a%\u0017\u0001\u0004\t)\t\u0006\u0003\u0002\u0018\u0006%\u0006bBAJ/\u0001\u0007\u0011qS\u0001\u0013oJ\f\u0007OR8s\u0007>l\u0007O]3tg&|g\u000e\u0006\u0004\u0002\u0018\u0006=\u0016\u0011\u0017\u0005\b\u0003gB\u0002\u0019AA;\u0011\u001d\t\u0019\n\u0007a\u0001\u0003/#b!!\"\u00026\u0006]\u0006bBA:3\u0001\u0007\u0011Q\u000f\u0005\b\u0003'K\u0002\u0019AAC\u0003M!\u0017\r^1TKJL\u0017\r\\5{KN#(/Z1n+\u0011\ti,!3\u0015\u0011\u0005}\u0016QZAh\u0003'$2aUAa\u0011%\t\u0019MGA\u0001\u0002\b\t)-\u0001\u0006fm&$WM\\2fIE\u0002BAY3\u0002HB\u0019\u00110!3\u0005\r\u0005-'D1\u0001}\u0005\u0005!\u0006bBA:5\u0001\u0007\u0011Q\u000f\u0005\b\u0003#T\u0002\u0019AAL\u00031yW\u000f\u001e9viN#(/Z1n\u0011\u001d\t)N\u0007a\u0001\u0003/\faA^1mk\u0016\u001c\bCBAm\u0003G\f9M\u0004\u0003\u0002\\\u0006}gb\u00016\u0002^&\tA&C\u0002\u0002b.\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0006\u001d(\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\u00058&A\u0007eCR\f7+\u001a:jC2L'0Z\u000b\u0005\u0003[\u00149\u0001\u0006\u0004\u0002p\n%!1\u0002\u000b\u0005\u0003c\fy\u0010\u0005\u0003\u0002t\u0006mXBAA{\u0015\u0011\ty\"a>\u000b\u0007\u0005e(%\u0001\u0003vi&d\u0017\u0002BA\u007f\u0003k\u0014\u0011c\u00115v].,GMQ=uK\n+hMZ3s\u0011%\u0011\taGA\u0001\u0002\b\u0011\u0019!\u0001\u0006fm&$WM\\2fII\u0002BAY3\u0003\u0006A\u0019\u0011Pa\u0002\u0005\r\u0005-7D1\u0001}\u0011\u001d\t\u0019h\u0007a\u0001\u0003kBq!!6\u001c\u0001\u0004\u0011i\u0001\u0005\u0004\u0002Z\u0006\r(QA\u0001\"I\u0006$\u0018mU3sS\u0006d\u0017N_3XSRDW\t\u001f9mS\u000eLGo\u00117bgN$\u0016m\u001a\u000b\t\u0003c\u0014\u0019B!\u0006\u0003\"!9\u00111\u000f\u000fA\u0002\u0005U\u0004bBAk9\u0001\u0007!q\u0003\u0019\u0005\u00053\u0011i\u0002\u0005\u0004\u0002Z\u0006\r(1\u0004\t\u0004s\nuAa\u0003B\u0010\u0005+\t\t\u0011!A\u0003\u0002q\u00141a\u0018\u00138\u0011\u001d\u0011\u0019\u0003\ba\u0001\u0005K\t\u0001b\u00197bgN$\u0016m\u001a\u0019\u0005\u0005O\u0011Y\u0003\u0005\u0003cK\n%\u0002cA=\u0003,\u0011Y!Q\u0006B\u0011\u0003\u0003\u0005\tQ!\u0001}\u0005\ryF\u0005O\u0001\u0016I\u0006$\u0018\rR3tKJL\u0017\r\\5{KN#(/Z1n+\u0011\u0011\u0019Da\u000f\u0015\r\tU\"\u0011\tB\")\u0011\u00119D!\u0010\u0011\r\u0005e\u00171\u001dB\u001d!\rI(1\b\u0003\u0007\u0003\u0017l\"\u0019\u0001?\t\u000f\t\rR\u00041\u0001\u0003@A!!-\u001aB\u001d\u0011\u001d\t\u0019(\ba\u0001\u0003kBqA!\u0012\u001e\u0001\u0004\t))A\u0006j]B,Ho\u0015;sK\u0006l\u0017\u0001\u00072m_\u000e\\7+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[V!!1\nB.)\u0019\u0011iE!\u0018\u0003`Q!!q\nB+!\r\u0011$\u0011K\u0005\u0004\u0005'\u0002#aE*fe&\fG.\u001b>bi&|gn\u0015;sK\u0006l\u0007b\u0002B\u0012=\u0001\u0007!q\u000b\t\u0005E\u0016\u0014I\u0006E\u0002z\u00057\"a!a3\u001f\u0005\u0004a\bbBA:=\u0001\u0007\u0011Q\u000f\u0005\b\u0003#t\u0002\u0019AAL\u0001")
public class SerializerManager {
    private CompressionCodec compressionCodec;
    private final Serializer defaultSerializer;
    private final SparkConf conf;
    private final Option<byte[]> encryptionKey;
    private final KryoSerializer kryoSerializer;
    private final ClassTag<String> stringClassTag;
    private final Set<ClassTag<?>> primitiveAndPrimitiveArrayClassTags;
    private final boolean compressBroadcast;
    private final boolean compressShuffle;
    private final boolean compressRdds;
    private final boolean compressShuffleSpill;
    private volatile boolean bitmap$0;

    public void setDefaultClassLoader(ClassLoader classLoader) {
        this.kryoSerializer.setDefaultClassLoader(classLoader);
    }

    private CompressionCodec compressionCodec$lzycompute() {
        SerializerManager serializerManager = this;
        synchronized (serializerManager) {
            if (!this.bitmap$0) {
                this.compressionCodec = CompressionCodec$.MODULE$.createCodec(this.conf);
                this.bitmap$0 = true;
            }
        }
        return this.compressionCodec;
    }

    private CompressionCodec compressionCodec() {
        if (!this.bitmap$0) {
            return this.compressionCodec$lzycompute();
        }
        return this.compressionCodec;
    }

    public boolean encryptionEnabled() {
        return this.encryptionKey.isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseKryo(ClassTag<?> ct) {
        if (this.primitiveAndPrimitiveArrayClassTags.contains(ct)) return true;
        ClassTag<?> classTag = ct;
        ClassTag<String> classTag2 = this.stringClassTag;
        if (classTag != null) {
            if (!classTag.equals(classTag2)) return false;
            return true;
        }
        if (classTag2 == null) return true;
        return false;
    }

    public Serializer getSerializer(ClassTag<?> ct, boolean autoPick) {
        if (autoPick && this.canUseKryo(ct)) {
            return this.kryoSerializer;
        }
        return this.defaultSerializer;
    }

    public Serializer getSerializer(ClassTag<?> keyClassTag, ClassTag<?> valueClassTag) {
        if (this.canUseKryo(keyClassTag) && this.canUseKryo(valueClassTag)) {
            return this.kryoSerializer;
        }
        return this.defaultSerializer;
    }

    private boolean shouldCompress(BlockId blockId) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            return this.compressShuffle;
        }
        if (blockId2 instanceof ShuffleBlockChunkId) {
            return this.compressShuffle;
        }
        if (blockId2 instanceof BroadcastBlockId) {
            return this.compressBroadcast;
        }
        if (blockId2 instanceof RDDBlockId) {
            return this.compressRdds;
        }
        if (blockId2 instanceof TempLocalBlockId) {
            return this.compressShuffleSpill;
        }
        if (blockId2 instanceof TempShuffleBlockId) {
            return this.compressShuffle;
        }
        if (blockId2 instanceof ShuffleBlockBatchId) {
            return this.compressShuffle;
        }
        return false;
    }

    public InputStream wrapStream(BlockId blockId, InputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public OutputStream wrapStream(BlockId blockId, OutputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public InputStream wrapForEncryption(InputStream s) {
        return (InputStream)this.encryptionKey.map((Function1 & Serializable)key -> CryptoStreamUtils$.MODULE$.createCryptoInputStream(s, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable)() -> s);
    }

    public OutputStream wrapForEncryption(OutputStream s) {
        return (OutputStream)this.encryptionKey.map((Function1 & Serializable)key -> CryptoStreamUtils$.MODULE$.createCryptoOutputStream(s, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable)() -> s);
    }

    public OutputStream wrapForCompression(BlockId blockId, OutputStream s) {
        if (this.shouldCompress(blockId)) {
            return this.compressionCodec().compressedOutputStream(s);
        }
        return s;
    }

    public InputStream wrapForCompression(BlockId blockId, InputStream s) {
        if (this.shouldCompress(blockId)) {
            return this.compressionCodec().compressedInputStream(s);
        }
        return s;
    }

    public <T> void dataSerializeStream(BlockId blockId, OutputStream outputStream, Iterator<T> values, ClassTag<T> evidence$1) {
        BufferedOutputStream byteStream = new BufferedOutputStream(outputStream);
        this.blockSerializationStream(blockId, byteStream, (ClassTag)Predef$.MODULE$.implicitly(evidence$1)).writeAll(values, evidence$1).close();
    }

    public <T> ChunkedByteBuffer dataSerialize(BlockId blockId, Iterator<T> values, ClassTag<T> evidence$2) {
        return this.dataSerializeWithExplicitClassTag(blockId, values, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
    }

    public ChunkedByteBuffer dataSerializeWithExplicitClassTag(BlockId blockId, Iterator<Object> values, ClassTag<?> classTag) {
        ChunkedByteBufferOutputStream bbos = new ChunkedByteBufferOutputStream(0x400000, (Function1<Object, ByteBuffer>)(Function1 & Serializable)x$1 -> SerializerManager.$anonfun$dataSerializeWithExplicitClassTag$1(BoxesRunTime.unboxToInt((Object)x$1)));
        BufferedOutputStream byteStream = new BufferedOutputStream(bbos);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer(classTag, autoPick).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values, ClassTag$.MODULE$.Any()).close();
        return bbos.toChunkedByteBuffer();
    }

    public <T> Iterator<T> dataDeserializeStream(BlockId blockId, InputStream inputStream, ClassTag<T> classTag) {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        return this.getSerializer(classTag, autoPick).newInstance().deserializeStream(this.wrapForCompression(blockId, stream)).asIterator();
    }

    public <T> SerializationStream blockSerializationStream(BlockId blockId, OutputStream outputStream, ClassTag<T> classTag) {
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer(classTag, autoPick).newInstance();
        return ser.serializeStream(this.wrapForCompression(blockId, outputStream));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$dataSerializeWithExplicitClassTag$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf, Option<byte[]> encryptionKey) {
        this.defaultSerializer = defaultSerializer;
        this.conf = conf;
        this.encryptionKey = encryptionKey;
        this.kryoSerializer = new KryoSerializer(conf);
        this.stringClassTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(String.class));
        Set primitiveClassTags = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClassTag[]{ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Byte(), ClassTag$.MODULE$.Char(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Float(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.Short()}));
        Set arrayClassTags = (Set)primitiveClassTags.map((Function1 & Serializable)x$1 -> x$1.wrap());
        this.primitiveAndPrimitiveArrayClassTags = (Set)primitiveClassTags.$plus$plus((IterableOnce)arrayClassTags);
        this.compressBroadcast = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.BROADCAST_COMPRESS()));
        this.compressShuffle = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_COMPRESS()));
        this.compressRdds = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.RDD_COMPRESS()));
        this.compressShuffleSpill = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_SPILL_COMPRESS()));
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf) {
        this(defaultSerializer, conf, (Option<byte[]>)None$.MODULE$);
    }
}

