/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.memory.UnmanagedMemoryConsumer;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg!B\u0015+\u00011\u0012\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!Q1A\u0005\u0002\u0011C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u000b\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003R\u0001\u0011\u0005!\u000bC\u0004Y\u0001\t\u0007I\u0011\u0002#\t\re\u0003\u0001\u0015!\u0003F\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015\t\u0007\u0001\"\u0003c\u0011\u00151\u0007\u0001\"\u0011E\u0011\u00159\u0007\u0001\"\u0011E\u0011\u0019A\u0007\u0001\"\u0011+S\")q\u000e\u0001C!a\")a\u0010\u0001C!\u007f\u001e9\u0011q\u0001\u0016\t\u0002\u0005%aAB\u0015+\u0011\u0003\tY\u0001\u0003\u0004R#\u0011\u0005\u00111\u0003\u0005\n\u0003+\t\"\u0019!C\u0005\u0003/Aq!!\u0007\u0012A\u0003%a\nC\u0005\u0002\u001cE\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011qH\t!\u0002\u0013\ty\u0002C\u0005\u0002BE\u0011\r\u0011\"\u0003\u0002D!A\u0011\u0011K\t!\u0002\u0013\t)\u0005C\u0005\u0002TE\u0011\r\u0011\"\u0003\u0002D!A\u0011QK\t!\u0002\u0013\t)\u0005C\u0005\u0002XE\u0011\r\u0011\"\u0003\u0002Z!A\u0011\u0011M\t!\u0002\u0013\tY\u0006C\u0004\u0002dE!\t!!\u001a\t\u0011\u0005-\u0014\u0003\"\u0001-\u0003[Bq!!\u001d\u0012\t\u0003\t\u0019\b\u0003\u0004\u0002\u0010F!\tA\u0019\u0005\f\u0003#\u000b\u0002\u0019!a\u0001\n\u0013\t\u0019\nC\u0006\u0002\u001cF\u0001\r\u00111A\u0005\n\u0005u\u0005bCAR#\u0001\u0007\t\u0011)Q\u0005\u0003+C\u0001\"!,\u0012\t\u0003Q\u0013q\u0016\u0005\u0007\u0003k\u000bB\u0011\u00022\t\u000f\u0005]\u0016\u0003\"\u0001-E\"9\u0011\u0011X\t\u0005\u0002\u0005m\u0006bBAa#\u0011%\u00111\u0019\u0002\u0015+:Lg-[3e\u001b\u0016lwN]=NC:\fw-\u001a:\u000b\u0005-b\u0013AB7f[>\u0014\u0018P\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h'\r\u00011g\u000e\t\u0003iUj\u0011AK\u0005\u0003m)\u0012Q\"T3n_JLX*\u00198bO\u0016\u0014\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e-\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001f:\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001C\u0001!B\u001b\u0005a\u0013B\u0001\"-\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\u0007nCbDU-\u00199NK6|'/_\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n!Aj\u001c8h\u00039i\u0017\r\u001f%fCBlU-\\8ss\u0002\nqc\u001c8IK\u0006\u00048\u000b^8sC\u001e,'+Z4j_:\u001c\u0016N_3\u0002\u00119,XnQ8sKN\u0004\"AR(\n\u0005A;%aA%oi\u00061A(\u001b8jiz\"Ra\u0015+V-^\u0003\"\u0001\u000e\u0001\t\u000bu2\u0001\u0019A \t\u000b\r3\u0001\u0019A#\t\u000b13\u0001\u0019A#\t\u000b53\u0001\u0019\u0001(\u0002AUtW.\u00198bO\u0016$W*Z7pef\u0004v\u000e\u001c7j]\u001eLe\u000e^3sm\u0006dWj]\u0001\"k:l\u0017M\\1hK\u0012lU-\\8ssB{G\u000e\\5oO&sG/\u001a:wC2l5\u000fI\u0001\u0017O\u0016$XK\\7b]\u0006<W\rZ'f[>\u0014\u00180V:fIR\u0011Q\t\u0018\u0005\u0006;&\u0001\rAX\u0001\u000b[\u0016lwN]=N_\u0012,\u0007C\u0001\u001b`\u0013\t\u0001'F\u0001\u0006NK6|'/_'pI\u0016\f\u0001#Y:tKJ$\u0018J\u001c<be&\fg\u000e^:\u0015\u0003\r\u0004\"A\u00123\n\u0005\u0015<%\u0001B+oSR\fa#\\1y\u001f:DU-\u00199Ti>\u0014\u0018mZ3NK6|'/_\u0001\u0018[\u0006DxJ\u001a4IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\fa#Y2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\u0005\u000b*dg\u000eC\u0003l\u001b\u0001\u0007Q)\u0001\u0005ok6\u0014\u0015\u0010^3t\u0011\u0015iW\u00021\u0001F\u00035!\u0018m]6BiR,W\u000e\u001d;JI\")Q,\u0004a\u0001=\u0006!\u0012mY9vSJ,7\u000b^8sC\u001e,W*Z7pef$B!\u001d;}{B\u0011aI]\u0005\u0003g\u001e\u0013qAQ8pY\u0016\fg\u000eC\u0003v\u001d\u0001\u0007a/A\u0004cY>\u001c7.\u00133\u0011\u0005]TX\"\u0001=\u000b\u0005ed\u0013aB:u_J\fw-Z\u0005\u0003wb\u0014qA\u00117pG.LE\rC\u0003l\u001d\u0001\u0007Q\tC\u0003^\u001d\u0001\u0007a,A\nbGF,\u0018N]3V]J|G\u000e\\'f[>\u0014\u0018\u0010F\u0004r\u0003\u0003\t\u0019!!\u0002\t\u000bU|\u0001\u0019\u0001<\t\u000b-|\u0001\u0019A#\t\u000bu{\u0001\u0019\u00010\u0002)Us\u0017NZ5fI6+Wn\u001c:z\u001b\u0006t\u0017mZ3s!\t!\u0014c\u0005\u0003\u0012\u0003\u001b9\u0004c\u0001$\u0002\u0010%\u0019\u0011\u0011C$\u0003\r\u0005s\u0017PU3g)\t\tI!\u0001\u000fS\u000bN+%KV#E?NK6\u000bV#N?6+Uj\u0014*Z?\nKF+R*\u0016\u00039\u000bQDU#T\u000bJ3V\tR0T3N#V)T0N\u000b6{%+W0C3R+5\u000bI\u0001\u0019k:l\u0017M\\1hK\u0012lU-\\8ss\u000e{gn];nKJ\u001cXCAA\u0010!!\t\t#a\f\u00024\u0005eRBAA\u0012\u0015\u0011\t)#a\n\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002*\u0005-\u0012\u0001B;uS2T!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t\u0019CA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042\u0001NA\u001b\u0013\r\t9D\u000b\u0002\u001a+:l\u0017M\\1hK\u0012lU-\\8ss\u000e{gn];nKJLE\rE\u00025\u0003wI1!!\u0010+\u0005])f.\\1oC\u001e,G-T3n_JL8i\u001c8tk6,'/A\rv]6\fg.Y4fI6+Wn\u001c:z\u0007>t7/^7feN\u0004\u0013aE;o[\u0006t\u0017mZ3e\u001f:DU-\u00199Vg\u0016$WCAA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#\u0002BA&\u0003G\ta!\u0019;p[&\u001c\u0017\u0002BA(\u0003\u0013\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0003Q)h.\\1oC\u001e,Gm\u00148IK\u0006\u0004Xk]3eA\u0005!RO\\7b]\u0006<W\rZ(gM\"+\u0017\r]+tK\u0012\fQ#\u001e8nC:\fw-\u001a3PM\u001aDU-\u00199Vg\u0016$\u0007%\u0001\bq_2d\u0017N\\4Ti\u0006\u0014H/\u001a3\u0016\u0005\u0005m\u0003\u0003BA$\u0003;JA!a\u0018\u0002J\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq\u0002]8mY&twm\u0015;beR,G\rI\u0001 e\u0016<\u0017n\u001d;feVsW.\u00198bO\u0016$W*Z7pef\u001cuN\\:v[\u0016\u0014HcA2\u0002h!9\u0011\u0011N\u000fA\u0002\u0005e\u0012aF;o[\u0006t\u0017mZ3e\u001b\u0016lwN]=D_:\u001cX/\\3s\u0003\u0005*hN]3hSN$XM]+o[\u0006t\u0017mZ3e\u001b\u0016lwN]=D_:\u001cX/\\3s)\r\u0019\u0017q\u000e\u0005\b\u0003Sr\u0002\u0019AA\u001d\u0003a9W\r^'f[>\u0014\u0018PQ=D_6\u0004xN\\3oiRK\b/\u001a\u000b\u0004\u000b\u0006U\u0004bBA<?\u0001\u0007\u0011\u0011P\u0001\u000eG>l\u0007o\u001c8f]R$\u0016\u0010]3\u0011\t\u0005m\u0014\u0011\u0012\b\u0005\u0003{\n)\tE\u0002\u0002\u0000\u001dk!!!!\u000b\u0007\u0005\re(\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000f;\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00065%AB*ue&twMC\u0002\u0002\b\u001e\u000b\u0011d\u00197fCJ,f.\\1oC\u001e,G-T3n_JLXk]3sg\u0006)RO\\7b]\u0006<W\rZ'f[>\u0014\u0018\u0010U8mY\u0016\u0014XCAAK!\u0011\t\t#a&\n\t\u0005e\u00151\u0005\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!G;o[\u0006t\u0017mZ3e\u001b\u0016lwN]=Q_2dWM]0%KF$2aYAP\u0011%\t\tKIA\u0001\u0002\u0004\t)*A\u0002yIE\na#\u001e8nC:\fw-\u001a3NK6|'/\u001f)pY2,'\u000f\t\u0015\u0004G\u0005\u001d\u0006c\u0001$\u0002*&\u0019\u00111V$\u0003\u0011Y|G.\u0019;jY\u0016\fAc\u001d;beR\u0004v\u000e\u001c7j]\u001eLeMT3fI\u0016$GcA2\u00022\"1\u00111\u0017\u0013A\u0002\u0015\u000b\u0011\u0003]8mY&tw-\u00138uKJ4\u0018\r\\'t\u0003a\u0001x\u000e\u001c7V]6\fg.Y4fI6+Wn\u001c:z+N,'o]\u0001\u001eg\",H\u000fZ8x]VsW.\u00198bO\u0016$W*Z7pef\u0004v\u000e\u001c7fe\u0006)\u0011\r\u001d9msR)1+!0\u0002@\")Qh\na\u0001\u007f!)Qj\na\u0001\u001d\u0006aq-\u001a;NCblU-\\8ssR\u0019Q)!2\t\u000buB\u0003\u0019A ")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxHeapMemory;
    private final long onHeapStorageRegionSize;
    private final long unmanagedMemoryPollingIntervalMs;

    public static UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        return UnifiedMemoryManager$.MODULE$.apply(conf, numCores);
    }

    public static void clearUnmanagedMemoryUsers() {
        UnifiedMemoryManager$.MODULE$.clearUnmanagedMemoryUsers();
    }

    public static long getMemoryByComponentType(String componentType) {
        return UnifiedMemoryManager$.MODULE$.getMemoryByComponentType(componentType);
    }

    public static void registerUnmanagedMemoryConsumer(UnmanagedMemoryConsumer unmanagedMemoryConsumer) {
        UnifiedMemoryManager$.MODULE$.registerUnmanagedMemoryConsumer(unmanagedMemoryConsumer);
    }

    public long maxHeapMemory() {
        return this.maxHeapMemory;
    }

    private long unmanagedMemoryPollingIntervalMs() {
        return this.unmanagedMemoryPollingIntervalMs;
    }

    private long getUnmanagedMemoryUsed(MemoryMode memoryMode) {
        if (this.unmanagedMemoryPollingIntervalMs() <= 0L) {
            return 0L;
        }
        MemoryMode memoryMode2 = memoryMode;
        if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
            return UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOnHeapUsed().get();
        }
        if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
            return UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$unmanagedOffHeapUsed().get();
        }
        throw new MatchError((Object)memoryMode2);
    }

    private void assertInvariants() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.onHeapStorageMemoryPool().poolSize() == this.maxHeapMemory());
        Predef$.MODULE$.assert(this.offHeapExecutionMemoryPool().poolSize() + this.offHeapStorageMemoryPool().poolSize() == this.maxOffHeapMemory());
    }

    @Override
    public synchronized long maxOnHeapStorageMemory() {
        return this.maxHeapMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long maxOffHeapStorageMemory() {
        return this.maxOffHeapMemory() - this.offHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        Tuple4 tuple4;
        this.assertInvariants();
        Predef$.MODULE$.assert(numBytes >= 0L);
        MemoryMode memoryMode2 = memoryMode;
        if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
            tuple4 = new Tuple4((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.onHeapStorageRegionSize), (Object)BoxesRunTime.boxToLong((long)this.maxHeapMemory()));
        } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
            tuple4 = new Tuple4((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.offHeapStorageMemory()), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple42._1();
        StorageMemoryPool storagePool = (StorageMemoryPool)tuple42._2();
        long storageRegionSize = BoxesRunTime.unboxToLong((Object)tuple42._3());
        long maxMemory = BoxesRunTime.unboxToLong((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)storageRegionSize), (Object)BoxesRunTime.boxToLong((long)maxMemory));
        ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple43._1();
        StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple43._2();
        long storageRegionSize2 = BoxesRunTime.unboxToLong((Object)tuple43._3());
        long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple43._4());
        return executionPool2.acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)extraMemoryNeeded -> UnifiedMemoryManager.maybeGrowExecutionPool$1(extraMemoryNeeded, storagePool2, storageRegionSize2, executionPool2), (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.computeMaxExecutionPoolSize$1(memoryMode, maxMemory2, storagePool2, storageRegionSize2));
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        StorageMemoryPool storagePool;
        block6: {
            Tuple3 tuple3;
            this.assertInvariants();
            Predef$.MODULE$.assert(numBytes >= 0L);
            MemoryMode memoryMode2 = memoryMode;
            if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
                tuple3 = new Tuple3((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOnHeapStorageMemory()));
            } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
                tuple3 = new Tuple3((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapStorageMemory()));
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple32._1();
            StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple32._2();
            long maxMemory = BoxesRunTime.unboxToLong((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)executionPool, (Object)storagePool2, (Object)BoxesRunTime.boxToLong((long)maxMemory));
            ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple33._1();
            storagePool = (StorageMemoryPool)tuple33._2();
            long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            long unmanagedMemory = this.getUnmanagedMemoryUsed(memoryMode);
            long effectiveMaxMemory = package$.MODULE$.max(0L, maxMemory2 - unmanagedMemory);
            if (numBytes > effectiveMaxMemory) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_ID, blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" (", " bytes) exceeds our"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)numBytes))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" memory limit (", " bytes)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES_MAX, BoxesRunTime.boxToLong((long)effectiveMaxMemory))}))).$plus(unmanagedMemory > 0L ? this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" (unmanaged memory usage: ", " bytes)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)unmanagedMemory))})) : this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))).log((Seq)Nil$.MODULE$))));
                return false;
            }
            if (numBytes <= storagePool.memoryFree()) break block6;
            long memoryBorrowedFromExecution = Math.min(executionPool2.memoryFree(), numBytes - storagePool.memoryFree());
            executionPool2.decrementPoolSize(memoryBorrowedFromExecution);
            storagePool.incrementPoolSize(memoryBorrowedFromExecution);
        }
        return storagePool.acquireMemory(blockId, numBytes);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        return this.acquireStorageMemory(blockId, numBytes, memoryMode);
    }

    private static final void maybeGrowExecutionPool$1(long extraMemoryNeeded, StorageMemoryPool storagePool$1, long storageRegionSize$1, ExecutionMemoryPool executionPool$1) {
        if (extraMemoryNeeded > 0L) {
            long memoryReclaimableFromStorage = package$.MODULE$.max(storagePool$1.memoryFree(), storagePool$1.poolSize() - storageRegionSize$1);
            if (memoryReclaimableFromStorage > 0L) {
                long spaceToReclaim = storagePool$1.freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
                storagePool$1.decrementPoolSize(spaceToReclaim);
                executionPool$1.incrementPoolSize(spaceToReclaim);
                return;
            }
            return;
        }
    }

    private final long computeMaxExecutionPoolSize$1(MemoryMode memoryMode$1, long maxMemory$1, StorageMemoryPool storagePool$1, long storageRegionSize$1) {
        long unmanagedMemory = this.getUnmanagedMemoryUsed(memoryMode$1);
        long availableMemory = maxMemory$1 - package$.MODULE$.min(storagePool$1.memoryUsed(), storageRegionSize$1);
        return package$.MODULE$.max(0L, availableMemory - unmanagedMemory);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxHeapMemory, long onHeapStorageRegionSize, int numCores) {
        this.maxHeapMemory = maxHeapMemory;
        this.onHeapStorageRegionSize = onHeapStorageRegionSize;
        super(conf, numCores, onHeapStorageRegionSize, maxHeapMemory - onHeapStorageRegionSize);
        this.unmanagedMemoryPollingIntervalMs = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.UNMANAGED_MEMORY_POLLING_INTERVAL()));
        if (this.unmanagedMemoryPollingIntervalMs() > 0L) {
            UnifiedMemoryManager$.MODULE$.startPollingIfNeeded(this.unmanagedMemoryPollingIntervalMs());
        }
        this.assertInvariants();
    }
}

